;===============================================================================
; dave_defs_checkout
;
; PURPOSE:
;   Certain user settings are saved between DAVE sessions. This
;   routine ensures that the saved structure has all the proper
;   fields.
;
; PARAMETERS:
;   dave_defs [in] - An IDL structure conatining the session variables
;                    fields to be saved.
;
; RETURN VALUE:
;   status flag. Insignificant.
;
function dave_defs_checkout, dave_defs
; RTA - completely revamp code to insert the necessary tags in the
;       dave_defs structure instead of simply checking.
;
; "WEB_BROWSER" tag added 2-4-04 (RMD)
cd,current=cwd
tags_present = strupcase(tag_names(dave_defs))
; insert 'datDir' field if necessary
void = where(tags_present eq 'DATDIR', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'datDir', cwd)
; insert 'workDir' field if necessary
void = where(tags_present eq 'WORKDIR', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'workDir', cwd)
; insert PDF Reader field if necessary
void = where(tags_present eq 'PDFREADER', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'PDFReader', '')
; insert Web Browser field if necessary
void = where(tags_present eq 'WEB_BROWSER', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'web_browser', '')
; insert classic field if necessary
void = where(tags_present eq 'CLASSIC', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'classic', 1B)
; insert show_choice field if necessary
void = where(tags_present eq 'SHOW_CHOICE', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'show_choice', 1B)
; insert tree menu pointer field if necessary
void = where(tags_present eq 'TREE_MENU_POINTER', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'tree_menu_pointer', ptr_new(/allocate_heap))
; insert 'psd_a4_spacing' field if necessary
void = where(strlowcase(tags_present) eq 'psd_a4_spacing', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'psd_a4_spacing','')
; insert 'psd_channel_Eff' field if necessary
void = where(strlowcase(tags_present) eq 'psd_channel_eff', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'psd_channel_eff','')
; insert 'psd_Ef_spacing' field if necessary
void = where(strlowcase(tags_present) eq 'psd_ef_spacing', count)
if (count le 0) then dave_defs = create_struct(dave_defs, 'psd_ef_spacing', '')

return, 1

end
