; $Id$
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;
; Written by J.R.D. Copley.
;************************************************************************************************
pro dave_beast_ops_test
;************************************************************************************************
; This procedure tests the "dave_beast_ops" procedure.
;
compile_opt strictarr
;
;
for k=0,1 do begin
	specific={spa:fltarr(3,4,5),zptr:ptr_new(0)}
	hist={ha:fltarr(11),hb:findgen(90,2),hc:3,hd:dblarr(4,4)}
	commonStr={cmna:1,histPtr:ptr_new(hist),cmnc:3,cmnd:4,treatmentPtr:ptr_new("treat")}
	dataStr={commonStr:commonStr,specificPtr:ptr_new(specific)}
	beastA={sta:1,stb:2,dataStrPtr:ptr_new(dataStr)}
;
	if (k eq 1) then beastA=ptr_new(beastA)
;
	dave_beast_ops,"duplicate",beastA,beastB,/screen
	dave_beast_ops,"clear",beastA,/screen
	dave_beast_ops,"remove",beastB,/screen
	dave_beast_ops,"copy",beastA,/screen ; ("copy" is not an allowed operation)
	ptr_free,ptr_valid()
endfor
;
end

