; $Id$

;This is a checkbock widget that provides any number of checkboxes desired, 
;and each checkbox can be color coded to match, e.g. the color of data in a plot,
;and specifically in a cwo_drawplot_class object.



function cwo_lk_multicheckbox_event,event

    stash = widget_info(event.handler,/child)
    widget_control,stash,get_uvalue=obj


    new_event = obj->event(event)

    return,new_event

end;cwo_lk_multicheckbox_event

function cwo_lk_multicheckbox::event,event

    motion = 1
    check = 0
    enter = 0
    exit = 0
    if tag_names(event,/structure_name) eq 'WIDGET_TRACKING' then begin

        ;SET MOUSE TO POINTER

        if event.enter eq 1 then begin
            enter = 1
            exit = 0
        endif else begin
            enter = 0
            exit = 1
        endelse
        new_event = {   id:self.tlb,top:self.parent,handler:self.parent,checked:*self.checked,$
                                        motion:motion,check:check,enter:enter,exit:exit}

        ;return,new_event
        return,-1   ;SWALLOW ENTER/EXIT

    endif else begin
        if event.press ne 0 then begin

            motion = 0
            incheckbox    = self->inCheckbox(event,index=index)
            wh_incheckbox = where(incheckbox gt 0,wh_count)

            if index ne -1 then begin
                (*self.checked)[index] = (((*self.checked)[index] eq 1) ? 0 : 1)
                checked = *self.checked
                self->draw
            endif;inCheckbox
            motion = 0
            check = 1
            new_event = {   id:self.tlb,top:self.parent,handler:self.parent,checked:*self.checked,$
                            motion:motion,check:check,enter:enter,exit:exit}
        endif else begin

            motion = 1
;            ;SET TOP AND HANDLER TO 0L TO SWALLOW THE EVENT.
            new_event = {   id:self.tlb,top:self.parent,handler:self.parent,checked:*self.checked,$
                            motion:motion,check:check,enter:enter,exit:exit}

            return,-1   ;SWALLOW MOTIONS
        endelse

        return,new_event
    endelse

end;cwo_lk_multicheckbox_event
function cwo_lk_multicheckbox::inCheckbox,event,index=index

    index = -1

    height = self.checkboxheight/4
    width =  self.checkboxheight/4

    xcen = self.checkboxheight/2
    ycen = self.checkboxheight/2   ;SET YSIZE/CHECKBOX EQUAL TO 20      self.ysize/2

    totalheight = self.nboxes*self.checkboxheight


    incheckbox = intarr(self.nboxes)
    for i=0,self.nboxes-1 do begin
        xmax = xcen+width
        xmin = xcen-width

        ycen = totalheight - i*self.checkboxheight - self.checkboxheight/2


        ymax = ycen+height
        ymin = ycen-height

        if event.x le xmax and event.x ge xmin and $
           event.y le ymax and event.y ge ymin then begin
                incheckbox[i] = 1
                index = i
        endif else begin
                incheckbox[i] = 0
        endelse
    endfor;i

    return,incheckbox

end;cwo_lk_multicheckbox::inCheckbox


pro cwo_lk_multicheckbox_set_value,id,value

    print,'SET_VALUE: DO_NOTHING'
;    widget_control,widget_info(id,/child),get_uvalue=obj
;    obj->setproperty,checked = value

end;cwo_lk_multicheckbox_set_value
function cwo_lk_multicheckbox_get_value,id

    widget_control,widget_info(id,/child),get_uvalue=obj
    return,obj

;    obj->getproperty,checked = value
;    return,value

end;cwo_lk_multicheckbox_get_value


pro cwo_lk_multicheckbox::drawCheckboxAndText


    device,get_decomposed=dc
    device,decomposed=1


    for i=0,self.nboxes-1 do begin
        color = (*self.color)[i]
        if color eq 0L or color gt (self.green + self.red) then $
                textcolor = self.white else $
                textcolor = self.black

        yoffset = self.ysize - (i+1)*self.checkboxheight

        ;COLOR IN THE WINDOW
        xfill = [0,1,1,0,0]
        yfill = [0,0,1,1,0]

        xfill = xfill*self.xsize
        yfill = yfill*self.checkboxheight + yoffset

        polyfill,xfill,yfill,color=color,/device,linestyle=0

        ;DRAW THE CHECKBOX
        height = self.checkboxheight/4;5;min([self.xsize/4,self.ysize/4,5])
        width  = self.checkboxheight/4;5;min([self.xsize/4,self.ysize/4,5])

        xcen = self.checkboxheight/2
        ycen = self.checkboxheight/2 + yoffset

        ;JUST BOX
        xbox = [xcen-width, xcen+width, xcen+width, xcen-width, xcen-width ]
        ybox = [ycen-height,ycen-height,ycen+height,ycen+height,ycen-height]
        polyfill,xbox,ybox,color=white,/device,linestyle=0

        if (*self.checked)[i] eq 1 then begin
            ;ADD THE X IF CHECKED
            xbox = [xbox, xcen+width, xcen-width, xcen+width ]
            ybox = [ybox,ycen+height,ycen+height,ycen-height]
        endif

        plots,xbox,ybox,/device,color = 0L,thick=2

        xtext = xcen + self.checkboxheight/2
        ytext = ycen - 3

        xyouts, xtext,ytext,/device,(*self.label)[i],color = textcolor,charsize=1.0
    ;
    ;    framethick = 3
    ;    xframe = xfill*self.xsize
    ;    yframe = yfill*self.ysize
    ;    xframe = xframe + [0,-10*framethick,-10*framethick,0,0]
    ;    yframe = yframe + [0,0,framethick,framethick,0]
    ;
    ;    plots,xframe,yframe,/device,color = 0L,thick=framethick
    endfor;i


    device,decomposed=dc
end;cwo_lk_multicheckbox::drawBoxAndText


pro cwo_lk_multicheckbox::draw

    if widget_info(self.draw,/realized) gt 0 then begin

        wset,self.winpix

        self->drawCheckboxAndText

        wset,self.winvis
        device,copy=[0,0,self.xsize,self.ysize,0,0,self.winpix]
    endif;realized

end;cwo_lk_multicheckbox::draw


function cwo_lk_multicheckbox::getChecked
    return,*self.checked
end;cwo_lk_multicheckbox::getChecked
pro cwo_lk_multicheckbox::setChecked,value
    if n_elements(value) eq 0 then value = *self.checked

    if n_elements(value) ne n_elements(*self.checked) then value = *self.checked
    *self.checked = value
    self->draw
end;cwo_lk_multicheckbox::setChecked

pro cwo_lk_multicheckbox::Check,i
    (*self.checked)[i] = 1
    self->draw
end;cwo_lk_multicheckbox::setChecked
pro cwo_lk_multicheckbox::unCheck,i
    (*self.checked)[i] = 0
    self->draw
end;cwo_lk_multicheckbox::setChecked
pro cwo_lk_multicheckbox::CheckAll
    *self.checked[*] = 1
    self->draw
end;cwo_lk_multicheckbox::setChecked
pro cwo_lk_multicheckbox::unCheckAll
    *self.checked[*] = 0
    self->draw
end;cwo_lk_multicheckbox::setChecked


pro cwo_lk_multicheckbox::getProperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winvis=winvis,$
                winpix=winpix,$
                checked=checked,$
                label=label,$
                xsize=xsize,$
                ysize=ysize,$
                color=color,$
                _ref_extra=extra

    if arg_present(parent)  then parent = self.parent
    if arg_present(color)   then color = self.color
    if arg_present(tlb)     then tlb = self.tlb
    if arg_present(draw)    then draw = self.draw
    if arg_present(winvis)  then winvis = self.winvis
    if arg_present(winpix)  then winpix = self.winpix
    if arg_present(checked) then checked = self.checked
    if arg_present(label)   then label = self.label
    if arg_present(xsize)   then xsize = self.xsize
    if arg_present(ysize)   then ysize = self.ysize

end;cwo_lk_multicheckbox::getProperty
pro cwo_lk_multicheckbox::setProperty,$
                        parent=parent,$
                        tlb=tlb,$
                        draw=draw,$
                        winvis=winvis,$
                        winpix=winpix,$
                        checked=checked,$
                        label=label,$
                        xsize=xsize,$
                        ysize=ysize,$
                        color=color,$
                        _ref_extra=extra

    if n_elements(parent)  gt 0 then self.parent = parent
    if n_elements(color)   gt 0 then self.color = color
    if n_elements(tlb)     gt 0 then self.tlb = tlb
    if n_elements(draw)    gt 0 then self.draw = draw
    if n_elements(winvis)  gt 0 then self.winvis = winvis
    if n_elements(winpix)  gt 0 then self.winpix = winpix
    if n_elements(checked) gt 0 then self.checked = checked
    if n_elements(label)   gt 0 then self.label = label
    if n_elements(xsize)   gt 0 then self.xsize = xsize
    if n_elements(ysize)   gt 0 then self.ysize = ysize

end;cwo_lk_multicheckbox::setProperty

pro cwo_lk_multicheckbox_realize,id
    widget_control,id,get_uvalue=obj
    obj->realize
end;cwo_lk_multicheckbox_realize
pro cwo_lk_multicheckbox::realize

    id = self.draw

    widget_control,id,get_value=winvis
    self.winvis = winvis
    geom = widget_info(id,/geometry)

    window,/free,/pixmap,xsize=geom.xsize,ysize=geom.ysize
    self.winpix = !d.window

    self->draw

end;cwo_lk_multicheckbox::realize
pro cwo_lk_multicheckbox_cleanup,id

    widget_control,id,get_uvalue=obj
    obj_destroy,obj

end;cwo_lk_multicheckbox_cleanup
pro cwo_lk_multicheckbox::cleanup
    print,'cwo_lk_multicheckbox::cleanup'


    ptr_free,self.checked
    ptr_free,self.color
    ptr_free,self.label

    obj_destroy,self.winObj
    obj_destroy,self.view
    obj_destroy,self.model
    obj_destroy,self.textObj
    obj_destroy,self.boxObj

end;cwo_lk_multicheckbox::cleanup

;function cwo_lk_multicheckbox,parent,obj=obj,_ref_extra=extra
;    obj = obj_new('cwo_lk_multicheckbox',parent,_strict_extra=extra)
;    obj->getproperty,tlb=tlb
;    return,tlb
;end;cwo_lk_multicheckbox

function cwo_lk_multicheckbox::init,parent,obj=obj,$
                            tooltip=tooltip,$
                            value=value,$
                            uvalue=uvalue,$
                            uname=uname,$
                            color=color,$
                            label=label,$
                            frame=frame,$
                            xsize=xsize,$
                            ysize=ysize,$
                            xoffset=xoffset,$
                            yoffset=yoffset,$
                            _ref_extra=extra

    if n_elements(label)   eq 0 then label = ''
    if n_elements(tooltip) eq 0 then tooltip = ''
    if n_elements(value)   eq 0 then value = 0
    if n_elements(uvalue)  eq 0 then uvalue = 0
    if n_elements(uname)   eq 0 then uname = 0
    if n_elements(frame)   eq 0 then frame = 1
    if n_elements(xsize)   eq 0 then xsize = 100

    if n_elements(ysize) eq 0 then ysize = 20

    self.black = 0L
    self.red   = 255L
    self.green = 256L*self.red
    self.blue  = 256L*self.green
    self.white = self.red + self.green + self.blue
    self.gray = 100L + 256L*(100L + 256L*100L)

    if n_elements(color) eq 0 then color = self.blue + 100L + 256L*100L

    ptr_free,self.label
    self.label = ptr_new(label)

    self.nboxes = n_elements(*self.label)

    ptr_free,self.color
    self.color = ptr_new(lonarr(self.nboxes)+color)

    ptr_free,self.checked
    self.checked = ptr_new(intarr(self.nboxes))


    self.checkboxheight = ysize
    self.checkboxcenter = 10
;    self.label = ptr_new(label)

    self.xsize = xsize
    self.ysize = self.checkboxheight*self.nboxes





    self.parent = parent


    tlb = widget_base(parent,/col,$
                                uvalue=uvalue,$
                                uname=uname,$
                                xsize=xsize,$
                                ysize=self.ysize,$
                                event_func='cwo_lk_multicheckbox_event',$
                                pro_set_value ='cwo_lk_multicheckbox_set_value',$
                                func_get_value='cwo_lk_multicheckbox_get_value',$
                                frame = 0,$;frame,$
                                xoffset=xoffset,$
                                yoffset=yoffset,$
                                _strict_extra=extra)
    self.tlb = tlb

if n_elements(xoffset) ne 0 then begin
;print,'checkbox init:'
;print,'xOffset=',xoffset
;print,'yOffset=',yoffset
endif

;NEED STASH TO RESERVE value AND uvalue OF tlb FOR THE CALLING PROGRAM.
    draw = widget_draw(tlb,xsize=self.xsize,ysize=self.ysize,$
                                uname='STASH',$
                                kill_notify='cwo_lk_multicheckbox_cleanup',$
                                notify_realize='cwo_lk_multicheckbox_realize',$
                                tooltip=tooltip,$
                                /button_events,$
                                /motion_events,$
                                /tracking_events,$
                                uvalue=self)

    self.draw = draw

    return,1
end;cwo_lk_multicheckbox::init

pro cwo_lk_multicheckbox__define,class

    class = {cwo_lk_multicheckbox,$
                parent:0L,$
                tlb:0L,$
                draw:0L,$
                winvis:0L,$
                winpix:0L,$
                checked:ptr_new(),$
                label:ptr_new(),$
                color:ptr_new(),$
                xoffset:0,$
                yoffset:0,$
                nboxes:0,$
                checkboxheight:0,$
                checkboxcenter:0,$
                black:0L,$
                red:0L,$
                green:0L,$
                blue:0L,$
                white:0L,$
                gray:0L,$
                xsize:0,$
                ysize:0,$               ;MAY NEED THESE FOR CONTROLLING HOW MOUSE LOOKS!!!!
                winObj:obj_new(),$      ;THE OBJECT WINDOW FOR THE CHECKBOX DRAW WINDOW
                view :obj_new(),$     ;THE VIEW
                model:obj_new(),$    ;THE MODEL
                textObj:obj_new(),$     ;THE TEXT OF THE CHECKBOX
                boxObj:obj_new() $      ;THE CHECKBOX WILL BE A PLOT WITH NO AXES
                }

end;cwo_lk_multicheckbox__define



pro cwo_lk_multicheckbox_test_event,event
    ;if tag_names(event,/structure_name) eq 'WIDGET_DRAW' then

    if tag_names(event,/structure_name) eq 'lk_multicheckbox_EVENT' then begin
        if event.motion eq 0 then begin
            print,tag_names(event,/structure_name)
            print,event
        endif
    endif
end;cwo_lk_multicheckbox_test_event
pro cwo_lk_multicheckbox_test


    b = widget_base(xoffset=300,yoffset=300,/col,/grid_layout,title='CWO_lk_multicheckbox_TEST');,xsize = 100,ysize = 100)
    c1 = cwo_lk_multicheckbox(b,tooltip='This is a colorful textbox.',$
                          label = 'CHECKBOX 1',$
                          value=1,$
                          xsize=120,$
                          ysize=20,$
                          uname ='CHECKBOX UNAME',$
                          uvalue='CHECKBOX UVALUE',$
                          obj=obj)
    c2 = cwo_lk_multicheckbox(b,tooltip='This is a colorful textbox.',$
                          label = 'CHECKBOX 2',$
                          xsize=120,$
                          ysize=20,$
                          color = 255L,$
                          value=1,$
                          uname ='CHECKBOX UNAME',$
                          uvalue='CHECKBOX UVALUE',$
                          obj=obj)
    c3 = cwo_lk_multicheckbox(b,tooltip='This is a colorful textbox.',$
                          label = 'CHECKBOX 3',$
                          xsize=120,$
                          ysize=20,$
                          color = 256L*255L,$
                          value=1,$
                          uname ='CHECKBOX UNAME',$
                          uvalue='CHECKBOX UVALUE',$
                          obj=obj)
    c4 = cwo_lk_multicheckbox(b,tooltip='This is a colorful textbox.',$
                          label = 'CHECKBOX 4',$
                          xsize=120,$
                          ysize=20,$
                          color = 256L*256L*255L,$
                          value=1,$
                          uname ='CHECKBOX UNAME',$
                          uvalue='CHECKBOX UVALUE',$
                          obj=obj)
    c5 = cwo_lk_multicheckbox(b,tooltip='This is a colorful textbox.',$
                          label = 'CHECKBOX 5',$
                          xsize=120,$
                          ysize=20,$
                          color = 255L + 256L*256L*255L,$
                          value=1,$
                          uname ='CHECKBOX UNAME',$
                          uvalue='CHECKBOX UVALUE',$
                          obj=obj)
    widget_control,b,/realize
    xmanager,'cwo_lk_multicheckbox_test',b,/no_block

end;cwo_lk_multicheckbox_test



function cwo_lk_multicheckbox,parent,obj=obj,_ref_extra=extra
    obj = obj_new('cwo_lk_multicheckbox',parent,_strict_extra=extra)
    obj->getproperty,tlb=tlb
    return,tlb
end;cwo_lk_multicheckbox
