; $Id$
;###############################################################################
;
;FILENAME:
;        bytes2bits.pro
;
;PURPOSE:
;
;CATEGORY:
;
;
;METHODS IN FILE:
;
;METHODS:
;    bytes2bits
;
;
; AUTHOR:
; John Copley
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; john.copley@nist.gov  301-975-5133
; Tue Feb 13 19:37:35 2007
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        bytes2bits
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function bytes2bits,bytes,nc,nr
    ;
    ; Given a 1-d array of bytes of length nrp, this function creates the corresponding
    ; 1-d array of bits of length nrp*8. Given the numbers of columns and rows, nc and nr
    ; (from the call to the function), an appropriate number of trailing elements is
    ;	removed so that the length of the array is nc*nr. The array is then reformed into
    ; a 2-d array with nc columns and nr rows. This array is returned.
    nrp=n_elements(bytes)
    power2=2b^(7-bindgen(8))
    bits=(bytarr(8)+1)#bytes/(power2#(bytarr(nrp)+1))
    bits=byte(bits-bits/2*2)
    nbits=long(nc)*nr
    bits=bits[0:nbits-1]
    return,reform(bits,nc,nr)
end;bytes2bits
