; $Id$
;###############################################################################
;+
; Purpose:
;   Calculate the sample momentum transfer and its components along h and k given the
;   scattering angles a3 and a4 and the incident and final neutron wavevectors.
; 
; Parameters:
;   ki [in] - manitude of initial wavevector in inverse angstroms.
;
;   kf [in] - manitude of final wavevector in inverse angstroms.
;
;   a3 [in] - a3 scattering angle in degrees.
;
;   a4 [in] - a4 scattering angle in degrees.
;
;   q [out] - manitude of the momentum transfer in inverse angstroms
;
;   qx [out] - h component of momentum transfer in inverse angstroms
;
;   qy [out] - k component of momentum transfer in inverse angstroms
;
; Keywords:
;   phioffset - arbitrary offset to angle phi (A3 Correction)
;
; Return:
;
;-
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Aug 2011
;==============================================================================

pro angle2q, ki, kf, a3, a4, q, qx, qy, phioffset=phioffset

if (n_elements(phioffset) eq 0) then phioffset = 0.0

q = Sqrt(ki^2 + kf^2 - 2*ki*kf*Cos(a4*!dtor))

cospsi = (q^2 + ki^2 - kf^2)/(2*q*ki)
index = where(cospsi lt -1.0, cnt)
if (cnt gt 0) then cospsi[index] = -1.0
index = where(cospsi gt 1.0, cnt)
if (cnt gt 0) then cospsi[index] = 1.0
psi = (Acos(cospsi)) * (abs(a4)/a4) ; abs(a4)/a4 == sign(a4)

phi = psi - (0.5*!pi - a3*!dtor) + phioffset*!dtor ; phi = psi - (90 - a3)

qx = q*cos(phi)
qy = q*sin(phi)

return
end
