/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import ptolemy.util.StringUtilities;

public class ClassUtilities {
    private ClassUtilities() {
    }

    public static URL jarURLEntryResource(String jarURLString) throws IOException {
        int jarEntry = jarURLString.indexOf("!/");
        if (jarEntry == -1 && (jarEntry = jarURLString.indexOf("!\\")) == -1) {
            return null;
        }
        try {
            String entry = jarURLString.substring(jarEntry + 2);
            Class<?> refClass = Class.forName("ptolemy.util.ClassUtilities");
            URL entryURL = refClass.getClassLoader().getResource(entry);
            return entryURL;
        }
        catch (Exception ex) {
            IOException ioException = new IOException("Cannot find \"" + jarURLString + "\".");
            ioException.initCause(ex);
            throw ioException;
        }
    }

    public static String lookupClassAsResource(String necessaryClass) {
        String necessaryResource = String.valueOf(StringUtilities.substitute(necessaryClass, ".", "/")) + ".class";
        URL necessaryURL = Thread.currentThread().getContextClassLoader().getResource(necessaryResource);
        if (necessaryURL != null) {
            String resourceResults = necessaryURL.getFile();
            if (resourceResults.startsWith("file:/")) {
                resourceResults = resourceResults.substring(6);
            }
            if ((resourceResults = resourceResults.substring(0, resourceResults.length() - necessaryResource.length())).endsWith("!/")) {
                resourceResults = resourceResults.substring(0, resourceResults.length() - 2);
            }
            File resourceFile = new File(resourceResults);
            String sanitizedResourceName = StringUtilities.substitute(resourceFile.getPath(), "\\", "/");
            return sanitizedResourceName;
        }
        return null;
    }
}

