/*
 * Decompiled with CFR 0.152.
 */
package org.python.jsr223;

import java.io.IOException;
import java.io.StringReader;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import junit.framework.TestCase;
import org.python.core.PyString;

public class ScriptEngineTest
extends TestCase {
    public void testEvalString() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        ScriptEngineTest.assertNull(pythonEngine.eval("x = 5"));
        ScriptEngineTest.assertEquals((Object)5, pythonEngine.eval("x"));
    }

    public void testSyntaxError() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        try {
            pythonEngine.eval("5q");
        }
        catch (ScriptException e) {
            ScriptEngineTest.assertEquals(e.getColumnNumber(), 1);
            ScriptEngineTest.assertEquals(e.getLineNumber(), 1);
            ScriptEngineTest.assertTrue(e.getMessage().startsWith("SyntaxError: "));
            return;
        }
        ScriptEngineTest.assertTrue("Expected a ScriptException", false);
    }

    public void testPythonException() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        try {
            pythonEngine.eval("pass\ndel undefined");
        }
        catch (ScriptException e) {
            ScriptEngineTest.assertEquals(e.getLineNumber(), 2);
            ScriptEngineTest.assertTrue(e.getMessage().startsWith("NameError: "));
            return;
        }
        ScriptEngineTest.assertTrue("Expected a ScriptException", false);
    }

    public void testScriptFilename() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("javax.script.filename", "sample.py", 100);
        try {
            pythonEngine.eval("foo", (ScriptContext)scriptContext);
        }
        catch (ScriptException e) {
            ScriptEngineTest.assertEquals("sample.py", e.getFileName());
            return;
        }
        ScriptEngineTest.assertTrue("Expected a ScriptException", false);
    }

    public void testCompileEvalString() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        CompiledScript five = ((Compilable)((Object)pythonEngine)).compile("5");
        ScriptEngineTest.assertEquals((Object)5, five.eval());
    }

    public void testEvalReader() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        ScriptEngineTest.assertNull(pythonEngine.eval(new StringReader("x = 5")));
        ScriptEngineTest.assertEquals((Object)5, pythonEngine.eval(new StringReader("x")));
    }

    public void testCompileEvalReader() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        CompiledScript five = ((Compilable)((Object)pythonEngine)).compile(new StringReader("5"));
        ScriptEngineTest.assertEquals((Object)5, five.eval());
    }

    public void testBindings() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        pythonEngine.put("a", 42);
        ScriptEngineTest.assertEquals((Object)42, pythonEngine.eval("a"));
        ScriptEngineTest.assertNull(pythonEngine.eval("x = 5"));
        ScriptEngineTest.assertEquals((Object)5, pythonEngine.get("x"));
        ScriptEngineTest.assertNull(pythonEngine.eval("del x"));
        ScriptEngineTest.assertNull(pythonEngine.get("x"));
    }

    public void testInvoke() throws ScriptException, NoSuchMethodException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        Invocable invocableEngine = (Invocable)((Object)pythonEngine);
        ScriptEngineTest.assertNull(pythonEngine.eval("def f(x): return abs(x)"));
        ScriptEngineTest.assertEquals((Object)5, invocableEngine.invokeFunction("f", -5));
        ScriptEngineTest.assertEquals((Object)"spam", invocableEngine.invokeMethod(new PyString("  spam  "), "strip", new Object[0]));
        ScriptEngineTest.assertEquals((Object)"spam", invocableEngine.invokeMethod("  spam  ", "strip", new Object[0]));
    }

    public void testInvokeFunctionNoSuchMethod() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        Invocable invocableEngine = (Invocable)((Object)manager.getEngineByName("python"));
        try {
            invocableEngine.invokeFunction("undefined", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        ScriptEngineTest.assertTrue("Expected a NoSuchMethodException", false);
    }

    public void testInvokeMethodNoSuchMethod() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        Invocable invocableEngine = (Invocable)((Object)manager.getEngineByName("python"));
        try {
            invocableEngine.invokeMethod("eggs", "undefined", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        ScriptEngineTest.assertTrue("Expected a NoSuchMethodException", false);
    }

    public void testGetInterface() throws ScriptException, IOException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        Invocable invocableEngine = (Invocable)((Object)pythonEngine);
        ScriptEngineTest.assertNull(pythonEngine.eval("def read(cb): return 1"));
        Readable readable = invocableEngine.getInterface(Readable.class);
        ScriptEngineTest.assertEquals(1, readable.read(null));
        ScriptEngineTest.assertNull(pythonEngine.eval("class C(object):\n    def read(self, cb): return 2\nc = C()"));
        readable = invocableEngine.getInterface(pythonEngine.get("c"), Readable.class);
        ScriptEngineTest.assertEquals(2, readable.read(null));
    }
}

