/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellEditor
extends DefaultCellEditor {
    private final JTree tree;

    public TreeTableCellEditor(JTree jTree) {
        super(new TreeTableTextField());
        if (jTree == null) {
            throw new IllegalArgumentException("null tree");
        }
        this.tree = jTree;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        Rectangle rectangle = this.tree.getRowBounds(n);
        int n3 = rectangle.x;
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            Object object2 = this.tree.getPathForRow(n).getLastPathComponent();
            Icon icon = this.tree.getModel().isLeaf(object2) ? ((DefaultTreeCellRenderer)treeCellRenderer).getLeafIcon() : (this.tree.isExpanded(n) ? ((DefaultTreeCellRenderer)treeCellRenderer).getOpenIcon() : ((DefaultTreeCellRenderer)treeCellRenderer).getClosedIcon());
            if (icon != null) {
                n3 += ((DefaultTreeCellRenderer)treeCellRenderer).getIconTextGap() + icon.getIconWidth();
            }
        }
        ((TreeTableTextField)this.getComponent()).offset = n3;
        return component;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject == null) {
            return true;
        }
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return false;
    }

    static class TreeTableTextField
    extends JTextField {
        int offset;

        TreeTableTextField() {
        }

        public void reshape(int n, int n2, int n3, int n4) {
            int n5 = this.offset - this.getInsets().left;
            super.reshape(n + n5, n2, n3 - n5, n4);
        }
    }
}

