/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.LabelProperties;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.decorator.Sorter;
import org.jdesktop.swingx.icon.SortArrowIcon;
import org.jdesktop.swingx.plaf.ColumnHeaderRendererAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class ColumnHeaderRenderer
extends JComponent
implements TableCellRenderer {
    public static final String UP_ICON_KEY = "ColumnHeaderRenderer.upIcon";
    public static final String DOWN_ICON_KEY = "ColumnHeaderRenderer.downIcon";
    private static TableCellRenderer sharedInstance;
    private static Icon defaultDownIcon;
    private static Icon defaultUpIcon;
    private Icon downIcon = defaultDownIcon;
    private Icon upIcon = defaultUpIcon;
    private IconBorder iconBorder = new IconBorder();
    private boolean antiAliasedText = false;
    private TableCellRenderer delegateRenderer;
    private LabelProperties label = new LabelProperties();

    public static TableCellRenderer getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ColumnHeaderRenderer();
        }
        return sharedInstance;
    }

    public static ColumnHeaderRenderer createColumnHeaderRenderer() {
        return new ColumnHeaderRenderer();
    }

    private ColumnHeaderRenderer() {
        this.initDelegate();
    }

    private void initDelegate() {
        JTableHeader jTableHeader = new JTableHeader();
        this.delegateRenderer = jTableHeader.getDefaultRenderer();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.configureDelegate(jTable, object, bl, bl2, n, n2);
        if (jTable instanceof JXTable && component instanceof JComponent) {
            Sorter sorter = ((JXTable)jTable).getSorter(n2);
            Border border = UIManager.getBorder("TableHeader.cellBorder");
            if (sorter != null) {
                this.iconBorder.setIcon(sorter.isAscending() ? this.upIcon : this.downIcon);
                Border border2 = ((JComponent)component).getBorder();
                border = new CompoundBorder(border2, this.iconBorder);
                ((JComponent)component).setBorder(border);
            }
        }
        this.adjustComponentOrientation(component);
        return component;
    }

    protected void adjustComponentOrientation(Component component) {
        if (component.getComponentOrientation().equals(this.getComponentOrientation())) {
            return;
        }
        component.applyComponentOrientation(this.getComponentOrientation());
    }

    private Component configureDelegate(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.delegateRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.applyLabelProperties(component);
        return component;
    }

    private void applyLabelProperties(Component component) {
        if (component instanceof JLabel) {
            this.label.applyPropertiesTo((JLabel)component);
        } else {
            this.label.applyPropertiesTo(this.delegateRenderer);
        }
    }

    public void setAntiAliasedText(boolean bl) {
        this.antiAliasedText = bl;
    }

    public boolean getAntiAliasedText() {
        return this.antiAliasedText;
    }

    public void setBackground(Color color) {
        if (this.label != null) {
            this.label.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    public void setFont(Font font) {
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public void setDownIcon(Icon icon) {
        this.downIcon = icon;
    }

    public Icon getDownIcon() {
        return this.downIcon;
    }

    public void setUpIcon(Icon icon) {
        this.upIcon = icon;
    }

    public Icon getUpIcon() {
        return this.upIcon;
    }

    public void setHorizontalAlignment(int n) {
        this.label.setHorizontalAlignment(n);
    }

    public int getHorizontalAlignment() {
        return this.label.getHorizontalAlignment();
    }

    public void setHorizontalTextPosition(int n) {
        this.label.setHorizontalTextPosition(n);
    }

    public int getHorizontalTextPosition() {
        return this.label.getHorizontalTextPosition();
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIconTextGap(int n) {
        this.label.setIconTextGap(n);
    }

    public int getIconTextGap() {
        return this.label.getIconTextGap();
    }

    public void setVerticalAlignment(int n) {
        this.label.setVerticalAlignment(n);
    }

    public int getVerticalAlignment() {
        return this.label.getVerticalAlignment();
    }

    public void setVerticalTextPosition(int n) {
        this.label.setVerticalTextPosition(n);
    }

    public int getVerticalTextPosition() {
        return this.label.getVerticalTextPosition();
    }

    public void updateUI() {
        super.updateUI();
        this.initDelegate();
        this.updateIconUI();
    }

    private void updateIconUI() {
        Icon icon;
        if (this.getUpIcon() instanceof UIResource) {
            icon = UIManager.getIcon(UP_ICON_KEY);
            this.setUpIcon(icon != null ? icon : defaultUpIcon);
        }
        if (this.getDownIcon() instanceof UIResource) {
            icon = UIManager.getIcon(DOWN_ICON_KEY);
            this.setDownIcon(icon != null ? icon : defaultDownIcon);
        }
    }

    static {
        LookAndFeelAddons.contribute(new ColumnHeaderRendererAddon());
        sharedInstance = null;
        defaultDownIcon = new SortArrowIcon(false);
        defaultUpIcon = new SortArrowIcon(true);
    }
}

