/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ColumnFactory {
    private static ColumnFactory columnFactory;

    public static synchronized ColumnFactory getInstance() {
        if (columnFactory == null) {
            columnFactory = new ColumnFactory();
        }
        return columnFactory;
    }

    public static synchronized void setInstance(ColumnFactory columnFactory) {
        ColumnFactory.columnFactory = columnFactory;
    }

    public TableColumnExt createTableColumn(int n) {
        return new TableColumnExt(n);
    }

    public void configureTableColumn(TableModel tableModel, TableColumnExt tableColumnExt) {
        if (tableColumnExt.getModelIndex() < 0 || tableColumnExt.getModelIndex() >= tableModel.getColumnCount()) {
            throw new IllegalStateException("column must have valid modelIndex");
        }
        tableColumnExt.setHeaderValue(tableModel.getColumnName(tableColumnExt.getModelIndex()));
    }

    public TableColumnExt createAndConfigureTableColumn(TableModel tableModel, int n) {
        TableColumnExt tableColumnExt = this.createTableColumn(n);
        this.configureTableColumn(tableModel, tableColumnExt);
        return tableColumnExt;
    }

    public void configureColumnWidths(JXTable jXTable, TableColumnExt tableColumnExt) {
        Dimension dimension = jXTable.getIntercellSpacing();
        Object object = tableColumnExt.getPrototypeValue();
        if (object != null) {
            JTableHeader jTableHeader;
            TableCellRenderer tableCellRenderer = jXTable.getCellRenderer(0, jXTable.convertColumnIndexToView(tableColumnExt.getModelIndex()));
            Component component = tableCellRenderer.getTableCellRendererComponent(jXTable, object, false, false, 0, 0);
            int n = component.getPreferredSize().width + dimension.width;
            tableCellRenderer = tableColumnExt.getHeaderRenderer();
            if (tableCellRenderer == null && (jTableHeader = jXTable.getTableHeader()) != null) {
                tableCellRenderer = jTableHeader.getDefaultRenderer();
            }
            if (tableCellRenderer != null) {
                component = tableCellRenderer.getTableCellRendererComponent(jXTable, tableColumnExt.getHeaderValue(), false, false, 0, jXTable.convertColumnIndexToView(tableColumnExt.getModelIndex()));
                n = Math.max(component.getPreferredSize().width, n);
            }
            tableColumnExt.setPreferredWidth(n += jXTable.getColumnModel().getColumnMargin());
        }
    }

    public void packColumn(JXTable jXTable, TableColumnExt tableColumnExt, int n, int n2) {
        TableCellRenderer tableCellRenderer = tableColumnExt.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jXTable.getTableHeader().getDefaultRenderer();
        }
        int n3 = 0;
        Component component = tableCellRenderer.getTableCellRendererComponent(jXTable, tableColumnExt.getHeaderValue(), false, false, 0, 0);
        n3 = component.getPreferredSize().width;
        int n4 = jXTable.convertColumnIndexToView(tableColumnExt.getModelIndex());
        if (jXTable.getRowCount() > 0) {
            tableCellRenderer = jXTable.getCellRenderer(0, n4);
        }
        for (int i = 0; i < jXTable.getRowCount(); ++i) {
            component = tableCellRenderer.getTableCellRendererComponent(jXTable, jXTable.getValueAt(i, n4), false, false, i, n4);
            n3 = Math.max(n3, component.getPreferredSize().width);
        }
        if (n2 != -1 && (n3 += 2 * n) > n2) {
            n3 = n2;
        }
        tableColumnExt.setPreferredWidth(n3);
    }
}

