/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.misc;

import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class GlossyTaskPaneUI
extends BasicTaskPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new GlossyTaskPaneUI();
    }

    protected Border createPaneBorder() {
        return new GlossyPaneBorder();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getParent().getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, ROUND_HEIGHT, jComponent.getWidth(), jComponent.getHeight() - ROUND_HEIGHT);
        }
        this.paint(graphics, jComponent);
    }

    class GlossyPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        GlossyPaneBorder() {
        }

        protected void paintTitleBackground(JXTaskPane jXTaskPane, Graphics graphics) {
            Object object;
            if (jXTaskPane.isSpecial()) {
                graphics.setColor(this.specialTitleBackground);
                graphics.fillRoundRect(0, 0, jXTaskPane.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                graphics.fillRect(0, ROUND_HEIGHT, jXTaskPane.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
            } else {
                object = ((Graphics2D)graphics).getPaint();
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.titleBackgroundGradientStart, 0.0f, TITLE_HEIGHT, this.titleBackgroundGradientEnd);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRoundRect(0, 0, jXTaskPane.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                graphics.fillRect(0, ROUND_HEIGHT, jXTaskPane.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
                ((Graphics2D)graphics).setPaint((Paint)object);
            }
            object = graphics.getClipBounds();
            graphics.setClip(0, 0, jXTaskPane.getWidth(), TITLE_HEIGHT);
            graphics.setColor(this.borderColor);
            graphics.drawRoundRect(0, 0, jXTaskPane.getWidth() - 1, TITLE_HEIGHT + ROUND_HEIGHT, ROUND_HEIGHT, ROUND_HEIGHT);
            graphics.drawLine(0, TITLE_HEIGHT - 1, jXTaskPane.getWidth(), TITLE_HEIGHT - 1);
            graphics.setClip((Shape)object);
        }

        protected void paintExpandedControls(JXTaskPane jXTaskPane, Graphics graphics, int n, int n2, int n3, int n4) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintOvalAroundControls(jXTaskPane, graphics, n, n2, n3, n4);
            graphics.setColor(this.getPaintColor(jXTaskPane));
            this.paintChevronControls(jXTaskPane, graphics, n, n2, n3, n4);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }
    }
}

