/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.util.BitSet;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.Sorter;

public class FilterPipeline {
    protected EventListenerList listenerList = new EventListenerList();
    private ComponentAdapter adapter = null;
    private Sorter sorter = null;
    private final Filter[] filters;

    public FilterPipeline() {
        this(new Filter[0]);
    }

    public FilterPipeline(Filter[] filterArray) {
        this.filters = this.reorderSorters(filterArray, this.locateSorters(filterArray));
        this.assignFilters();
    }

    private void assignFilters() {
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].assign(this, i);
        }
    }

    public void setSorter(Sorter sorter) {
        Sorter sorter2 = this.getSorter();
        if (sorter2 == sorter) {
            return;
        }
        if (sorter2 != null) {
            sorter2.assign((FilterPipeline)null);
        }
        this.sorter = sorter;
        if (sorter != null) {
            sorter.assign((FilterPipeline)null);
            sorter.assign(this);
            if (this.adapter != null) {
                sorter.assign(this.adapter);
                sorter.refresh();
            }
        }
        if (sorter == null && this.isAssigned()) {
            this.fireContentsChanged();
        }
    }

    public Sorter getSorter() {
        return this.sorter;
    }

    public final void assign(ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            throw new IllegalArgumentException("null adapter");
        }
        if (this.adapter == null) {
            this.adapter = componentAdapter;
            for (int i = 0; i < this.filters.length; ++i) {
                this.filters[i].assign(componentAdapter);
            }
            if (this.sorter != null) {
                this.sorter.assign(componentAdapter);
            }
            this.flush();
        } else if (this.adapter != componentAdapter) {
            throw new IllegalStateException("Can't bind to a different adapter");
        }
    }

    public boolean isAssigned() {
        return this.adapter != null;
    }

    boolean contains(Filter filter) {
        return filter.equals(this.sorter) || filter.order >= 0 && this.filters.length > 0 && this.filters[filter.order] == filter;
    }

    Filter first() {
        return this.filters.length > 0 ? this.filters[0] : null;
    }

    Filter last() {
        if (this.sorter != null) {
            return this.sorter;
        }
        return this.filters.length > 0 ? this.filters[this.filters.length - 1] : null;
    }

    Filter next(Filter filter) {
        if (this.last().equals(filter)) {
            return null;
        }
        return filter.order + 1 < this.filters.length ? this.filters[filter.order + 1] : this.getSorter();
    }

    Filter previous(Filter filter) {
        if (filter.equals(this.sorter)) {
            return this.filters.length > 0 ? this.filters[this.filters.length - 1] : null;
        }
        return this.first().equals(filter) ? null : this.filters[filter.order - 1];
    }

    protected void filterChanged(Filter filter) {
        Filter filter2 = this.next(filter);
        if (filter2 == null) {
            this.fireContentsChanged();
        } else {
            filter2.refresh();
        }
    }

    public int getInputSize() {
        return this.isAssigned() ? this.adapter.getRowCount() : 0;
    }

    int getInputSize(Filter filter) {
        Filter filter2 = this.previous(filter);
        if (filter2 != null) {
            return filter2.getSize();
        }
        return this.getInputSize();
    }

    public int getOutputSize() {
        if (!this.isAssigned()) {
            return 0;
        }
        Filter filter = this.last();
        return filter == null ? this.adapter.getRowCount() : filter.getSize();
    }

    public int convertRowIndexToModel(int n) {
        Filter filter = this.last();
        return filter == null ? n : filter.convertRowIndexToModel(n);
    }

    public int convertRowIndexToView(int n) {
        Filter filter = this.last();
        return filter == null ? n : filter.convertRowIndexToView(n);
    }

    public Object getValueAt(int n, int n2) {
        Filter filter = this.last();
        return filter == null ? null : filter.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        Filter filter = this.last();
        if (filter != null) {
            filter.setValueAt(object, n, n2);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        Filter filter = this.last();
        return filter == null ? false : filter.isCellEditable(n, n2);
    }

    public void flush() {
        if (this.filters != null && this.filters.length > 0) {
            this.filters[0].refresh();
        } else if (this.sorter != null) {
            this.sorter.refresh();
        }
    }

    public void addPipelineListener(PipelineListener pipelineListener) {
        this.listenerList.add(PipelineListener.class, pipelineListener);
    }

    public void removePipelineListener(PipelineListener pipelineListener) {
        this.listenerList.remove(PipelineListener.class, pipelineListener);
    }

    public PipelineListener[] getPipelineListeners() {
        return (PipelineListener[])this.listenerList.getListeners(PipelineListener.class);
    }

    protected void fireContentsChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        PipelineEvent pipelineEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PipelineListener.class) continue;
            if (pipelineEvent == null) {
                pipelineEvent = new PipelineEvent(this, 0);
            }
            ((PipelineListener)objectArray[i + 1]).contentsChanged(pipelineEvent);
        }
    }

    private List locateSorters(Filter[] filterArray) {
        BitSet bitSet = new BitSet();
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < filterArray.length; ++i) {
            if (!(filterArray[i] instanceof Sorter)) continue;
            int n = filterArray[i].getColumnIndex();
            if (n < 0) {
                throw new IndexOutOfBoundsException("Negative column index for filter: " + filterArray[i]);
            }
            if (bitSet.get(n)) {
                throw new IllegalArgumentException("Filter " + i + " attempting to overwrite sorter for column " + n);
            }
            bitSet.set(n);
            vector.add(new Integer(i));
        }
        return vector;
    }

    private Filter[] reorderSorters(Filter[] filterArray, List list) {
        if (filterArray.length == 0) {
            return new Filter[]{new IdentityFilter()};
        }
        Filter[] filterArray2 = (Filter[])filterArray.clone();
        int n = list.size() - 1;
        for (int i = 0; i <= n; ++i) {
            int n2 = (Integer)list.get(n - i);
            int n3 = (Integer)list.get(i);
            filterArray2[n3] = filterArray[n2];
        }
        return filterArray2;
    }

    public class IdentityFilter
    extends Filter {
        protected void init() {
        }

        protected void reset() {
        }

        protected void filter() {
        }

        public int getSize() {
            return this.getInputSize();
        }

        protected int mapTowardModel(int n) {
            return n;
        }

        protected int mapTowardView(int n) {
            return n;
        }
    }
}

