/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.jdesktop.swingx.auth.UserNameStore;

public class DefaultUserNameStore
extends UserNameStore {
    private static final String USER_KEY = "usernames";
    private static final String NUM_KEY = "usernames.length";
    private static final String DEFAULT_APP_NAME = "default";
    private Preferences prefs;
    private String[] userNames;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public DefaultUserNameStore() {
        this.userNames = new String[0];
    }

    public void loadUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            int n = this.prefs.getInt(NUM_KEY, 0);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.prefs.get("usernames." + i, null);
            }
            this.setUserNames(stringArray);
        }
    }

    public void saveUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            this.prefs.putInt(NUM_KEY, this.userNames.length);
            for (int i = 0; i < this.userNames.length; ++i) {
                this.prefs.put("usernames." + i, this.userNames[i]);
            }
        }
    }

    public String[] getUserNames() {
        return this.userNames;
    }

    public void setUserNames(String[] stringArray) {
        if (this.userNames != stringArray) {
            String[] stringArray2 = this.userNames;
            this.userNames = stringArray == null ? new String[]{} : stringArray;
            this.pcs.firePropertyChange("userNames", stringArray2, this.userNames);
        }
    }

    public void addUserName(String string) {
        if (!this.containsUserName(string)) {
            String[] stringArray = new String[this.userNames.length + 1];
            for (int i = 0; i < this.userNames.length; ++i) {
                stringArray[i] = this.userNames[i];
            }
            stringArray[stringArray.length - 1] = string;
            this.setUserNames(stringArray);
        }
    }

    public void removeUserName(String string) {
        if (this.containsUserName(string)) {
            String[] stringArray = new String[this.userNames.length - 1];
            int n = 0;
            for (String string2 : this.userNames) {
                if (string2.equals(string)) continue;
                stringArray[n++] = string2;
            }
            this.setUserNames(stringArray);
        }
    }

    public boolean containsUserName(String string) {
        for (String string2 : this.userNames) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void setPreferences(Preferences preferences) {
        this.initPrefs();
        if (this.prefs != preferences) {
            Preferences preferences2 = this.prefs;
            this.prefs = preferences;
            this.pcs.firePropertyChange("preferences", preferences2, preferences);
            this.loadUserNames();
        }
    }

    private void initPrefs() {
        if (this.prefs == null) {
            this.prefs = Preferences.userNodeForPackage(DefaultUserNameStore.class);
            this.prefs = this.prefs.node("DefaultUserNameStore");
        }
    }
}

