/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class ServerAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ServerAction.class.getName());
    private static final String PARAMS = "action-params";
    private static final String HEADERS = "action-headers";
    private static final String URL = "action-url";
    private static final String URL_CACHE = "_URL-CACHE__";

    public ServerAction() {
        this("action");
    }

    public ServerAction(String string) {
        super(string);
    }

    public ServerAction(String string, String string2) {
        this(string, string2, null);
    }

    public ServerAction(String string, Icon icon) {
        super(string, icon);
    }

    public ServerAction(String string, String string2, Icon icon) {
        super(string, icon);
        this.putValue("ActionCommandKey", string2);
    }

    public void setURL(String string) {
        this.putValue(URL, string);
        this.putValue(URL_CACHE, null);
    }

    public String getURL() {
        return (String)this.getValue(URL);
    }

    private Map getParams() {
        return (Map)this.getValue(PARAMS);
    }

    private void setParams(Map map) {
        this.putValue(PARAMS, map);
    }

    public void addParam(String string, String string2) {
        HashMap<String, String> hashMap = this.getParams();
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            this.setParams(hashMap);
        }
        hashMap.put(string, string2);
    }

    public String getParamValue(String string) {
        Map map = this.getParams();
        return map == null ? null : (String)map.get(string);
    }

    public Set getParamNames() {
        Map map = this.getParams();
        return map == null ? null : map.keySet();
    }

    private Map getHeaders() {
        return (Map)this.getValue(HEADERS);
    }

    private void setHeaders(Map map) {
        this.putValue(HEADERS, map);
    }

    public void addHeader(String string, String string2) {
        HashMap<String, String> hashMap = this.getHeaders();
        if (hashMap != null) {
            hashMap = new HashMap<String, String>();
            this.setHeaders(hashMap);
        }
        hashMap.put(string, string2);
    }

    public String getHeaderValue(String string) {
        Map map = this.getHeaders();
        return map == null ? null : (String)map.get(string);
    }

    public Set getHeaderNames() {
        Map map = this.getHeaders();
        return map == null ? null : map.keySet();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        URL uRL = (URL)this.getValue(URL_CACHE);
        if (uRL == null && !"".equals(this.getURL())) {
            try {
                object = this.getURL();
                if (((String)object).startsWith("http")) {
                    uRL = new URL((String)object);
                }
                if (uRL == null) {
                    return;
                }
                this.putValue(URL_CACHE, uRL);
            }
            catch (MalformedURLException malformedURLException) {
                LOG.log(Level.WARNING, "something went wrong...", malformedURLException);
            }
        }
        try {
            Object object22;
            object = uRL.openConnection();
            Set set = this.getHeaderNames();
            if (set != null && !set.isEmpty()) {
                for (Object object22 : set) {
                    ((URLConnection)object).setRequestProperty((String)object22, this.getHeaderValue((String)object22));
                }
            }
            ((URLConnection)object).setUseCaches(false);
            ((URLConnection)object).setDoOutput(true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            object22 = new PrintWriter(byteArrayOutputStream, true);
            ((PrintWriter)object22).print(this.getPostData());
            ((PrintWriter)object22).flush();
            String string = String.valueOf(byteArrayOutputStream.size());
            ((URLConnection)object).setRequestProperty("Content-length", string);
            byteArrayOutputStream.writeTo(((URLConnection)object).getOutputStream());
            BufferedReader bufferedReader = null;
            if (object instanceof HttpURLConnection) {
                String string2;
                HttpURLConnection httpURLConnection = (HttpURLConnection)object;
                int n = httpURLConnection.getResponseCode();
                String string3 = httpURLConnection.getResponseMessage();
                bufferedReader = n < 400 ? new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream())) : new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append('\n');
                }
                LOG.finer("returned from connection\n" + stringBuffer.toString());
            }
        }
        catch (UnknownHostException unknownHostException) {
            LOG.log(Level.WARNING, "UnknownHostException detected. Could it be a proxy issue?", unknownHostException);
        }
        catch (AccessControlException accessControlException) {
            LOG.log(Level.WARNING, "AccessControlException detected", accessControlException);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "IOException detected", iOException);
        }
    }

    private String getPostData() {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.getParamNames();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            try {
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    stringBuffer.append('&').append(string).append('=');
                    stringBuffer.append(this.getParamValue(string));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.setCharAt(0, '?');
        }
        LOG.finer("ServerAction: POST data: " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    private String createMessage(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("The action \"");
        stringBuffer.append(this.getValue("Name"));
        if (n < 400) {
            stringBuffer.append("\" has succeeded ");
        } else {
            stringBuffer.append("\" has failed\nPlease check the Java console for more details.\n");
        }
        stringBuffer.append("\nServer response:\nCode: ");
        stringBuffer.append(n);
        stringBuffer.append(" Message: ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

