/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXDialog;
import org.jdesktop.swingx.JXFindBar;
import org.jdesktop.swingx.JXFindPanel;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXRootPane;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class SearchFactory {
    private static SearchFactory searchFactory;
    protected JXFindPanel findPanel;
    protected JXFindBar findBar;
    protected JComponent lastFindBarTarget;
    private boolean useFindBar;
    private Point lastFindDialogLocation;
    private FindRemover findRemover;

    public static SearchFactory getInstance() {
        if (searchFactory == null) {
            searchFactory = new SearchFactory();
        }
        return searchFactory;
    }

    public static void setInstance(SearchFactory searchFactory) {
        SearchFactory.searchFactory = searchFactory;
    }

    public void showFindInput(JComponent jComponent, Searchable searchable) {
        if (this.isUseFindBar(jComponent, searchable)) {
            this.showFindBar(jComponent, searchable);
        } else {
            this.showFindDialog(jComponent, searchable);
        }
    }

    public void showFindBar(JComponent jComponent, Searchable searchable) {
        if (jComponent == null) {
            return;
        }
        if (this.findBar == null) {
            this.findBar = this.getSharedFindBar();
        } else {
            this.releaseFindBar();
        }
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        if (window instanceof JXFrame) {
            JXRootPane jXRootPane = ((JXFrame)window).getRootPaneExt();
            JToolBar jToolBar = jXRootPane.getToolBar();
            if (jToolBar == null) {
                jToolBar = new JToolBar();
                jXRootPane.setToolBar(jToolBar);
            }
            jToolBar.add((Component)this.findBar, 0);
            jXRootPane.revalidate();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.findBar);
        }
        this.lastFindBarTarget = jComponent;
        jComponent.putClientProperty("match.highlighter", Boolean.TRUE);
        this.installFindRemover(jComponent, this.findBar);
        this.getSharedFindBar().setSearchable(searchable);
    }

    protected void installFindRemover(Container container, Container container2) {
        if (container != null) {
            this.getFindRemover().addTarget(container);
        }
        this.getFindRemover().addTarget(container2);
    }

    private FindRemover getFindRemover() {
        if (this.findRemover == null) {
            this.findRemover = new FindRemover();
        }
        return this.findRemover;
    }

    protected void removeFromParent(JComponent jComponent) {
        Container container = jComponent.getParent();
        if (container != null) {
            container.remove(jComponent);
            if (container instanceof JComponent) {
                ((JComponent)container).revalidate();
            } else {
                container.invalidate();
                container.validate();
            }
        }
    }

    public JXFindBar getSharedFindBar() {
        if (this.findBar == null) {
            this.findBar = this.createFindBar();
            this.configureSharedFindBar();
        }
        return this.findBar;
    }

    protected void configureSharedFindBar() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchFactory.this.removeFromParent(SearchFactory.this.findBar);
            }
        };
        this.findBar.getActionMap().put("close", abstractAction);
    }

    public JXFindBar createFindBar() {
        return new JXFindBar();
    }

    public JXFindPanel getSharedFindPanel() {
        if (this.findPanel == null) {
            this.findPanel = this.createFindPanel();
            this.configureSharedFindPanel();
        }
        return this.findPanel;
    }

    protected void configureSharedFindPanel() {
    }

    public JXFindPanel createFindPanel() {
        return new JXFindPanel();
    }

    public void showFindDialog(JComponent jComponent, Searchable searchable) {
        Window window;
        Window window2;
        Frame frame = JOptionPane.getRootFrame();
        if (jComponent != null) {
            jComponent.putClientProperty("match.highlighter", Boolean.FALSE);
            window2 = SwingUtilities.getWindowAncestor(jComponent);
            if (window2 instanceof Frame) {
                frame = (Frame)window2;
            }
        }
        if ((window2 = this.getDialogForSharedFilePanel()) != null && window2.getOwner().equals(frame)) {
            window = window2;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(window);
        } else {
            Point point = this.hideSharedFilePanel();
            window = new JXDialog(frame, this.getSharedFindPanel());
            window.pack();
            if (point == null) {
                window.setLocationRelativeTo(frame);
            } else {
                window.setLocation(point);
            }
        }
        ((JXDialog)window).setVisible(true);
        this.installFindRemover(jComponent, window);
        this.getSharedFindPanel().setSearchable(searchable);
    }

    private JXDialog getDialogForSharedFilePanel() {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        return window instanceof JXDialog ? (JXDialog)window : null;
    }

    protected Point hideSharedFilePanel() {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        Point point = this.lastFindDialogLocation;
        if (window != null) {
            this.findPanel.getParent().remove(this.findPanel);
            if (window.isVisible()) {
                point = window.getLocationOnScreen();
            }
            window.dispose();
        }
        return point;
    }

    protected void stopSearching() {
        if (this.findPanel != null) {
            this.lastFindDialogLocation = this.hideSharedFilePanel();
            this.findPanel.setSearchable(null);
        }
        if (this.findBar != null) {
            this.releaseFindBar();
        }
    }

    private void releaseFindBar() {
        this.findBar.setSearchable(null);
        if (this.lastFindBarTarget != null) {
            this.lastFindBarTarget.putClientProperty("match.highlighter", Boolean.FALSE);
            this.lastFindBarTarget = null;
        }
        this.removeFromParent(this.findBar);
    }

    public boolean isUseFindBar(JComponent jComponent, Searchable searchable) {
        return this.useFindBar;
    }

    public void setUseFindBar(boolean bl) {
        if (bl == this.useFindBar) {
            return;
        }
        this.useFindBar = bl;
        this.getFindRemover().endSearching();
    }

    static {
        LookAndFeelAddons.getAddon();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FindRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;
        Set<Container> targets;

        public FindRemover() {
            this.updateManager();
        }

        public void addTarget(Container container) {
            this.getTargets().add(container);
        }

        public void removeTarget(Container container) {
            this.getTargets().remove(container);
        }

        private Set<Container> getTargets() {
            if (this.targets == null) {
                this.targets = new HashSet<Container>();
            }
            return this.targets;
        }

        private void updateManager() {
            if (this.focusManager != null) {
                this.focusManager.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Component component = this.focusManager.getPermanentFocusOwner();
            if (component == null) {
                return;
            }
            for (Container container : this.getTargets()) {
                if (container != component && !SwingUtilities.isDescendingFrom(component, container)) continue;
                return;
            }
            this.endSearching();
        }

        public void endSearching() {
            this.getTargets().clear();
            SearchFactory.this.stopSearching();
        }
    }
}

