/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.swingx.AbstractSearchable;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.LinkRenderer;
import org.jdesktop.swingx.RolloverProducer;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.decorator.Sorter;

public class JXList
extends JList {
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    protected FilterPipeline filters;
    protected HighlighterPipeline highlighters;
    private ChangeListener highlighterChangeListener;
    protected ComponentAdapter dataAdapter;
    private RolloverProducer rolloverProducer;
    private LinkController linkController;
    private DelegatingRenderer delegatingRenderer;
    private WrappingListModel wrappingModel;
    private PipelineListener pipelineListener;
    private boolean filterEnabled;
    private SelectionMapper selectionMapper;
    private Searchable searchable;

    public JXList() {
        this.init();
    }

    public JXList(ListModel listModel) {
        super(listModel);
        this.init();
    }

    public JXList(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public JXList(Vector vector) {
        super(vector);
        this.init();
    }

    private void init() {
        Action action = this.createFindAction();
        this.getActionMap().put("find", action);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("control F");
        this.getInputMap(1).put(keyStroke, "find");
    }

    private Action createFindAction() {
        UIAction uIAction = new UIAction("find"){

            public void actionPerformed(ActionEvent actionEvent) {
                JXList.this.doFind();
            }
        };
        return uIAction;
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new ListSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.isRolloverEnabled();
        if (bl == bl2) {
            return;
        }
        if (bl) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", bl2, this.isRolloverEnabled());
    }

    protected LinkController getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected LinkController createLinkController() {
        return new LinkController();
    }

    protected RolloverProducer createRolloverProducer() {
        RolloverProducer rolloverProducer = new RolloverProducer(){

            protected void updateRolloverPoint(JComponent jComponent, Point point) {
                int n;
                Rectangle rectangle;
                JXList jXList = (JXList)jComponent;
                int n2 = jXList.locationToIndex(point);
                if (n2 >= 0 && !(rectangle = jXList.getCellBounds(n2, n2)).contains(point)) {
                    n2 = -1;
                }
                this.rollover.x = n = n2 < 0 ? -1 : 0;
                this.rollover.y = n2;
            }
        };
        return rolloverProducer;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    public void setLinkVisitor(ActionListener actionListener) {
        if (actionListener != null) {
            this.setRolloverEnabled(true);
            this.getDelegatingRenderer().setLinkVisitor(actionListener);
        }
    }

    public Object getElementAt(int n) {
        return this.getModel().getElementAt(n);
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    public int convertIndexToModel(int n) {
        return this.isFilterEnabled() ? this.getFilters().convertRowIndexToModel(n) : n;
    }

    public int convertIndexToView(int n) {
        return this.isFilterEnabled() ? this.getFilters().convertRowIndexToView(n) : n;
    }

    public ListModel getWrappedModel() {
        return this.isFilterEnabled() ? this.wrappingModel.getModel() : this.getModel();
    }

    public void setFilterEnabled(boolean bl) {
        boolean bl2 = this.isFilterEnabled();
        if (bl2 == bl) {
            return;
        }
        this.filterEnabled = bl;
        if (!bl2) {
            this.wrappingModel = new WrappingListModel(this.getModel());
            super.setModel(this.wrappingModel);
        } else {
            ListModel listModel = this.wrappingModel.getModel();
            this.wrappingModel = null;
            super.setModel(listModel);
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setModel(ListModel listModel) {
        if (this.isFilterEnabled()) {
            this.wrappingModel.setModel(listModel);
        } else {
            super.setModel(listModel);
        }
    }

    private SelectionMapper getSelectionMapper() {
        if (this.selectionMapper == null) {
            this.selectionMapper = new SelectionMapper(this.filters, this.getSelectionModel());
        }
        return this.selectionMapper;
    }

    public FilterPipeline getFilters() {
        if (this.filters == null && this.isFilterEnabled()) {
            this.setFilters(null);
        }
        return this.filters;
    }

    public void setFilters(FilterPipeline filterPipeline) {
        if (!this.isFilterEnabled()) {
            throw new IllegalStateException("filters not enabled - not allowed to set filters");
        }
        FilterPipeline filterPipeline2 = this.filters;
        Sorter sorter = null;
        if (filterPipeline2 != null) {
            filterPipeline2.removePipelineListener(this.pipelineListener);
            sorter = filterPipeline2.getSorter();
        }
        if (filterPipeline == null) {
            filterPipeline = new FilterPipeline();
        }
        this.filters = filterPipeline;
        this.filters.setSorter(sorter);
        this.use(this.filters);
        this.getSelectionMapper().setFilters(this.filters);
    }

    private void use(FilterPipeline filterPipeline) {
        if (filterPipeline != null) {
            if (this.initialUse(filterPipeline)) {
                filterPipeline.addPipelineListener(this.getFilterPipelineListener());
                filterPipeline.assign(this.getComponentAdapter());
            } else {
                filterPipeline.flush();
            }
        }
    }

    private boolean initialUse(FilterPipeline filterPipeline) {
        if (this.pipelineListener == null) {
            return true;
        }
        PipelineListener[] pipelineListenerArray = filterPipeline.getPipelineListeners();
        for (int i = 0; i < pipelineListenerArray.length; ++i) {
            if (!this.pipelineListener.equals(pipelineListenerArray[i])) continue;
            return false;
        }
        return true;
    }

    protected PipelineListener getFilterPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = this.createPipelineListener();
        }
        return this.pipelineListener;
    }

    protected PipelineListener createPipelineListener() {
        PipelineListener pipelineListener = new PipelineListener(){

            public void contentsChanged(PipelineEvent pipelineEvent) {
                JXList.this.updateOnFilterContentChanged();
            }
        };
        return pipelineListener;
    }

    protected void updateOnFilterContentChanged() {
        if (this.wrappingModel != null) {
            this.wrappingModel.updateOnFilterContentChanged();
        }
        this.revalidate();
        this.repaint();
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new ListAdapter(this);
        }
        return this.dataAdapter;
    }

    public HighlighterPipeline getHighlighters() {
        return this.highlighters;
    }

    public void setHighlighters(HighlighterPipeline highlighterPipeline) {
        HighlighterPipeline highlighterPipeline2 = this.getHighlighters();
        if (highlighterPipeline2 != null) {
            highlighterPipeline2.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.highlighters = highlighterPipeline;
        if (this.highlighters != null) {
            this.highlighters.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", highlighterPipeline2, this.getHighlighters());
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JXList.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer(super.getCellRenderer());
        }
        return this.delegatingRenderer;
    }

    public ListCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.getDelegatingRenderer().setDelegateRenderer(listCellRenderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    public void updateUI() {
        super.updateUI();
        this.updateRendererUI();
    }

    private void updateRendererUI() {
        if (this.delegatingRenderer != null) {
            this.delegatingRenderer.updateUI();
        } else {
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (listCellRenderer instanceof JComponent) {
                ((JComponent)((Object)listCellRenderer)).updateUI();
            }
        }
    }

    private class DelegatingRenderer
    implements ListCellRenderer {
        private LinkRenderer linkRenderer;
        private ListCellRenderer delegateRenderer;

        public DelegatingRenderer(ListCellRenderer listCellRenderer) {
            this.setDelegateRenderer(listCellRenderer);
        }

        public void setDelegateRenderer(ListCellRenderer listCellRenderer) {
            if (listCellRenderer == null) {
                listCellRenderer = new DefaultListCellRenderer();
            }
            this.delegateRenderer = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = null;
            component = object instanceof LinkModel ? this.getLinkRenderer().getListCellRendererComponent(jList, object, n, bl, bl2) : this.delegateRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (JXList.this.highlighters != null) {
                ComponentAdapter componentAdapter = JXList.this.getComponentAdapter();
                componentAdapter.column = 0;
                componentAdapter.row = n;
                component = JXList.this.highlighters.apply(component, componentAdapter);
            }
            return component;
        }

        private LinkRenderer getLinkRenderer() {
            if (this.linkRenderer == null) {
                this.linkRenderer = new LinkRenderer();
            }
            return this.linkRenderer;
        }

        public void setLinkVisitor(ActionListener actionListener) {
            this.getLinkRenderer().setVisitingDelegate(actionListener);
        }

        public void updateUI() {
            this.updateRendererUI(this.linkRenderer);
            this.updateRendererUI(this.delegateRenderer);
        }

        private void updateRendererUI(ListCellRenderer listCellRenderer) {
            Component component;
            if (listCellRenderer instanceof JComponent) {
                ((JComponent)((Object)listCellRenderer)).updateUI();
            } else if (listCellRenderer != null && (component = listCellRenderer.getListCellRendererComponent(JXList.this, null, -1, false, false)) instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
        }
    }

    protected static class ListAdapter
    extends ComponentAdapter {
        private final JXList list;

        public ListAdapter(JXList jXList) {
            super(jXList);
            this.list = jXList;
        }

        public JXList getList() {
            return this.list;
        }

        public boolean hasFocus() {
            return this.list.isFocusOwner() && this.row == this.list.getLeadSelectionIndex();
        }

        public int getRowCount() {
            return this.list.getWrappedModel().getSize();
        }

        public Object getValueAt(int n, int n2) {
            return this.list.getWrappedModel().getElementAt(n);
        }

        public Object getFilteredValueAt(int n, int n2) {
            return this.list.getElementAt(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            throw new UnsupportedOperationException("Method getFilteredValueAt() not yet implemented.");
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public boolean isSelected() {
            return this.list.isSelectedIndex(this.row);
        }

        public String getColumnName(int n) {
            return "Column_" + n;
        }

        public String getColumnIdentifier(int n) {
            return null;
        }
    }

    private class WrappingListModel
    extends AbstractListModel {
        private ListModel delegate;
        private ListDataListener listDataListener;

        public WrappingListModel(ListModel listModel) {
            this.setModel(listModel);
        }

        public void updateOnFilterContentChanged() {
            this.fireContentsChanged(this, -1, -1);
        }

        public void setModel(ListModel listModel) {
            ListModel listModel2 = this.getModel();
            if (listModel2 != null) {
                listModel2.removeListDataListener(this.listDataListener);
            }
            this.delegate = listModel;
            this.delegate.addListDataListener(this.getListDataListener());
            this.fireContentsChanged(this, -1, -1);
        }

        private ListDataListener getListDataListener() {
            if (this.listDataListener == null) {
                this.listDataListener = this.createListDataListener();
            }
            return this.listDataListener;
        }

        private ListDataListener createListDataListener() {
            ListDataListener listDataListener = new ListDataListener(){

                public void intervalAdded(ListDataEvent listDataEvent) {
                    this.contentsChanged(listDataEvent);
                }

                public void intervalRemoved(ListDataEvent listDataEvent) {
                    this.contentsChanged(listDataEvent);
                }

                public void contentsChanged(ListDataEvent listDataEvent) {
                    JXList.this.getSelectionMapper().lock();
                    WrappingListModel.this.fireContentsChanged(this, -1, -1);
                    WrappingListModel.this.updateSelection(listDataEvent);
                    JXList.this.getFilters().flush();
                }
            };
            return listDataListener;
        }

        protected void updateSelection(ListDataEvent listDataEvent) {
            if (listDataEvent.getType() == 2) {
                JXList.this.getSelectionMapper().removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            } else if (listDataEvent.getType() == 1) {
                int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
                int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
                int n3 = n2 - n + 1;
                JXList.this.getSelectionMapper().insertIndexInterval(n, n3, true);
            } else {
                JXList.this.getSelectionMapper().clearModelSelection();
            }
        }

        public ListModel getModel() {
            return this.delegate;
        }

        public int getSize() {
            return JXList.this.getFilters().getOutputSize();
        }

        public Object getElementAt(int n) {
            return JXList.this.getFilters().getValueAt(n, 0);
        }
    }

    public static class LinkController
    implements PropertyChangeListener {
        private Cursor oldCursor;
        private JXList list;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("swingx.rollover".equals(propertyChangeEvent.getPropertyName())) {
                this.rollover((JXList)propertyChangeEvent.getSource(), (Point)propertyChangeEvent.getOldValue(), (Point)propertyChangeEvent.getOldValue());
            } else if ("swingx.clicked".equals(propertyChangeEvent.getPropertyName())) {
                this.click((JXList)propertyChangeEvent.getSource(), (Point)propertyChangeEvent.getOldValue(), (Point)propertyChangeEvent.getNewValue());
            }
        }

        public void install(JXList jXList) {
            this.release();
            this.list = jXList;
            jXList.addPropertyChangeListener(this);
            this.registerExecuteButtonAction();
        }

        public void release() {
            if (this.list == null) {
                return;
            }
            this.list.removePropertyChangeListener(this);
            this.unregisterExecuteButtonAction();
        }

        private void rollover(JXList jXList, Point point, Point point2) {
            this.setLinkCursor(jXList, point2);
            jXList.repaint();
        }

        private void click(JXList jXList, Point point, Point point2) {
            if (!this.isLinkElement(jXList, point2)) {
                return;
            }
            ListCellRenderer listCellRenderer = jXList.getCellRenderer();
            Component component = listCellRenderer.getListCellRendererComponent(jXList, jXList.getModel().getElementAt(point2.y), point2.y, false, true);
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).doClick();
                jXList.repaint();
            }
        }

        private void setLinkCursor(JXList jXList, Point point) {
            if (this.isLinkElement(jXList, point)) {
                this.oldCursor = jXList.getCursor();
                jXList.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                jXList.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }

        private boolean isLinkElement(JXList jXList, Point point) {
            if (point == null || point.y < 0) {
                return false;
            }
            return jXList.getModel().getElementAt(point.y) instanceof LinkModel;
        }

        private void unregisterExecuteButtonAction() {
            this.list.getActionMap().put(JXList.EXECUTE_BUTTON_ACTIONCOMMAND, null);
            KeyStroke keyStroke = KeyStroke.getKeyStroke("released SPACE");
            this.list.getInputMap(1).put(keyStroke, null);
        }

        private void registerExecuteButtonAction() {
            this.list.getActionMap().put(JXList.EXECUTE_BUTTON_ACTIONCOMMAND, this.createExecuteButtonAction());
            KeyStroke keyStroke = KeyStroke.getKeyStroke("released SPACE");
            this.list.getInputMap(1).put(keyStroke, JXList.EXECUTE_BUTTON_ACTIONCOMMAND);
        }

        private Action createExecuteButtonAction() {
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractButton abstractButton = this.getClickableRendererComponent();
                    if (abstractButton != null) {
                        abstractButton.doClick();
                        LinkController.this.list.repaint();
                    }
                }

                public boolean isEnabled() {
                    return this.isClickable();
                }

                private boolean isClickable() {
                    return this.getClickableRendererComponent() != null;
                }

                private AbstractButton getClickableRendererComponent() {
                    if (LinkController.this.list == null || !LinkController.this.list.isEnabled() || !LinkController.this.list.hasFocus()) {
                        return null;
                    }
                    int n = LinkController.this.list.getLeadSelectionIndex();
                    if (n < 0) {
                        return null;
                    }
                    ListCellRenderer listCellRenderer = LinkController.this.list.getCellRenderer();
                    Component component = listCellRenderer.getListCellRendererComponent(LinkController.this.list, LinkController.this.list.getElementAt(n), n, false, true);
                    return component instanceof AbstractButton ? (AbstractButton)component : null;
                }
            };
            return abstractAction;
        }
    }

    public class ListSearchable
    extends AbstractSearchable {
        protected void findMatchAndUpdateState(Pattern pattern, int n, boolean bl) {
            AbstractSearchable.SearchResult searchResult = null;
            if (bl) {
                for (int i = n; i >= 0 && searchResult == null; --i) {
                    searchResult = this.findMatchAt(pattern, i);
                }
            } else {
                for (int i = n; i < this.getSize() && searchResult == null; ++i) {
                    searchResult = this.findMatchAt(pattern, i);
                }
            }
            this.updateState(searchResult);
        }

        protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int n) {
            return this.findMatchAt(pattern, n);
        }

        protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int n) {
            Matcher matcher;
            Object object = JXList.this.getElementAt(n);
            if (object != null && (matcher = pattern.matcher(object.toString())).find()) {
                return this.createSearchResult(matcher, n, -1);
            }
            return null;
        }

        protected int getSize() {
            return JXList.this.getElementCount();
        }

        protected void moveMatchMarker() {
            JXList.this.setSelectedIndex(this.lastSearchResult.foundRow);
            if (this.lastSearchResult.foundRow >= 0) {
                JXList.this.ensureIndexIsVisible(this.lastSearchResult.foundRow);
            }
        }
    }
}

