/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXPanel;

public class JXImagePanel
extends JXPanel {
    private static final Logger LOG = Logger.getLogger(JXImagePanel.class.getName());
    private static final String TEXT = "<html><i><b>Click here<br>to set the image</b></i></html>";
    private Image img;
    private boolean editable = false;
    private MouseHandler mhandler = new MouseHandler();
    private Dimension preferredSize;
    private Style style = Style.CENTERED;

    public JXImagePanel() {
    }

    public JXImagePanel(URL uRL) {
        try {
            this.setImage(ImageIO.read(uRL));
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "", exception);
        }
    }

    public void setImage(Image image) {
        if (image != this.img) {
            Image image2 = this.img;
            this.img = image;
            this.firePropertyChange("image", image2, this.img);
            this.invalidate();
            this.repaint();
        }
    }

    public Image getImage() {
        return this.img;
    }

    public void setEditable(boolean bl) {
        if (bl != this.editable) {
            if (this.editable) {
                this.removeMouseListener(this.mhandler);
            }
            this.editable = bl;
            if (this.editable) {
                this.addMouseListener(new MouseHandler());
            }
            this.setToolTipText(bl ? TEXT : "");
            this.firePropertyChange("editable", !bl, bl);
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setStyle(Style style) {
        if (this.style != style) {
            Style style2 = this.style;
            this.style = style;
            this.firePropertyChange("style", (Object)style2, (Object)style);
            this.repaint();
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
        super.setPreferredSize(dimension);
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null && this.img != null) {
            int n = this.img.getWidth(null);
            int n2 = this.img.getHeight(null);
            if (n == -1 || n2 == -1) {
                return super.getPreferredSize();
            }
            return new Dimension(n, n2);
        }
        return super.getPreferredSize();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.img != null) {
            int n = this.img.getWidth(null);
            int n2 = this.img.getHeight(null);
            if (n == -1 || n2 == -1) {
                return;
            }
            switch (this.style) {
                case CENTERED: {
                    Rectangle rectangle = graphics2D.getClipBounds();
                    int n3 = (this.getWidth() - n) / 2;
                    int n4 = (this.getHeight() - n2) / 2;
                    Rectangle rectangle2 = SwingUtilities.computeIntersection(n3, n4, n, n2, rectangle);
                    if (rectangle2.x == 0 && rectangle2.y == 0 && (rectangle2.width == 0 || rectangle2.height == 0)) {
                        return;
                    }
                    rectangle = rectangle2;
                    int n5 = rectangle.x - n3;
                    int n6 = rectangle.y - n4;
                    int n7 = rectangle.width;
                    int n8 = rectangle.height;
                    graphics2D.drawImage(this.img, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, n5, n6, n5 + n7, n6 + n8, null);
                    break;
                }
                case TILED: 
                case SCALED: {
                    Image image = this.img.getScaledInstance(this.getWidth(), this.getHeight(), 4);
                    graphics2D.drawImage(image, (this.getWidth() - image.getWidth(null)) / 2, (this.getHeight() - image.getHeight(null)) / 2, null);
                    break;
                }
                default: {
                    LOG.fine("unimplemented");
                    graphics2D.drawImage(this.img, 0, 0, this);
                }
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private Cursor oldCursor;
        private JFileChooser chooser;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
            if ((n = this.chooser.showOpenDialog(JXImagePanel.this)) == 0) {
                File file = this.chooser.getSelectedFile();
                try {
                    JXImagePanel.this.setImage(new ImageIcon(file.toURL()).getImage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            if (this.oldCursor == null) {
                this.oldCursor = jLabel.getCursor();
                jLabel.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            if (this.oldCursor != null) {
                jLabel.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        CENTERED,
        TILED,
        SCALED;

    }
}

