/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.provider.sql;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.provider.sql.JDBCDataConnection;
import org.jdesktop.dataset.provider.sql.SQLCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCommand
extends SQLCommand {
    private static final Logger LOG = Logger.getLogger(TableCommand.class.getName());
    private String tableName;
    private String whereClause = "";
    private String orderByClause = "";
    private String havingClause = "";

    public TableCommand() {
        this(null, null);
    }

    public TableCommand(String string) {
        this(string, null);
    }

    public TableCommand(String string, String string2) {
        this.setTableName(string);
        this.setWhereClause(string2);
    }

    public void setTableName(String string) {
        if (this.tableName != string) {
            String string2 = this.tableName;
            this.tableName = string;
            this.firePropertyChange("tableName", string2, string);
        }
    }

    public void setWhereClause(String string) {
        if (this.whereClause != string) {
            String string2 = this.whereClause;
            this.whereClause = string == null ? "" : string;
            this.firePropertyChange("whereClause", string2, this.whereClause);
        }
    }

    public void setOrderByClause(String string) {
        if (this.orderByClause != string) {
            String string2 = this.orderByClause;
            this.orderByClause = string == null ? "" : string;
            this.firePropertyChange("orderByClause", string2, this.orderByClause);
        }
    }

    public void setHavingClause(String string) {
        if (this.havingClause != string) {
            String string2 = this.havingClause;
            this.havingClause = string == null ? "" : string;
            this.firePropertyChange("havingClause", string2, this.havingClause);
        }
    }

    @Override
    public String[] getParameterNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getSelectSQL() != null) {
            arrayList.add(this.getSelectSQL());
        } else {
            arrayList.add(this.whereClause);
            arrayList.add(this.orderByClause);
            arrayList.add(this.havingClause);
        }
        if (this.getUpdateSQL() != null) {
            arrayList.add(this.getUpdateSQL());
        }
        if (this.getDeleteSQL() != null) {
            arrayList.add(this.getDeleteSQL());
        }
        if (this.getInsertSQL() != null) {
            arrayList.add(this.getInsertSQL());
        }
        return super.getParameterNames(arrayList.toArray(new String[arrayList.size()]));
    }

    @Override
    protected PreparedStatement getSelectStatement(JDBCDataConnection jDBCDataConnection) throws Exception {
        if (this.tableName == null) {
            throw new Exception("TableCommand not configured with a table name");
        }
        if (super.getSelectSQL() != null) {
            return super.getSelectStatement(jDBCDataConnection);
        }
        String string = "";
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select * from ");
            stringBuilder.append("\"").append(this.tableName).append("\"");
            stringBuilder.append(" ");
            stringBuilder.append(this.whereClause);
            stringBuilder.append(" ");
            stringBuilder.append(this.orderByClause);
            stringBuilder.append(" ");
            stringBuilder.append(this.havingClause);
            string = stringBuilder.toString().trim();
            LOG.log(Level.FINE, "Generated Select SQL: " + string);
            return this.createPreparedStatement(string, jDBCDataConnection);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Problem with creating select SQL statement {0}", string);
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    @Override
    protected PreparedStatement getUpdateStatement(JDBCDataConnection jDBCDataConnection, DataRow dataRow) throws Exception {
        if (this.tableName == null) {
            throw new Exception("TableCommand not configured with a table name");
        }
        if (super.getUpdateSQL() != null) {
            return super.getUpdateStatement(jDBCDataConnection, dataRow);
        }
        String string = "";
        try {
            int n;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("update ");
            stringBuilder.append("\"").append(this.tableName).append("\"");
            stringBuilder.append(" set ");
            List<DataColumn> list = this.getUpdateableColumns(dataRow.getTable().getColumns());
            int n2 = 0;
            for (n = 0; n < list.size(); ++n) {
                DataColumn dataColumn = list.get(n);
                if (!dataRow.isModified(dataColumn)) continue;
                stringBuilder.append("\"").append(dataColumn.getName()).append("\"");
                stringBuilder.append(" = :" + dataColumn.getName() + ", ");
                hashMap.put(dataColumn.getName(), dataRow.getValue(dataColumn));
                ++n2;
            }
            if (n2 == 0) {
                return null;
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            stringBuilder.append(" where ");
            n = 0;
            for (int i = 0; i < list.size(); ++i) {
                DataColumn dataColumn = list.get(i);
                if (!dataColumn.isKeyColumn()) continue;
                stringBuilder.append("\"").append(dataColumn.getName()).append("\"");
                stringBuilder.append(" = :orig_" + dataColumn.getName() + " and ");
                hashMap.put("orig_" + dataColumn.getName(), dataRow.getReferenceValue(dataColumn));
                ++n;
            }
            if (n == 0) {
                LOG.log(Level.WARNING, "!!! No key columns were specified, the entire table '{0}' will be updated!!", this.tableName);
                stringBuilder.delete(stringBuilder.length() - 7, stringBuilder.length());
            } else {
                stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
            }
            string = stringBuilder.toString().trim();
            LOG.log(Level.FINE, "Generated Update SQL: " + string);
            return super.prepareStatement(string, hashMap, jDBCDataConnection);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Problem with creating update SQL statement {0}", string);
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    @Override
    protected PreparedStatement getInsertStatement(JDBCDataConnection jDBCDataConnection, DataRow dataRow) throws Exception {
        if (this.tableName == null) {
            throw new Exception("TableCommand not configured with a table name");
        }
        if (super.getInsertSQL() != null) {
            return super.getInsertStatement(jDBCDataConnection, dataRow);
        }
        String string = "";
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("insert into ");
            stringBuilder.append("\"").append(this.tableName).append("\"");
            stringBuilder.append("(");
            List<DataColumn> list = this.getUpdateableColumns(dataRow.getTable().getColumns());
            for (DataColumn dataColumn : list) {
                stringBuilder.append("\"").append(dataColumn.getName()).append("\"");
                stringBuilder.append(", ");
            }
            stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), ")");
            stringBuilder.append(" values(");
            for (DataColumn dataColumn : list) {
                stringBuilder.append(":" + dataColumn.getName() + ", ");
                hashMap.put(dataColumn.getName(), dataRow.getValue(dataColumn));
            }
            stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), ")");
            string = stringBuilder.toString().trim();
            LOG.log(Level.FINE, "Generated Insert SQL: " + string);
            return super.prepareStatement(string, hashMap, jDBCDataConnection);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Problem with creating insert SQL statement {0}", string);
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    @Override
    protected PreparedStatement getDeleteStatement(JDBCDataConnection jDBCDataConnection, DataRow dataRow) throws Exception {
        if (this.tableName == null) {
            throw new Exception("TableCommand not configured with a table name");
        }
        if (super.getDeleteSQL() != null) {
            return super.getDeleteStatement(jDBCDataConnection, dataRow);
        }
        String string = "";
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("delete from ");
            stringBuilder.append("\"").append(this.tableName).append("\"");
            stringBuilder.append(" where ");
            int n = 0;
            List<DataColumn> list = dataRow.getTable().getColumns();
            for (int i = 0; i < list.size(); ++i) {
                DataColumn dataColumn = list.get(i);
                if (!dataColumn.isKeyColumn()) continue;
                stringBuilder.append("\"").append(dataColumn.getName()).append("\"");
                stringBuilder.append(" = :orig_" + dataColumn.getName() + " and ");
                hashMap.put("orig_" + dataColumn.getName(), dataRow.getReferenceValue(dataColumn));
                ++n;
            }
            if (n == 0) {
                LOG.log(Level.WARNING, "!!! No key columns were specified, the entire table '" + this.tableName + "' will be deleted!!");
                stringBuilder.delete(stringBuilder.length() - 7, stringBuilder.length());
            } else {
                stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
            }
            string = stringBuilder.toString().trim();
            LOG.log(Level.FINE, "Generated Delete SQL: " + string);
            return super.prepareStatement(string, hashMap, jDBCDataConnection);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Problem with creating delete SQL statement {0}", string);
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    private List<DataColumn> getUpdateableColumns(List<DataColumn> list) {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        for (DataColumn dataColumn : list) {
            if (dataColumn.getExpression() != null && !dataColumn.getExpression().equals("")) continue;
            arrayList.add(dataColumn);
        }
        return arrayList;
    }
}

