/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.io.schema;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataProvider;
import org.jdesktop.dataset.DataRelation;
import org.jdesktop.dataset.DataRelationTable;
import org.jdesktop.dataset.DataSelector;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.DataValue;
import org.jdesktop.dataset.io.schema.DataSetSchemaReader;
import org.jdesktop.dataset.io.schema.SchemaReaderException;
import org.jdesktop.dataset.provider.sql.SQLCommand;
import org.jdesktop.dataset.provider.sql.SQLDataProvider;
import org.jdesktop.dataset.provider.sql.TableCommand;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDataSetSchemaReader
implements DataSetSchemaReader {
    private String xmlContents;
    private DataSetParser lastParserUsed;

    public XMLDataSetSchemaReader(InputStream inputStream) throws SchemaReaderException {
        this(new InputStreamReader(inputStream));
    }

    public XMLDataSetSchemaReader(Reader reader) throws SchemaReaderException {
        String string = "";
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[4096];
            int n = -1;
            while ((n = reader.read(cArray)) != -1) {
                stringBuilder.append(new String(cArray, 0, n));
            }
            this.xmlContents = stringBuilder.toString();
        }
        catch (Exception exception) {
            throw new SchemaReaderException("Can't read input stream to parse schema from.", exception);
        }
    }

    @Override
    public DataSet readDataSet() throws SchemaReaderException {
        return this.readXml(new DataSet(), new String[0]);
    }

    @Override
    public DataSet readDataSet(String ... stringArray) throws SchemaReaderException {
        return this.readXml(new DataSet(), stringArray);
    }

    @Override
    public List<String> addRelations(DataSet dataSet, String ... stringArray) throws SchemaReaderException {
        this.readXml(dataSet, stringArray);
        return this.lastParserUsed.getRelationsAdded();
    }

    @Override
    public List<String> addTables(DataSet dataSet, String ... stringArray) throws SchemaReaderException {
        this.readXml(dataSet, stringArray);
        return this.lastParserUsed.getTablesAdded();
    }

    private DataSet readXml(DataSet dataSet, String ... stringArray) throws SchemaReaderException {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            InputSource inputSource = new InputSource(new StringReader(this.xmlContents));
            this.lastParserUsed = new DataSetParser(dataSet, stringArray);
            sAXParser.parse(inputSource, (DefaultHandler)this.lastParserUsed);
        }
        catch (Exception exception) {
            throw new SchemaReaderException("Failed to setup schema XML parser.", exception);
        }
        return dataSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DataSetParser
    extends DefaultHandler {
        public int elementDepth = 0;
        private Attributes attrs;
        private DataSet ds;
        private DataTable table;
        private DataColumn column;
        private DataProvider dataProvider;
        private List<String> tableNames;
        private List<String> tablesAdded;
        private List<String> relationsAdded;

        public DataSetParser(DataSet dataSet, String ... stringArray) {
            this.ds = dataSet == null ? new DataSet() : dataSet;
            this.tableNames = new ArrayList<String>(stringArray.length);
            Collections.addAll(this.tableNames, stringArray);
        }

        public DataSet getDataSet() {
            return this.ds;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.tablesAdded = new ArrayList<String>();
            this.relationsAdded = new ArrayList<String>();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block43: {
                block44: {
                    this.attrs = attributes;
                    if (!string3.equals("xs:element")) break block44;
                    ++this.elementDepth;
                    switch (this.elementDepth) {
                        case 1: {
                            this.ds.setName(this.attrs.getValue("name"));
                            break;
                        }
                        case 2: {
                            String string4 = this.attrs.getValue("name");
                            if (this.ds.getTable(string4) != null) {
                                System.out.println("TABLE " + string4 + " ALREADY IN DATASET; SKIPPING.");
                                this.table = null;
                                break;
                            }
                            if (this.tableNames.size() > 0 && !this.tableNames.contains(string4)) {
                                this.table = null;
                                break;
                            }
                            this.table = this.ds.createTable(string4);
                            String string5 = this.attrs.getValue("appendRowSupported");
                            this.table.setAppendRowSupported(string5 == null || string5.equalsIgnoreCase("true"));
                            string5 = this.attrs.getValue("deleteRowSupported");
                            this.table.setDeleteRowSupported(string5 == null || string5.equalsIgnoreCase("true"));
                            this.tablesAdded.add(string4);
                            break;
                        }
                        case 3: {
                            if (this.table == null) break;
                            this.column = this.table.createColumn(this.attrs.getValue("name"));
                            String string6 = this.attrs.getValue("minOccurs");
                            if (string6 != null && string6.equals("")) {
                                this.column.setRequired(true);
                            }
                            this.column.setKeyColumn((string6 = this.attrs.getValue("keyColumn")) == null ? false : string6.equalsIgnoreCase("true"));
                            string6 = this.attrs.getValue("readOnly");
                            this.column.setReadOnly(string6 == null ? false : string6.equalsIgnoreCase("true"));
                            String string7 = this.attrs.getValue("default");
                            string6 = this.attrs.getValue("type");
                            if (string6.equals("xs:string")) {
                                this.column.setType(String.class);
                                if (string7 != null && !string7.equals("")) {
                                    this.column.setDefaultValue(string7);
                                }
                            } else if (string6.equals("xs:decimal")) {
                                this.column.setType(BigDecimal.class);
                                if (string7 != null && !string7.equals("")) {
                                    this.column.setDefaultValue(new BigDecimal(string7));
                                }
                            } else if (string6.equals("xs:integer") || string6.equals("xs:int")) {
                                this.column.setType(Integer.class);
                                if (string7 != null && !string7.equals("")) {
                                    this.column.setDefaultValue(new Integer(string7));
                                }
                            } else if (string6.equals("xs:boolean")) {
                                this.column.setType(Boolean.class);
                                if (string7 != null && !string7.equals("")) {
                                    this.column.setDefaultValue(Boolean.parseBoolean(string7));
                                }
                            } else if (string6.equals("xs:date") || string6.equals("xs:time") || string6.equals("xs:dateTime")) {
                                this.column.setType(Date.class);
                                if (string7 != null && !string7.equals("")) {
                                    this.column.setDefaultValue(new Date(Date.parse(string7)));
                                }
                            } else if (string6.equals("xs:unsignedByte")) {
                                this.column.setType(Byte.class);
                                if (string7 != null && !string7.equals("")) {
                                    this.column.setDefaultValue(new Byte(string7));
                                }
                            } else {
                                System.err.println("unexpected classType: '" + string6 + "'");
                            }
                            if ((string6 = this.attrs.getValue("expression")) != null && !"".equals(string6)) {
                                this.column.setExpression(string6);
                                break;
                            }
                            break block43;
                        }
                        default: {
                            System.out.println("Error in DataSetParser");
                        }
                    }
                    break block43;
                }
                if (string3.equals("dataProvider")) {
                    String string8 = this.attrs.getValue("class");
                    if (string8 != null) {
                        try {
                            this.dataProvider = (DataProvider)Class.forName(string8).newInstance();
                            this.table.setDataProvider(this.dataProvider);
                            if (!(this.dataProvider instanceof SQLDataProvider)) break block43;
                            String string9 = this.attrs.getValue("tableName");
                            if (string9 != null && !string9.equals("")) {
                                TableCommand tableCommand = new TableCommand(string9);
                                tableCommand.setWhereClause(this.attrs.getValue("whereClause"));
                                tableCommand.setOrderByClause(this.attrs.getValue("orderByClause"));
                                tableCommand.setHavingClause(this.attrs.getValue("havingClause"));
                                this.dataProvider.setCommand(tableCommand);
                                break block43;
                            }
                            SQLCommand sQLCommand = new SQLCommand();
                            sQLCommand.setSelectSQL(this.attrs.getValue("select"));
                            sQLCommand.setInsertSQL(this.attrs.getValue("insert"));
                            sQLCommand.setUpdateSQL(this.attrs.getValue("update"));
                            sQLCommand.setDeleteSQL(this.attrs.getValue("delete"));
                            this.dataProvider.setCommand(sQLCommand);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                } else if (string3.equals("dataRelationTable")) {
                    DataRelationTable dataRelationTable = this.ds.createRelationTable(this.attrs.getValue("name"));
                    dataRelationTable.setRelation((DataRelation)this.ds.getElement(this.attrs.getValue("relation")));
                    dataRelationTable.setParentSelector((DataSelector)this.ds.getElement(this.attrs.getValue("parentSelector")));
                    dataRelationTable.setParentTable((DataTable)this.ds.getElement(this.attrs.getValue("parentTable")));
                } else if (string3.equals("dataRelation")) {
                    String string10 = this.attrs.getValue("name");
                    String string11 = this.attrs.getValue("parentColumn");
                    String string12 = this.attrs.getValue("childColumn");
                    String string13 = string11.substring(0, string11.indexOf("."));
                    String string14 = string12.substring(0, string12.indexOf("."));
                    try {
                        if (this.tableNames.size() > 0 && this.tableNames.contains(string13) && this.tableNames.contains(string14)) {
                            DataColumn dataColumn = (DataColumn)this.ds.getElement(string11);
                            DataColumn dataColumn2 = (DataColumn)this.ds.getElement(string12);
                            if (dataColumn != null && dataColumn2 != null) {
                                if (this.ds.getRelation(string10) != null) {
                                    this.ds.dropRelation(string10);
                                }
                                DataRelation dataRelation = this.ds.createRelation(string10);
                                dataRelation.setParentColumn(dataColumn);
                                dataRelation.setChildColumn(dataColumn2);
                                this.relationsAdded.add(string10);
                            }
                            break block43;
                        }
                        System.err.println("DataRelation: Either parent " + string11 + " or child " + string12 + " is missing in DataSet. Tables might not be loaded, or the respective columns might not be. " + "Skipping.");
                    }
                    catch (Exception exception) {
                        System.out.println("failed on Parent: " + string11);
                    }
                } else if (string3.equals("dataValue")) {
                    DataValue dataValue = this.ds.createValue(this.attrs.getValue("name"));
                    dataValue.setExpression(this.attrs.getValue("expression"));
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("xs:element")) {
                switch (this.elementDepth) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        System.out.println("Error in DataSetParser");
                    }
                }
                --this.elementDepth;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        public List<String> getTablesAdded() {
            return this.tablesAdded;
        }

        public List<String> getRelationsAdded() {
            return this.relationsAdded;
        }
    }
}

