/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.jga.fn.BinaryFunctor;
import net.sf.jga.fn.Generator;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.adaptor.ApplyUnary;
import net.sf.jga.fn.adaptor.Constant;
import net.sf.jga.fn.adaptor.ConstantUnary;
import net.sf.jga.fn.adaptor.Identity;
import net.sf.jga.fn.algorithm.Accumulate;
import net.sf.jga.fn.algorithm.Count;
import net.sf.jga.fn.algorithm.TransformUnary;
import net.sf.jga.fn.arithmetic.Average;
import net.sf.jga.fn.arithmetic.Plus;
import net.sf.jga.fn.arithmetic.ValueOf;
import net.sf.jga.fn.comparison.Max;
import net.sf.jga.fn.comparison.Min;
import net.sf.jga.fn.property.ArrayBinary;
import net.sf.jga.fn.property.Construct;
import net.sf.jga.fn.property.GetProperty;
import net.sf.jga.fn.property.InvokeMethod;
import net.sf.jga.fn.property.InvokeNoArgMethod;
import net.sf.jga.parser.FunctorRef;
import net.sf.jga.parser.GeneratorRef;
import net.sf.jga.parser.JFXGParser;
import net.sf.jga.parser.ParseException;
import net.sf.jga.parser.UnaryFunctorRef;
import net.sf.jga.util.ComparableComparator;
import net.sf.jga.util.FilterIterator;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.DataValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Parser
extends JFXGParser {
    private DataTable table;
    boolean inTableContext = false;
    private UnaryFunctor<DataTable, List> getRowsFn = new GetProperty(DataTable.class, "Rows");
    private UnaryFunctor<DataTable, Integer> getRowCountFn = new InvokeNoArgMethod(List.class, "size").compose(this.getRowsFn);
    private UnaryFunctor<DataTable, Iterator> iterateTableFn = new InvokeNoArgMethod(List.class, "iterator").compose(this.getRowsFn);
    private UnaryFunctor<DataValue, ?> getValueFn = new GetProperty(DataValue.class, "Value");
    private Class[] filterCtorArgs = new Class[]{Iterator.class, UnaryFunctor.class};
    private BinaryFunctor<Iterator, UnaryFunctor<DataRow, Boolean>, ? extends Iterator> makeFilterFn = new Construct(this.filterCtorArgs, FilterIterator.class).compose((BinaryFunctor)new ArrayBinary());

    Parser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UnaryFunctor<DataRow, ?> parseComputedColumn(DataTable dataTable, String string) throws ParseException {
        this.setCurrentTable(dataTable);
        try {
            UnaryFunctor unaryFunctor = this.parseUnary(string, DataRow.class);
            return unaryFunctor;
        }
        finally {
            this.setCurrentTable(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Generator<?> parseDataValue(String string) throws ParseException {
        this.inTableContext = true;
        try {
            Generator generator = this.parseGenerator(string);
            return generator;
        }
        finally {
            this.inTableContext = false;
            this.setCurrentTable(null);
        }
    }

    protected FunctorRef reservedWord(String string) throws ParseException {
        Object object;
        if (this.table == null && (object = ((DataSet)this.getBoundObject()).getTable(string)) != null) {
            this.setCurrentTable((DataTable)object);
            return new GeneratorRef((Generator)new Constant((Object)this.table), DataTable.class);
        }
        if (this.table != null && string.equals(this.table.getName())) {
            return new GeneratorRef((Generator)new Constant((Object)this.table), DataTable.class);
        }
        if (this.table != null && (object = this.table.getColumn(string)) != null) {
            return this.makeColumnRef(this.table, (DataColumn)object);
        }
        return null;
    }

    protected FunctorRef reservedField(FunctorRef functorRef, String string) throws ParseException {
        DataColumn dataColumn;
        if (this.isTableReference(functorRef) && this.getReferencedTable(functorRef).equals(this.table) && (dataColumn = this.table.getColumn(string)) != null) {
            return this.makeColumnRef(this.table, dataColumn);
        }
        return super.reservedField(functorRef, string);
    }

    protected FunctorRef reservedFunction(String string, FunctorRef[] functorRefArray) throws ParseException {
        if (this.inTableContext) {
            ConstantUnary constantUnary;
            assert (this.table != null);
            FunctorRef functorRef = functorRefArray[functorRefArray.length - 1];
            boolean bl = functorRef.getReturnType() == Boolean.class;
            Object object = constantUnary = bl ? ((UnaryFunctorRef)functorRef).getFunctor() : new ConstantUnary((Object)Boolean.TRUE);
            if ("count".equals(string)) {
                if (bl) {
                    UnaryFunctor unaryFunctor = new ValueOf(Integer.class).compose((UnaryFunctor)new Count((UnaryFunctor)constantUnary)).compose(this.iterateTableFn);
                    return new GeneratorRef(unaryFunctor.bind((Object)this.table), Long.class);
                }
                return new GeneratorRef(this.getRowCountFn.bind((Object)this.table), Integer.class);
            }
            UnaryFunctor unaryFunctor = bl ? this.makeFilterFn.bind2nd((Object)constantUnary).compose(this.iterateTableFn) : this.iterateTableFn;
            Generator generator = unaryFunctor.bind((Object)this.table);
            Class clazz = functorRefArray[0].getReturnType();
            if (clazz.isPrimitive()) {
                clazz = this.getBoxedType(clazz);
            }
            TransformUnary transformUnary = new TransformUnary(((UnaryFunctorRef)functorRefArray[0]).getFunctor());
            if ("avg".equals(string)) {
                this.validateArgument(Number.class, clazz, string);
                Average average = new Average(clazz);
                return new GeneratorRef(average.generate(transformUnary.generate(generator)), clazz);
            }
            Max max = null;
            if ("max".equals(string)) {
                this.validateArgument(Comparable.class, clazz, string);
                max = new Max((Comparator)new ComparableComparator());
            } else if ("min".equals(string)) {
                this.validateArgument(Comparable.class, clazz, string);
                max = new Min((Comparator)new ComparableComparator());
            } else if ("sum".equals(string)) {
                this.validateArgument(Number.class, clazz, string);
                max = new Plus(clazz);
            }
            if (max != null) {
                Generator generator2 = new Accumulate((BinaryFunctor)max).generate(transformUnary.generate(generator));
                return new GeneratorRef(generator2, clazz);
            }
        }
        return super.reservedFunction(string, functorRefArray);
    }

    private void setCurrentTable(DataTable dataTable) throws ParseException {
        if (this.table != null && dataTable != null) {
            throw new ParseException("Parser is currently associated with table " + this.table);
        }
        this.table = dataTable;
    }

    private UnaryFunctorRef makeColumnRef(DataTable dataTable, DataColumn dataColumn) {
        ApplyUnary applyUnary = new ApplyUnary(new UnaryFunctor[]{new Identity(), new ConstantUnary((Object)dataColumn)});
        InvokeMethod invokeMethod = new InvokeMethod(DataTable.class, "getValue", new Class[]{DataRow.class, DataColumn.class});
        UnaryFunctor unaryFunctor = invokeMethod.bind1st((Object)dataTable).compose((UnaryFunctor)applyUnary);
        return new UnaryFunctorRef(unaryFunctor, DataRow.class, ARG_NAME[0], dataColumn.getType());
    }

    private boolean isTableReference(FunctorRef functorRef) {
        return functorRef != null && functorRef.getReturnType().equals(DataTable.class) && functorRef.getReferenceType() == -2;
    }

    private DataTable getReferencedTable(FunctorRef functorRef) {
        return (DataTable)((GeneratorRef)functorRef).getFunctor().gen();
    }

    private void validateArgument(Class clazz, Class clazz2, String string) throws ParseException {
        if (clazz.isAssignableFrom(clazz2)) {
            return;
        }
        String string2 = "Unable to compute {0} of type {1}";
        Object[] objectArray = new Object[]{string, clazz2.getSimpleName()};
        throw new ParseException(MessageFormat.format(string2, objectArray));
    }
}

