/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataProvider;
import org.jdesktop.dataset.DataRelation;
import org.jdesktop.dataset.DataRelationTable;
import org.jdesktop.dataset.DataSelector;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.DataValue;
import org.jdesktop.dataset.provider.sql.JDBCDataConnection;
import org.jdesktop.dataset.provider.sql.SQLCommand;
import org.jdesktop.dataset.provider.sql.SQLDataProvider;
import org.jdesktop.dataset.provider.sql.TableCommand;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetUtils {
    private static final Logger LOG = Logger.getLogger(DataSetUtils.class.getName());

    private DataSetUtils() {
    }

    static boolean isValidName(String string) {
        return !string.matches(".*[\\s]");
    }

    public static String getXmlSchema(DataSet dataSet) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" standalone=\"yes\" ?>\n");
        stringBuilder.append("<xs:schema id=\"");
        stringBuilder.append(dataSet.getName());
        stringBuilder.append("\" targetNamespace=\"http://jdesktop.org/tempuri/");
        stringBuilder.append(dataSet.getName());
        stringBuilder.append(".xsd\" xmlns=\"http://javadesktop.org/tempuri/");
        stringBuilder.append(dataSet.getName());
        stringBuilder.append(".xsd\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\">\n");
        stringBuilder.append("\t<xs:element name=\"");
        stringBuilder.append(dataSet.getName());
        stringBuilder.append("\">\n");
        stringBuilder.append("\t\t<xs:complexType>\n");
        stringBuilder.append("\t\t\t<xs:choice maxOccurs=\"unbounded\">\n");
        for (DataTable object2 : dataSet.getTables()) {
            if (object2 instanceof DataRelationTable) continue;
            stringBuilder.append("\t\t\t\t<xs:element name=\"");
            stringBuilder.append(object2.getName());
            stringBuilder.append("\" appendRowSupported=\"");
            stringBuilder.append(object2.isAppendRowSupported());
            stringBuilder.append("\" deleteRowSupported=\"");
            stringBuilder.append(object2.isDeleteRowSupported());
            stringBuilder.append("\">\n");
            stringBuilder.append("\t\t\t\t\t<xs:complexType>\n");
            stringBuilder.append("\t\t\t\t\t\t<xs:sequence>\n");
            for (DataColumn dataColumn : object2.getColumns()) {
                stringBuilder.append("\t\t\t\t\t\t\t<xs:element name=\"");
                stringBuilder.append(dataColumn.getName());
                stringBuilder.append("\" type=\"");
                if (dataColumn.getType() == String.class || dataColumn.getType() == Character.class) {
                    stringBuilder.append("xs:string");
                } else if (dataColumn.getType() == BigDecimal.class) {
                    stringBuilder.append("xs:decimal");
                } else if (dataColumn.getType() == Integer.class) {
                    stringBuilder.append("xs:integer");
                } else if (dataColumn.getType() == Boolean.class) {
                    stringBuilder.append("xs:boolean");
                } else if (dataColumn.getType() == Date.class) {
                    stringBuilder.append("xs:dateTime");
                } else if (dataColumn.getType() == Byte.class) {
                    stringBuilder.append("xs:unsignedByte");
                } else {
                    LOG.log(Level.WARNING, "Couldn't find type for xsd for Class {0}", dataColumn.getType());
                }
                if (dataColumn.getDefaultValue() != null) {
                    stringBuilder.append("\" default=\"");
                    stringBuilder.append(dataColumn.getDefaultValue());
                }
                if (!dataColumn.isRequired()) {
                    stringBuilder.append("\" minOccurs=\"0");
                }
                stringBuilder.append("\" keyColumn=\"");
                stringBuilder.append(dataColumn.isKeyColumn());
                stringBuilder.append("\" readOnly=\"");
                stringBuilder.append(dataColumn.isReadOnly());
                if (dataColumn.getExpression() != null && !dataColumn.getExpression().trim().equals("")) {
                    stringBuilder.append("\" expression=\"");
                    stringBuilder.append(dataColumn.getExpression());
                }
                stringBuilder.append("\" />\n");
            }
            stringBuilder.append("\t\t\t\t\t\t</xs:sequence>\n");
            stringBuilder.append("\t\t\t\t\t</xs:complexType>\n");
            stringBuilder.append("\t\t\t\t</xs:element>\n");
        }
        stringBuilder.append("\t\t\t</xs:choice>\n");
        stringBuilder.append("\t\t</xs:complexType>\n");
        stringBuilder.append("\t\t<xs:annotation>\n");
        stringBuilder.append("\t\t\t<xs:appinfo>\n");
        for (DataRelation dataRelation : dataSet.getRelations()) {
            stringBuilder.append("\t\t\t\t<dataRelation name=\"");
            stringBuilder.append(dataRelation.getName());
            stringBuilder.append("\" parentColumn=\"");
            object = dataRelation.getParentColumn();
            if (object != null) {
                stringBuilder.append(((DataColumn)object).getTable().getName());
                stringBuilder.append(".");
                stringBuilder.append(((DataColumn)object).getName());
            }
            stringBuilder.append("\" childColumn=\"");
            object = dataRelation.getChildColumn();
            if (object != null) {
                stringBuilder.append(((DataColumn)object).getTable().getName());
                stringBuilder.append(".");
                stringBuilder.append(((DataColumn)object).getName());
            }
            stringBuilder.append("\" />\n");
        }
        for (DataTable dataTable : dataSet.getTables()) {
            if (!(dataTable instanceof DataRelationTable)) continue;
            object = (DataRelationTable)dataTable;
            stringBuilder.append("\t\t\t\t<dataRelationTable name=\"");
            stringBuilder.append(((DataTable)object).getName());
            stringBuilder.append("\" relation=\"");
            DataRelation dataRelation = ((DataRelationTable)object).getRelation();
            stringBuilder.append(dataRelation == null ? "" : dataRelation.getName());
            stringBuilder.append("\" parentSelector=\"");
            DataSelector dataSelector = ((DataRelationTable)object).getParentSelector();
            stringBuilder.append(dataSelector == null ? "" : dataSelector.getName());
            stringBuilder.append("\" parentTable=\"");
            DataTable dataTable2 = ((DataRelationTable)object).getParentTable();
            stringBuilder.append(dataTable2 == null ? "" : dataTable2.getName());
            stringBuilder.append("\" />\n");
        }
        for (DataValue dataValue : dataSet.getValues()) {
            stringBuilder.append("\t\t\t\t<dataValue name=\"");
            stringBuilder.append(dataValue.getName());
            stringBuilder.append("\" expression=\"");
            if (dataValue.getExpression() != null) {
                stringBuilder.append(dataValue.getExpression());
            }
            stringBuilder.append("\" />\n");
        }
        stringBuilder.append("\t\t\t</xs:appinfo>\n");
        stringBuilder.append("\t\t</xs:annotation>\n");
        stringBuilder.append("\t</xs:element>\n");
        stringBuilder.append("</xs:schema>\n");
        return stringBuilder.toString();
    }

    public static DataSet createFromXmlSchema(String string) {
        return DataSetUtils.createFromXmlSchema(new StringReader(string));
    }

    public static DataSet createFromXmlSchema(File file) throws FileNotFoundException {
        return DataSetUtils.createFromXmlSchema(new FileInputStream(file));
    }

    public static DataSet createFromXmlSchema(InputStream inputStream) {
        return DataSetUtils.createFromXmlSchema(new InputStreamReader(inputStream));
    }

    public static DataSet createFromXmlSchema(Reader reader) {
        DataSet dataSet = new DataSet();
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            InputSource inputSource = new InputSource(reader);
            sAXParser.parse(inputSource, (DefaultHandler)new DataSetParser(dataSet));
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Failed to create DataSet from xml schema from reader {0}. {1}", new Object[]{reader, exception.getStackTrace()});
        }
        return dataSet;
    }

    public static DataSet createFromDatabaseSchema(JDBCDataConnection jDBCDataConnection, String string, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray) {
            hashSet.add(string2);
        }
        DataSet dataSet = DataSetUtils.createFromDatabaseSchema(jDBCDataConnection.getConnection(), string, hashSet);
        for (DataTable dataTable : dataSet.getTables()) {
            if (dataTable instanceof DataRelationTable || dataTable.getDataProvider() == null) continue;
            dataTable.getDataProvider().setConnection(jDBCDataConnection);
        }
        return dataSet;
    }

    public static DataSet createFromDatabaseSchema(Connection connection, String string, Set<String> set) {
        DataSet dataSet = new DataSet();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            HashSet<String> hashSet = new HashSet<String>();
            for (String object7 : set) {
                if (object7.contains(".")) {
                    hashSet.add(object7.substring(0, object7.indexOf(".")));
                    continue;
                }
                hashSet.add(object7);
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            for (String string2 : hashSet) {
                object5 = dataSet.createTable(string2);
                if (set.contains(string2)) {
                    LOG.log(Level.FINE, "Including all columns");
                    object4 = databaseMetaData.getColumns(string, null, string2, null);
                    while (object4.next()) {
                        object3 = ((DataTable)object5).createColumn(object4.getString(4));
                        ((DataColumn)object3).setDefaultValue(object4.getObject(13));
                        ((DataColumn)object3).setReadOnly(false);
                        ((DataColumn)object3).setRequired(object4.getString(18).equals("NO"));
                        ((DataColumn)object3).setType(DataSetUtils.getType(object4.getInt(5)));
                    }
                } else {
                    object4 = new HashSet();
                    for (String string3 : set) {
                        if (!string3.startsWith(string2) || !string3.contains(".")) continue;
                        object2 = string3.substring(string3.indexOf(".") + 1);
                        object4.add(object2);
                    }
                    object3 = databaseMetaData.getPrimaryKeys(string, null, string2);
                    while (object3.next()) {
                        object4.add(object3.getString(4));
                    }
                    LOG.log(Level.FINE, "Including columns: " + object4);
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        object3 = databaseMetaData.getColumns(string, null, string2, (String)object2);
                        while (object3.next()) {
                            object = ((DataTable)object5).createColumn(object3.getString(4));
                            ((DataColumn)object).setDefaultValue(object3.getObject(13));
                            ((DataColumn)object).setReadOnly(false);
                            ((DataColumn)object).setRequired(object3.getString(18).equals("NO"));
                            ((DataColumn)object).setType(DataSetUtils.getType(object3.getInt(5)));
                        }
                    }
                }
                object4 = new SQLDataProvider(string2);
                ((DataTable)object5).setDataProvider((DataProvider)object4);
            }
            for (String string4 : hashSet) {
                try {
                    object5 = databaseMetaData.getImportedKeys(string, null, string4);
                    while (object5.next()) {
                        if (object5.getInt(9) > 1) continue;
                        object4 = object5.getString(7);
                        object3 = object5.getString(8);
                        DataTable dataTable = dataSet.getTable(string4);
                        object2 = dataTable.getColumn(object5.getString(4));
                        object = dataSet.getTable((String)object4);
                        DataColumn dataColumn = ((DataTable)object).getColumn((String)object3);
                        if (object2 != null && dataColumn != null && object2 != dataColumn) {
                            DataRelation dataRelation = dataSet.createRelation(object5.getString(12));
                            dataRelation.setParentColumn((DataColumn)object2);
                            dataRelation.setChildColumn(dataColumn);
                            continue;
                        }
                        if (object2 != dataColumn) continue;
                        LOG.log(Level.FINE, "column identity: {0}.{1} = {2}.{3}", new Object[]{object4, object3, dataTable.getName(), ((DataColumn)object2).getName()});
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.INFO, "Failed to create relations for table {0}. {1}", new Object[]{string4, exception.getStackTrace()});
                }
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Failed to create schema from database", exception);
        }
        return dataSet;
    }

    private static Class getType(int n) {
        switch (n) {
            case 2003: {
                return Object.class;
            }
            case -5: {
                return BigInteger.class;
            }
            case -2: {
                return Boolean.class;
            }
            case -7: {
                return Boolean.class;
            }
            case 2004: {
                return byte[].class;
            }
            case 16: {
                return Boolean.class;
            }
            case 1: {
                return Character.class;
            }
            case 2005: {
                return char[].class;
            }
            case 70: {
                return Object.class;
            }
            case 91: {
                return Date.class;
            }
            case 3: {
                return BigDecimal.class;
            }
            case 2001: {
                return Object.class;
            }
            case 8: {
                return BigDecimal.class;
            }
            case 6: {
                return BigDecimal.class;
            }
            case 4: {
                return BigInteger.class;
            }
            case 2000: {
                return Object.class;
            }
            case -4: {
                return byte[].class;
            }
            case -1: {
                return String.class;
            }
            case 0: {
                return Object.class;
            }
            case 2: {
                return BigDecimal.class;
            }
            case 1111: {
                return Object.class;
            }
            case 7: {
                return BigDecimal.class;
            }
            case 2006: {
                return Object.class;
            }
            case 5: {
                return Integer.class;
            }
            case 2002: {
                return Object.class;
            }
            case 92: {
                return Date.class;
            }
            case 93: {
                return Date.class;
            }
            case -6: {
                return Integer.class;
            }
            case -3: {
                return byte[].class;
            }
            case 12: {
                return String.class;
            }
        }
        LOG.log(Level.FINE, "Unsupported type");
        return Object.class;
    }

    private static void printResultSet(ResultSet resultSet) throws Exception {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
            stringBuilder.append(DataSetUtils.pad(resultSetMetaData.getColumnName(n + 1), ' '));
            for (int i = 0; i < 20; ++i) {
                stringBuilder2.append("-");
            }
            if (n >= resultSetMetaData.getColumnCount() - 1) continue;
            stringBuilder.append(" | ");
            stringBuilder2.append("---");
        }
        LOG.log(Level.FINE, stringBuilder.toString());
        LOG.log(Level.FINE, stringBuilder2.toString());
        stringBuilder = new StringBuilder();
        while (resultSet.next()) {
            for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
                Object object = resultSet.getObject(n + 1);
                String string = object == null ? "<null>" : object.toString();
                string = DataSetUtils.pad(string, ' ');
                stringBuilder.append(string);
                if (n >= resultSetMetaData.getColumnCount() - 1) continue;
                stringBuilder.append(" | ");
            }
            stringBuilder.append("\n");
        }
        LOG.log(Level.FINE, stringBuilder.toString());
    }

    private static String pad(String string, char c) {
        if (string == null) {
            return "<null>              ";
        }
        if (string.length() > 20) {
            return string.substring(0, 20);
        }
        if (string.length() < 20) {
            StringBuilder stringBuilder = new StringBuilder(string);
            for (int i = string.length(); i < 20; ++i) {
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static final class DataSetParser
    extends DefaultHandler {
        public int elementDepth = 0;
        private Attributes attrs;
        private DataSet ds;
        private DataTable table;
        private DataColumn column;
        private DataProvider dataProvider;

        public DataSetParser(DataSet dataSet) {
            this.ds = dataSet == null ? new DataSet() : dataSet;
        }

        public DataSet getDataSet() {
            return this.ds;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block36: {
                block37: {
                    this.attrs = attributes;
                    if (!string3.equals("xs:element")) break block37;
                    ++this.elementDepth;
                    switch (this.elementDepth) {
                        case 1: {
                            this.ds.setName(this.attrs.getValue("name"));
                            break;
                        }
                        case 2: {
                            this.table = this.ds.createTable(this.attrs.getValue("name"));
                            String string4 = this.attrs.getValue("appendRowSupported");
                            this.table.setAppendRowSupported(string4 == null || string4.equalsIgnoreCase("true"));
                            string4 = this.attrs.getValue("deleteRowSupported");
                            this.table.setDeleteRowSupported(string4 == null || string4.equalsIgnoreCase("true"));
                            break;
                        }
                        case 3: {
                            this.column = this.table.createColumn(this.attrs.getValue("name"));
                            String string5 = this.attrs.getValue("minOccurs");
                            if (string5 != null && string5.equals("")) {
                                this.column.setRequired(true);
                            }
                            this.column.setKeyColumn((string5 = this.attrs.getValue("keyColumn")) == null ? false : string5.equalsIgnoreCase("true"));
                            string5 = this.attrs.getValue("readOnly");
                            this.column.setReadOnly(string5 == null ? false : string5.equalsIgnoreCase("true"));
                            String string6 = this.attrs.getValue("default");
                            string5 = this.attrs.getValue("type");
                            if (string5.equals("xs:string")) {
                                this.column.setType(String.class);
                                if (string6 != null && !string6.equals("")) {
                                    this.column.setDefaultValue(string6);
                                }
                            } else if (string5.equals("xs:decimal")) {
                                this.column.setType(BigDecimal.class);
                                if (string6 != null && !string6.equals("")) {
                                    this.column.setDefaultValue(new BigDecimal(string6));
                                }
                            } else if (string5.equals("xs:integer") || string5.equals("xs:int")) {
                                this.column.setType(Integer.class);
                                if (string6 != null && !string6.equals("")) {
                                    this.column.setDefaultValue(new Integer(string6));
                                }
                            } else if (string5.equals("xs:boolean")) {
                                this.column.setType(Boolean.class);
                                if (string6 != null && !string6.equals("")) {
                                    this.column.setDefaultValue(Boolean.parseBoolean(string6));
                                }
                            } else if (string5.equals("xs:date") || string5.equals("xs:time") || string5.equals("xs.dateTime")) {
                                this.column.setType(Date.class);
                                if (string6 != null && !string6.equals("")) {
                                    this.column.setDefaultValue(new Date(Date.parse(string6)));
                                }
                            } else if (string5.equals("xs:unsignedByte")) {
                                this.column.setType(Byte.class);
                                if (string6 != null && !string6.equals("")) {
                                    this.column.setDefaultValue(new Byte(string6));
                                }
                            } else {
                                LOG.log(Level.WARNING, "unexpected classType: '{0}'", string5);
                            }
                            if ((string5 = this.attrs.getValue("expression")) != null && !"".equals(string5)) {
                                this.column.setExpression(string5);
                                break;
                            }
                            break block36;
                        }
                        default: {
                            LOG.log(Level.FINE, "Error in DataSetParser");
                            break;
                        }
                    }
                    break block36;
                }
                if (string3.equals("dataProvider")) {
                    String string7 = this.attrs.getValue("class");
                    if (string7 != null) {
                        try {
                            this.dataProvider = (DataProvider)Class.forName(string7).newInstance();
                            this.table.setDataProvider(this.dataProvider);
                            if (!(this.dataProvider instanceof SQLDataProvider)) break block36;
                            String string8 = this.attrs.getValue("tableName");
                            if (string8 != null && !string8.equals("")) {
                                TableCommand tableCommand = new TableCommand(string8);
                                tableCommand.setWhereClause(this.attrs.getValue("whereClause"));
                                tableCommand.setOrderByClause(this.attrs.getValue("orderByClause"));
                                tableCommand.setHavingClause(this.attrs.getValue("havingClause"));
                                this.dataProvider.setCommand(tableCommand);
                                break block36;
                            }
                            SQLCommand sQLCommand = new SQLCommand();
                            sQLCommand.setSelectSQL(this.attrs.getValue("select"));
                            sQLCommand.setInsertSQL(this.attrs.getValue("insert"));
                            sQLCommand.setUpdateSQL(this.attrs.getValue("update"));
                            sQLCommand.setDeleteSQL(this.attrs.getValue("delete"));
                            this.dataProvider.setCommand(sQLCommand);
                        }
                        catch (Exception exception) {
                            LOG.log(Level.WARNING, "Unsupported DataProvider {0}. {1}", new Object[]{string7, exception.getStackTrace()});
                        }
                    }
                } else if (string3.equals("dataRelationTable")) {
                    DataRelationTable dataRelationTable = this.ds.createRelationTable(this.attrs.getValue("name"));
                    dataRelationTable.setRelation((DataRelation)this.ds.getElement(this.attrs.getValue("relation")));
                    dataRelationTable.setParentSelector((DataSelector)this.ds.getElement(this.attrs.getValue("parentSelector")));
                    dataRelationTable.setParentTable((DataTable)this.ds.getElement(this.attrs.getValue("parentTable")));
                } else if (string3.equals("dataRelation")) {
                    DataRelation dataRelation = this.ds.createRelation(this.attrs.getValue("name"));
                    dataRelation.setParentColumn((DataColumn)this.ds.getElement(this.attrs.getValue("parentColumn")));
                    dataRelation.setChildColumn((DataColumn)this.ds.getElement(this.attrs.getValue("childColumn")));
                } else if (string3.equals("dataValue")) {
                    DataValue dataValue = this.ds.createValue(this.attrs.getValue("name"));
                    dataValue.setExpression(this.attrs.getValue("expression"));
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("xs:element")) {
                switch (this.elementDepth) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        LOG.log(Level.FINE, "Error in DataSetParser");
                    }
                }
                --this.elementDepth;
            }
        }

        public void endDocument() throws SAXException {
        }
    }
}

