/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataRelation;
import org.jdesktop.dataset.DataRelationTable;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataSelector;
import org.jdesktop.dataset.DataSetUtils;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.DataValue;
import org.jdesktop.dataset.NameGenerator;
import org.jdesktop.dataset.Parser;
import org.jdesktop.dataset.event.TableChangeEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet {
    private static final Logger LOG = Logger.getLogger(DataSet.class.getName());
    protected static final String DEFAULT_NAME_PREFIX = "DataSet";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataSet");
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String name;
    private Map<String, DataTable> tables = new HashMap<String, DataTable>();
    private Map<String, DataRelation> relations = new HashMap<String, DataRelation>();
    private Map<String, DataValue> values = new HashMap<String, DataValue>();
    private Parser parser = new Parser();
    private NameChangeListener nameChangeListener = new NameChangeListener();

    public DataSet() {
        this.parser.bindThis(this);
        this.parser.setUndecoratedDecimal(true);
        this.setName(NAMEGEN.generateName(this));
    }

    public DataSet(String string) {
        this.parser.bindThis(this);
        this.parser.setUndecoratedDecimal(true);
        this.setName(string);
    }

    public void setName(String string) {
        if (this.name != string) {
            assert (DataSetUtils.isValidName(string));
            String string2 = this.name;
            this.name = string;
            this.pcs.firePropertyChange("name", string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public DataTable createTable() {
        return this.createTable(null);
    }

    public DataTable createTable(String string) {
        DataTable dataTable = new DataTable(this, string);
        dataTable.addPropertyChangeListener("name", this.nameChangeListener);
        this.tables.put(dataTable.getName(), dataTable);
        return dataTable;
    }

    public DataRelationTable createRelationTable() {
        return this.createRelationTable(null);
    }

    public DataRelationTable createRelationTable(String string) {
        DataRelationTable dataRelationTable = new DataRelationTable(this, string);
        dataRelationTable.addPropertyChangeListener("name", this.nameChangeListener);
        this.tables.put(dataRelationTable.getName(), dataRelationTable);
        return dataRelationTable;
    }

    public DataRelation createRelation() {
        return this.createRelation(null);
    }

    public DataRelation createRelation(String string) {
        DataRelation dataRelation = new DataRelation(this, string);
        dataRelation.addPropertyChangeListener("name", this.nameChangeListener);
        this.relations.put(dataRelation.getName(), dataRelation);
        return dataRelation;
    }

    public DataValue createValue() {
        return this.createValue(null);
    }

    public DataValue createValue(String string) {
        DataValue dataValue = new DataValue(this, string);
        dataValue.addPropertyChangeListener("name", this.nameChangeListener);
        this.values.put(dataValue.getName(), dataValue);
        return dataValue;
    }

    public void dropTable(DataTable dataTable) {
        this.dropTable(dataTable.getName());
    }

    public void dropTable(String string) {
        DataTable dataTable = this.tables.remove(string);
        if (dataTable != null) {
            Object object;
            dataTable.removePropertyChangeListener("name", this.nameChangeListener);
            for (DataRelation object2 : this.relations.values()) {
                object = object2.getChildColumn();
                if (object != null && ((DataColumn)object).getTable() == dataTable) {
                    object2.setChildColumn(null);
                }
                if ((object = object2.getParentColumn()) == null || ((DataColumn)object).getTable() != dataTable) continue;
                object2.setParentColumn(null);
            }
            for (DataTable dataTable2 : this.tables.values()) {
                if (!(dataTable2 instanceof DataRelationTable)) continue;
                object = (DataRelationTable)dataTable2;
                if (((DataRelationTable)object).getParentTable() == dataTable) {
                    ((DataRelationTable)object).setParentTable(null);
                }
                if (((DataRelationTable)object).getParentSelector() == null || ((DataRelationTable)object).getParentSelector().getTable() != dataTable) continue;
                ((DataRelationTable)object).setParentSelector(null);
            }
        }
    }

    public void dropRelationTable(DataRelationTable dataRelationTable) {
        this.dropTable(dataRelationTable.getName());
    }

    public void dropRelationTable(String string) {
        this.dropTable(string);
    }

    public void dropRelation(DataRelation dataRelation) {
        this.dropRelation(dataRelation.getName());
    }

    public void dropRelation(String string) {
        DataRelation dataRelation = this.relations.remove(string);
        if (dataRelation != null) {
            dataRelation.removePropertyChangeListener("name", this.nameChangeListener);
            for (DataTable dataTable : this.tables.values()) {
                DataRelationTable dataRelationTable;
                if (!(dataTable instanceof DataRelationTable) || (dataRelationTable = (DataRelationTable)dataTable).getRelation() != dataRelation) continue;
                dataRelationTable.setRelation(null);
            }
        }
    }

    public void dropValue(DataValue dataValue) {
        this.dropValue(dataValue.getName());
    }

    public void dropValue(String string) {
        this.values.remove(string).removePropertyChangeListener("name", this.nameChangeListener);
    }

    protected boolean hasElement(String string) {
        boolean bl = this.relations.containsKey(string);
        if (!bl) {
            bl = this.tables.containsKey(string);
        }
        if (!bl) {
            bl = this.values.containsKey(string);
        }
        return bl;
    }

    public Object getElement(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains(".")) {
            String[] stringArray = string.split("\\.");
            assert (stringArray.length == 2);
            DataTable dataTable = this.tables.get(stringArray[0]);
            DataColumn dataColumn = dataTable.getColumn(stringArray[1]);
            if (dataColumn != null) {
                return dataColumn;
            }
            return dataTable.getSelector(stringArray[1]);
        }
        if (this.relations.containsKey(string)) {
            return this.relations.get(string);
        }
        if (this.tables.containsKey(string)) {
            return this.tables.get(string);
        }
        if (this.values.containsKey(string)) {
            return this.values.get(string);
        }
        return null;
    }

    public List<DataRow> getRows(String string) {
        if (string == null || string.trim().equals("")) {
            return Collections.EMPTY_LIST;
        }
        string = string.trim();
        String[] stringArray = string.split("\\.");
        List<DataRow> list = null;
        for (String string2 : stringArray) {
            Object object;
            String string3 = null;
            String string4 = null;
            if (string2.contains("[")) {
                string3 = string2.substring(0, string2.indexOf(91));
                string4 = string2.substring(string2.indexOf(91) + 1, string2.indexOf(93));
            }
            if (list == null) {
                object = this.tables.get(string3);
                if (object == null) assert (false);
                list = ((DataTable)object).getRows();
                if (string4 == null) continue;
            }
            object = this.relations.get(string3);
            if (object == null) assert (false);
            list = ((DataRelation)object).getRows(list.toArray(new DataRow[list.size()]));
            if (string4 == null) continue;
        }
        return Collections.unmodifiableList(list);
    }

    public List<DataRow> filterRows(List<DataRow> list, DataSelector dataSelector) {
        List<Integer> list2 = dataSelector.getRowIndices();
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>(list2.size());
        for (int n : list2) {
            arrayList.add(list.get(n));
        }
        return arrayList;
    }

    public List<DataColumn> getColumns(String string) {
        Object object;
        String[] stringArray = string.split("\\.");
        assert (stringArray.length == 1 || stringArray.length == 2);
        DataTable dataTable = this.tables.get(stringArray[0]);
        if (dataTable == null) {
            object = this.relations.get(stringArray[0]);
            if (object == null) {
                return new ArrayList<DataColumn>();
            }
            dataTable = ((DataRelation)object).getChildColumn().getTable();
        }
        if (stringArray.length == 1) {
            return dataTable.getColumns();
        }
        object = new ArrayList();
        object.add(dataTable.getColumn(stringArray[1]));
        return Collections.unmodifiableList(object);
    }

    public DataTable getTable(String string) {
        return this.tables.get(string);
    }

    public List<DataTable> getTables() {
        ArrayList<DataTable> arrayList = new ArrayList<DataTable>();
        for (DataTable dataTable : this.tables.values()) {
            arrayList.add(dataTable);
        }
        return arrayList;
    }

    public DataRelationTable getRelationTable(String string) {
        return (DataRelationTable)this.tables.get(string);
    }

    public DataValue getValue(String string) {
        return this.values.get(string);
    }

    public List<DataValue> getValues() {
        ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
        for (DataValue dataValue : this.values.values()) {
            arrayList.add(dataValue);
        }
        return arrayList;
    }

    public DataRelation getRelation(String string) {
        return this.relations.get(string);
    }

    public List<DataRelation> getRelations() {
        ArrayList<DataRelation> arrayList = new ArrayList<DataRelation>();
        for (DataRelation dataRelation : this.relations.values()) {
            arrayList.add(dataRelation);
        }
        return arrayList;
    }

    public void load() {
        for (DataTable dataTable : this.tables.values()) {
            if (dataTable instanceof DataRelationTable) continue;
            dataTable.load();
        }
    }

    public void loadAndWait() {
        for (DataTable dataTable : this.tables.values()) {
            if (dataTable instanceof DataRelationTable) continue;
            dataTable.loadAndWait();
        }
    }

    public void refresh() {
        for (DataTable dataTable : this.tables.values()) {
            if (dataTable instanceof DataRelationTable) continue;
            dataTable.refresh();
        }
    }

    public void refreshAndWait() {
        for (DataTable dataTable : this.tables.values()) {
            if (dataTable instanceof DataRelationTable) continue;
            dataTable.refreshAndWait();
        }
    }

    public void clear() {
        for (DataTable dataTable : this.tables.values()) {
            if (dataTable instanceof DataRelationTable) continue;
            dataTable.clear();
        }
    }

    public void save() {
        for (DataTable dataTable : this.tables.values()) {
            if (dataTable instanceof DataRelationTable) continue;
            dataTable.save();
        }
    }

    public void saveAndWait() {
        for (DataTable dataTable : this.tables.values()) {
            if (dataTable instanceof DataRelationTable) continue;
            dataTable.saveAndWait();
        }
    }

    Parser getParser() {
        return this.parser;
    }

    public static DataSet createFromSchema(String string) {
        return DataSetUtils.createFromXmlSchema(string);
    }

    public String getSchema() {
        return DataSetUtils.getXmlSchema(this);
    }

    public static DataSet createFromSchema(File file) throws FileNotFoundException {
        return DataSetUtils.createFromXmlSchema(file);
    }

    public static DataSet createFromSchema(InputStream inputStream) {
        return DataSetUtils.createFromXmlSchema(inputStream);
    }

    public void readXml(File file) {
        String string = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.readXml(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Failed to read xml from file {0}. {1}", new Object[]{file, exception.getStackTrace()});
        }
    }

    public void readXml(InputStream inputStream) {
        String string = "";
        try {
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[4096];
            int n = -1;
            while ((n = inputStream.read(byArray)) != -1) {
                stringBuilder.append(new String(byArray, 0, n));
            }
            string = stringBuilder.toString();
            this.readXml(string);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Failed to read xml from input stream.", exception);
        }
    }

    public void readXml(String string) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            XPath xPath = XPathFactory.newInstance().newXPath();
            String string2 = null;
            for (DataTable dataTable : this.tables.values()) {
                if (dataTable instanceof DataRelationTable) continue;
                dataTable.fireDataTableChanged(TableChangeEvent.newLoadStartEvent(dataTable));
                dataTable.clear();
                if (!dataTable.isAppendRowSupported()) {
                    LOG.fine("Table '" + dataTable.getName() + "' does " + "not support append row; skipping (regardless of " + "input).");
                    continue;
                }
                LOG.finer("loading table " + dataTable.getName());
                string2 = "/" + this.name + "/" + dataTable.getName();
                NodeList nodeList = (NodeList)xPath.evaluate(string2, document, XPathConstants.NODESET);
                LOG.finer("  found " + nodeList.getLength() + " rows for path " + string2);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    DataRow dataRow = dataTable.appendRowNoEvent();
                    NodeList nodeList2 = node.getChildNodes();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Node node2 = nodeList2.item(j);
                        if (node2.getNodeType() != 1) continue;
                        String string3 = node2.getTextContent();
                        Object object = string3;
                        Class clazz = dataTable.getColumn(node2.getNodeName()).getType();
                        if (clazz == BigDecimal.class) {
                            object = new BigDecimal(string3);
                        }
                        dataRow.setValue(node2.getNodeName(), object);
                    }
                    dataRow.setStatus(DataRow.DataRowStatus.UNCHANGED);
                }
                dataTable.fireDataTableChanged(TableChangeEvent.newLoadCompleteEvent(dataTable));
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Failed to parse xml {0}. {1}", new Object[]{string, exception.getStackTrace()});
        }
    }

    public String writeXml() {
        return this.writeXml(OutputControl.ALL_ROWS);
    }

    public String writeXml(OutputControl outputControl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" ?>\n");
        stringBuilder.append("<");
        stringBuilder.append(this.name);
        stringBuilder.append(">\n");
        for (DataTable dataTable : this.tables.values()) {
            if (dataTable instanceof DataRelationTable) continue;
            for (DataRow dataRow : dataTable.rows) {
                if (outputControl == OutputControl.MODIFIED_ONLY && dataRow.getStatus() == DataRow.DataRowStatus.UNCHANGED) continue;
                stringBuilder.append("\t<");
                stringBuilder.append(dataTable.getName());
                stringBuilder.append(">\n");
                for (DataColumn dataColumn : dataTable.columns.values()) {
                    stringBuilder.append("\t\t<");
                    stringBuilder.append(dataColumn.getName());
                    stringBuilder.append(">");
                    String string = dataRow.getValue(dataColumn) == null ? "" : dataRow.getValue(dataColumn).toString();
                    string = string.replaceAll("&", "&amp;");
                    string = string.replaceAll("<", "&lt;");
                    string = string.replaceAll(">", "&gt;");
                    string = string.replaceAll("'", "&apos;");
                    string = string.replaceAll("\"", "&quot;");
                    stringBuilder.append(string);
                    stringBuilder.append("</");
                    stringBuilder.append(dataColumn.getName());
                    stringBuilder.append(">\n");
                }
                stringBuilder.append("\t</");
                stringBuilder.append(dataTable.getName());
                stringBuilder.append(">\n");
            }
        }
        stringBuilder.append("</");
        stringBuilder.append(this.name);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataSet: ").append(this.name).append("\n");
        for (DataTable object : this.tables.values()) {
            if (object instanceof DataRelationTable) {
                stringBuilder.append("\tDataRelationTable: ").append(object.getName()).append("\n");
            } else {
                stringBuilder.append("\tDataTable: ").append(object.getName()).append("\n");
            }
            for (DataColumn dataColumn : object.getColumns()) {
                stringBuilder.append("\t\tDataColumn: ").append(dataColumn.getName()).append("\n");
            }
        }
        for (DataRelation dataRelation : this.relations.values()) {
            DataColumn dataColumn;
            stringBuilder.append("\tRelation: ").append(dataRelation.getName()).append("\n");
            DataColumn dataColumn2 = dataRelation.getParentColumn();
            stringBuilder.append("\t\tParentColumn: ").append(dataColumn2 == null ? "<none>" : dataColumn2.getTable().getName()).append(".").append(dataColumn2 == null ? "<none>" : dataColumn2.getName()).append("\n");
            dataColumn = dataRelation.getChildColumn();
            stringBuilder.append("\t\tChildColumn: ").append(dataColumn == null ? "<none>" : dataColumn.getTable().getName()).append(".").append(dataColumn == null ? "<none>" : dataColumn.getName()).append("\n");
        }
        stringBuilder.append(this.getSchema());
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        try {
            DataSet dataSet = DataSetUtils.createFromXmlSchema(new File("/usr/local/src/databinding/src/test/org/jdesktop/dataset/contact.ds"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l);
    }

    private final class NameChangeListener
    implements PropertyChangeListener {
        private NameChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof DataTable) {
                DataTable dataTable = (DataTable)object;
                DataSet.this.tables.remove(propertyChangeEvent.getOldValue());
                DataSet.this.tables.put((String)propertyChangeEvent.getNewValue(), dataTable);
            } else if (object instanceof DataRelation) {
                DataRelation dataRelation = (DataRelation)object;
                DataSet.this.relations.remove(propertyChangeEvent.getOldValue());
                DataSet.this.relations.put((String)propertyChangeEvent.getNewValue(), dataRelation);
            } else if (object instanceof DataValue) {
                DataValue dataValue = (DataValue)object;
                DataSet.this.values.remove(propertyChangeEvent.getOldValue());
                DataSet.this.values.put((String)propertyChangeEvent.getNewValue(), dataValue);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputControl {
        ALL_ROWS,
        MODIFIED_ONLY;

    }
}

