/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx.adapter;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSet;
import javax.swing.table.AbstractTableModel;

public class RowSetAdapter
extends AbstractTableModel {
    private RowSet rowset;
    private ResultSetMetaData metaData;

    private RowSetAdapter(RowSet rowSet) throws SQLException {
        if (rowSet == null) {
            throw new NullPointerException("rowset cannot be null");
        }
        this.rowset = rowSet;
        this.metaData = rowSet.getMetaData();
    }

    public Class getColumnClass(int n) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.metaData.getColumnClassName(this.translateAdapterColumn(n)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    public int getRowCount() {
        return 0;
    }

    public int getColumnCount() {
        int n = 0;
        try {
            n = this.metaData.getColumnCount();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        Object object = null;
        try {
            RowSet rowSet = this.rowset;
            synchronized (rowSet) {
                this.rowset.absolute(this.translateAdapterRow(n));
                object = this.rowset.getObject(this.translateAdapterColumn(n2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        try {
            bl = this.metaData.isWritable(this.translateAdapterColumn(n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    protected int translateAdapterColumn(int n) {
        return n + 1;
    }

    protected int translateDataColumn(int n) {
        return n - 1;
    }

    protected int translateAdapterRow(int n) {
        return n + 1;
    }

    protected int translateDataRow(int n) {
        return n - 1;
    }
}

