/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.swingx.AbstractBinding;

public class SpinnerBinding
extends AbstractBinding {
    private JComponent component;
    private SpinnerModel spinnerModel;

    public SpinnerBinding(JSpinner jSpinner, DataModel dataModel, String string) {
        super(jSpinner, dataModel, string, 0);
        this.initModel(jSpinner.getModel());
    }

    public SpinnerBinding(JSpinner jSpinner, DataModel dataModel, String string, int n) {
        super(jSpinner, dataModel, string, n);
        this.initModel(jSpinner.getModel());
    }

    public SpinnerBinding(JComponent jComponent, SpinnerModel spinnerModel, DataModel dataModel, String string, int n) {
        super(jComponent, dataModel, string, n);
        this.initModel(spinnerModel);
    }

    public JComponent getComponent() {
        return this.component;
    }

    protected void setComponent(JComponent jComponent) {
        this.component = jComponent;
        this.configureEditability();
    }

    protected void configureEditability() {
        if (!(this.component instanceof JSpinner)) {
            return;
        }
        JSpinner jSpinner = (JSpinner)this.component;
        jSpinner.setEnabled(!this.metaData.isReadOnly());
    }

    protected void installMetaDataListener() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("readOnly".equals(propertyChangeEvent.getPropertyName())) {
                    SpinnerBinding.this.configureEditability();
                }
            }
        };
        this.metaData.addPropertyChangeListener(propertyChangeListener);
    }

    protected Object getComponentValue() {
        return this.spinnerModel.getValue();
    }

    protected void setComponentValue(Object object) {
        if (object != null) {
            this.spinnerModel.setValue(object);
        }
    }

    private void initModel(SpinnerModel spinnerModel) {
        this.spinnerModel = spinnerModel;
        spinnerModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!SpinnerBinding.this.pulling) {
                    SpinnerBinding.this.setModified(true);
                }
            }
        });
    }
}

