/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdesktop.binding.metadata.MetaData;
import org.jdesktop.binding.metadata.MetaDataProvider;

public class DefaultMetaDataProvider
implements MetaDataProvider {
    private List fieldNames;
    private Map metaData;

    public DefaultMetaDataProvider() {
    }

    public DefaultMetaDataProvider(MetaDataProvider metaDataProvider) {
        this(metaDataProvider.getMetaData());
    }

    public DefaultMetaDataProvider(MetaData[] metaDataArray) {
        this.setMetaData(metaDataArray);
    }

    public MetaData[] getMetaData() {
        MetaData[] metaDataArray = new MetaData[this.getFieldCount()];
        for (int i = 0; i < metaDataArray.length; ++i) {
            metaDataArray[i] = this.getMetaData(this.getFieldName(i));
        }
        return metaDataArray;
    }

    public MetaData getMetaData(String string) {
        return (MetaData)this.getMetaDataMap().get(string);
    }

    public String[] getFieldNames() {
        return this.getFieldNameList().toArray(new String[this.getFieldCount()]);
    }

    public int getFieldCount() {
        return this.getFieldNameList().size();
    }

    public String getFieldName(int n) {
        return (String)this.getFieldNameList().get(n);
    }

    public MetaData getMetaData(int n) {
        String string = this.getFieldName(n);
        return this.getMetaData(string);
    }

    public int getFieldIndex(String string) {
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (!string.equals(this.getFieldName(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean hasField(String string) {
        return this.getFieldNameList().contains(string);
    }

    public void setMetaData(MetaData[] metaDataArray) {
        this.clear();
        for (int i = 0; i < metaDataArray.length; ++i) {
            this.addField(metaDataArray[i]);
        }
    }

    public void setMetaData(List list) {
        this.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addField((MetaData)iterator.next());
        }
    }

    public void addField(MetaData metaData) {
        this.getFieldNameList().add(metaData.getName());
        this.getMetaDataMap().put(metaData.getName(), metaData);
    }

    public void clear() {
        this.fieldNames = null;
        this.metaData = null;
    }

    private List getFieldNameList() {
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList();
        }
        return this.fieldNames;
    }

    private Map getMetaDataMap() {
        if (this.metaData == null) {
            this.metaData = new HashMap();
        }
        return this.metaData;
    }
}

