/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.argv;

import java.util.List;
import org.freehep.util.argv.BailOutException;
import org.freehep.util.argv.MissingArgumentException;
import org.freehep.util.argv.Option;

public class StringOption
implements Option {
    private String flag;
    private String shortCut;
    private String name;
    private String desc;
    private String defaultValue;
    private String value = null;
    private boolean bailOut;

    public StringOption(String flag, String name, String description) {
        this(flag, name, null, description);
    }

    public StringOption(String flag, String name, String defaultValue, String description) {
        this(flag, null, name, defaultValue, description);
    }

    public StringOption(String flag, String shortCut, String name, String defaultValue, String description) {
        this(flag, shortCut, name, defaultValue, description, false);
    }

    public StringOption(String flag, String shortCut, String name, String defaultValue, String description, boolean bailOut) {
        this.flag = flag;
        this.shortCut = shortCut;
        this.name = name;
        this.desc = description;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        this.bailOut = bailOut;
    }

    public String getValue() {
        return this.value;
    }

    public int parse(List values) throws MissingArgumentException, BailOutException {
        if (values.get(0).equals(this.flag) || values.get(0).equals(this.shortCut)) {
            if (values.size() == 1) {
                throw new MissingArgumentException(this.flag + ": expects '" + this.name + "' of type <string>");
            }
            this.value = (String)values.get(1);
            if (this.bailOut) {
                throw new BailOutException();
            }
            return 2;
        }
        return 0;
    }

    public String getOption() {
        StringBuffer s = new StringBuffer(this.flag);
        s.append(" <");
        s.append(this.name);
        if (this.defaultValue != null) {
            s.append("=");
            s.append(this.defaultValue);
        }
        s.append(">");
        return s.toString();
    }

    public String getUsage() {
        return this.desc;
    }
}

