/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.ClipEventFlags;
import org.freehep.graphicsio.swf.SWFAction;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class ClipActionRecord {
    private ClipEventFlags eventFlags;
    private long actionRecordSize;
    private int keyCode;
    private Vector actions;

    public ClipActionRecord(SWFInputStream swf) throws IOException {
        this.eventFlags = new ClipEventFlags(swf);
        if (this.eventFlags.isEndFlag()) {
            return;
        }
        this.actionRecordSize = swf.readUnsignedInt();
        swf.pushBuffer((int)(this.actionRecordSize - 4L));
        if (this.eventFlags.isKeyPress()) {
            this.keyCode = swf.readUnsignedByte();
        }
        while (swf.getLength() > 0L) {
            this.actions.add(swf.readAction());
        }
        byte[] rest = swf.popBuffer();
        if (rest != null) {
            System.err.println("Corrupted ClipActionRecord, " + rest.length + " bytes leftoever.");
        }
    }

    public void write(SWFOutputStream swf) throws IOException {
        this.eventFlags.write(swf);
        swf.writeUnsignedInt(this.actionRecordSize);
        if (this.eventFlags.isKeyPress()) {
            swf.writeUnsignedByte(this.keyCode);
        }
        for (int i = 0; i < this.actions.size(); ++i) {
            SWFAction a = (SWFAction)this.actions.get(i);
            swf.writeAction(a);
        }
    }

    public boolean isEndRecord() {
        return this.eventFlags.isEndFlag();
    }

    public String toString() {
        return "ClipActionRecord " + this.actions.size();
    }
}

