/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.FileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HelpPropertiesManager {
    private static Logger logger = Logger.getLogger("StaticLogger");
    public static final String UNDEFINED = "undefined";
    private static Properties properties = new Properties();
    private static File preferencesFile;

    static {
        try {
            preferencesFile = FileManager.getInstance().getHelpFile();
            FileInputStream iStream = new FileInputStream(preferencesFile);
            properties.load(iStream);
            iStream.close();
        }
        catch (Exception e) {
            logger.error("Error while reading properties file.", e.getCause());
            System.out.println(e.getCause());
        }
    }

    public static synchronized String getPreferenceString(String key) {
        String value = properties.getProperty(key, UNDEFINED);
        return value;
    }

    public static synchronized void initPreferenceString(String key) throws IOException {
        if (preferencesFile == null) {
            System.out.println("help preferencies file does not exist");
            return;
        }
        FileOutputStream oStream = new FileOutputStream(preferencesFile);
        properties.setProperty(key, UNDEFINED);
        properties.store(oStream, "Help Preferences file for Ice Client");
        oStream.close();
    }

    public static synchronized void initPreferenceString(String key, String value) throws IOException {
        if (preferencesFile == null) {
            System.out.println("help preferencies file does not exist");
            return;
        }
        FileOutputStream oStream = new FileOutputStream(preferencesFile);
        properties.setProperty(key, value);
        properties.store(oStream, "Help Preferences file for Ice Client");
        oStream.close();
    }
}

