/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.textFields;

import ice.event.MinMaxResetEvent;
import ice.event.NumberOutOfRangeListener;
import ice.event.TextChangedThroughSetText;
import ice.swing.textFields.ChangeBackgroundOnEditFormattedTextField;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;

public class ICEDecimalFormattedTextField
extends ChangeBackgroundOnEditFormattedTextField
implements FocusListener {
    protected static final int DEFAULT_NUMBER_OF_DECIMALPLACES = 10;
    private static final String STARTER_FORMAT_STRING = "####0.0";
    protected DecimalFormat decimalFormat;
    protected boolean allowsNegitives;
    protected double minValue;
    protected double maxValue;
    protected String oldText;
    protected ArrayList<NumberOutOfRangeListener> numberOutOfRangeListeners;
    protected boolean allowEmptyText;
    protected int lostFocusBehavior;
    protected NumberOutOfRangeListener.NumberRange state;

    public ICEDecimalFormattedTextField() {
        this(10, true);
    }

    public ICEDecimalFormattedTextField(int maximumFractionDigits) {
        this(maximumFractionDigits, true);
    }

    public ICEDecimalFormattedTextField(boolean allowsNegtives) {
        this(10, allowsNegtives);
    }

    public ICEDecimalFormattedTextField(int maximumFractionDigits, boolean allowsNegetive) {
        this(DecimalFormat.getInstance());
        this.init(maximumFractionDigits, allowsNegetive);
    }

    private ICEDecimalFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
    }

    private ICEDecimalFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
    }

    private ICEDecimalFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
    }

    private ICEDecimalFormattedTextField(Object value) {
        super(value);
    }

    protected ICEDecimalFormattedTextField(Format format) {
        super(format);
        this.decimalFormat = (DecimalFormat)format;
    }

    protected void init(int maximumFractionDigits, boolean allowsNegitives) {
        NumberFormatter nf = null;
        NumberOutOfRangeListener.NumberRange state = NumberOutOfRangeListener.NumberRange.NOT_A_NUMBER;
        this.addFocusListener(this);
        this.numberOutOfRangeListeners = new ArrayList();
        this.allowEmptyText = false;
        this.allowsNegitives = allowsNegitives;
        this.lostFocusBehavior = this.getFocusLostBehavior();
        this.setMinValue(-1.7976931348623157E308);
        this.setMaxValue(Double.MAX_VALUE);
        this.oldText = this.getText();
        nf = (NumberFormatter)this.getFormatter();
        nf.setAllowsInvalid(true);
        nf.setOverwriteMode(false);
        this.setNumberOfFractionDigits(maximumFractionDigits);
        this.formattedState = false;
    }

    public void allowEmptyText(boolean allow) {
        this.allowEmptyText = allow;
        if (this.allowEmptyText) {
            this.lostFocusBehavior = this.getFocusLostBehavior();
            this.setFocusLostBehavior(3);
        } else {
            this.setFocusLostBehavior(this.lostFocusBehavior);
        }
    }

    public void setNumberOfFractionDigits(int n) {
        String formatString = STARTER_FORMAT_STRING;
        int i = 0;
        while (i < n - 1) {
            formatString = String.valueOf(formatString) + "#";
            ++i;
        }
        this.decimalFormat.applyPattern(formatString);
        this.decimalFormat.setDecimalSeparatorAlwaysShown(true);
    }

    public int getNumberOfFractionDigits() {
        return this.decimalFormat.getMaximumFractionDigits();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = this.allowsNegitives ? minValue : 0.0;
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(new MinMaxResetEvent(this));
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(new MinMaxResetEvent(this));
    }

    public double getDouble() {
        double theValue = 0.0;
        theValue = ((Number)this.getValue()).doubleValue();
        return theValue;
    }

    @Override
    public void setText(String text) {
        Object theDouble = null;
        this.oldText = this.getText();
        if (this.allowEmptyText && (text == null || text.trim().equals(""))) {
            super.setText("");
            return;
        }
        if (text == null || text.trim().equals("N/A")) {
            super.setText(text);
            return;
        }
        if (text == null || text.length() == 0) {
            text = "0.0";
        }
        if (this.decimalFormat != null) {
            double tempDouble = 0.0;
            try {
                tempDouble = Double.valueOf(text);
                text = this.decimalFormat.format(tempDouble);
            }
            catch (NumberFormatException e) {
                Toolkit.getDefaultToolkit().beep();
                text = this.oldText;
            }
        }
        this.formattedState = true;
        super.setText(text);
        this.formattedState = false;
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(new TextChangedThroughSetText(this));
    }

    public void setValue(double theValue) {
        Double theDouble = null;
        this.oldText = this.getText();
        theDouble = theValue;
        this.setValue(theDouble);
    }

    public NumberOutOfRangeListener.NumberRange inRange() {
        NumberOutOfRangeListener.NumberRange returnValue = NumberOutOfRangeListener.NumberRange.IN_RANGE;
        String text = this.getText();
        returnValue = this.inRange(text);
        return returnValue;
    }

    public void addNumberOutOfRangeListener(NumberOutOfRangeListener l) {
        this.numberOutOfRangeListeners.add(l);
    }

    public void removeNumberOutOfRangeListener(NumberOutOfRangeListener l) {
        this.numberOutOfRangeListeners.remove(l);
    }

    protected NumberOutOfRangeListener.NumberRange inRange(String text) {
        NumberOutOfRangeListener.NumberRange returnValue;
        block8: {
            returnValue = NumberOutOfRangeListener.NumberRange.IN_RANGE;
            try {
                try {
                    if (text.equals("") && this.allowEmptyText) {
                        returnValue = NumberOutOfRangeListener.NumberRange.IN_RANGE;
                    } else {
                        Double value = Double.parseDouble(text);
                        if (value < this.minValue || value > this.maxValue) {
                            returnValue = NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    returnValue = NumberOutOfRangeListener.NumberRange.NOT_A_NUMBER;
                    Color foreGround = returnValue == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE ? Color.red : Color.black;
                    this.setForeground(foreGround);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Color foreGround = returnValue == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE ? Color.red : Color.black;
                this.setForeground(foreGround);
                throw throwable;
            }
            Color foreGround = returnValue == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE ? Color.red : Color.black;
            this.setForeground(foreGround);
        }
        return returnValue;
    }

    protected void notifyNumberOutOfRangeListenersIfTextOutOfRange(ComponentEvent componentEvent) {
        NumberOutOfRangeListener.NumberRange inRange = NumberOutOfRangeListener.NumberRange.NOT_A_NUMBER;
        NumberOutOfRangeListener.NumberOutOfRangeEvent numberOutOfRangeEvent = null;
        String text = this.getText();
        String min = Double.toString(this.minValue);
        String max = Double.toString(this.maxValue);
        inRange = this.inRange();
        if (inRange != this.state || componentEvent instanceof FocusEvent || componentEvent instanceof TextChangedThroughSetText) {
            this.state = inRange;
            numberOutOfRangeEvent = new NumberOutOfRangeListener.NumberOutOfRangeEvent(this.oldText, text, inRange, min, max, componentEvent, this);
            if (this.numberOutOfRangeListeners != null) {
                for (NumberOutOfRangeListener l : this.numberOutOfRangeListeners) {
                    l.handleOutOfRangeNumber(numberOutOfRangeEvent);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        super.keyReleased(evt);
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(evt);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.notifyNumberOutOfRangeListenersIfTextOutOfRange(e);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        Object source = null;
        source = evt.getSource();
        if (source == this) {
            char theChar = '\u0000';
            int charetPosition = -1;
            String text = null;
            int posOfPeriod = -1;
            int posOfNegitive = -1;
            boolean actLikeNothingHappened = false;
            theChar = evt.getKeyChar();
            charetPosition = ((JFormattedTextField)source).getCaretPosition();
            text = this.getText();
            posOfPeriod = text.indexOf(46);
            posOfNegitive = text.indexOf(45);
            switch (theChar) {
                case '-': {
                    if (charetPosition == 0 && this.allowsNegitives) break;
                    actLikeNothingHappened = true;
                    break;
                }
                case '\b': {
                    break;
                }
                case '.': {
                    if (posOfPeriod == -1) break;
                    actLikeNothingHappened = true;
                    break;
                }
                default: {
                    boolean isDigit = false;
                    isDigit = Character.isDigit(theChar);
                    if (isDigit) {
                        int lengthAfterPeriod = text.length() - posOfPeriod - 1;
                        int numDecDigets = this.decimalFormat.getMaximumFractionDigits();
                        if ((posOfPeriod == -1 || charetPosition <= posOfPeriod || lengthAfterPeriod < numDecDigets) && charetPosition > posOfNegitive) break;
                        actLikeNothingHappened = true;
                        break;
                    }
                    actLikeNothingHappened = true;
                }
            }
            if (actLikeNothingHappened) {
                Toolkit.getDefaultToolkit().beep();
                evt.consume();
            } else {
                this.oldText = this.getText();
                super.keyTyped(evt);
            }
        }
    }
}

