/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.textFields;

import ice.swing.textFields.ICEFormattedTextFieldBase;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.Format;
import javax.swing.JFormattedTextField;

public class ChangeBackgroundOnEditFormattedTextField
extends ICEFormattedTextFieldBase
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    protected Color changedColor;
    Color originalBackgroundColor;

    public ChangeBackgroundOnEditFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
    }

    public ChangeBackgroundOnEditFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
    }

    public ChangeBackgroundOnEditFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
    }

    public ChangeBackgroundOnEditFormattedTextField(Format format) {
        super(format);
    }

    public ChangeBackgroundOnEditFormattedTextField(Object value) {
        super(value);
    }

    @Override
    protected void init() {
        super.init();
        this.changedColor = Color.PINK;
        this.originalBackgroundColor = this.getBackground();
        this.addKeyListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setBackgroundToNormalColor();
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        Object theSource = null;
        boolean isEditable = false;
        isEditable = this.isEditable();
        theSource = evt.getSource();
        if (theSource == this && isEditable) {
            this.setBackgroundToChangedColor();
        }
    }

    protected void setBackgroundToChangedColor() {
        this.setBackground(this.changedColor);
    }

    protected void setBackgroundToNormalColor() {
        this.setBackground(this.originalBackgroundColor);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void setChangedColor(Color newChangedColor) {
        this.changedColor = newChangedColor == null ? this.getBackground() : newChangedColor;
    }
}

