/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.buttons;

import ice.swing.buttons.IceButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class IceGradientButton
extends IceButton {
    private static final long serialVersionUID = 6406127000017079392L;
    private static final Color defaultTopColor = Color.WHITE;
    private static final Color defaultBottomColor = Color.BLUE;
    private Color topColor;
    private Color bottomColor;

    public IceGradientButton() {
        this(defaultTopColor, defaultBottomColor);
    }

    public IceGradientButton(Color c1, Color c2) {
        this.topColor = c1;
        this.bottomColor = c2;
        this.setContentAreaFilled(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        Paint oldPaint = g2.getPaint();
        GradientPaint gradient = new GradientPaint(30.0f, 5.0f, this.topColor, 30.0f, h, this.bottomColor, false);
        g2.setPaint(gradient);
        g2.fillRect(0, 0, w, h);
        g2.setPaint(oldPaint);
        super.paintComponent(g);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        AbstractButton b = (AbstractButton)c;
        if (d != null && b.isFocusPainted()) {
            if (d.width % 2 == 0) {
                ++d.width;
            }
            if (d.height % 2 == 0) {
                ++d.height;
            }
        }
        return d;
    }

    @Override
    protected void buildGUI() {
    }

    @Override
    protected void init() {
    }
}

