/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.data.BaseScan;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.ScanList;
import ice.event.IceFileEvent;
import ice.event.IceFileListener;
import ice.event.ScanListEvent;
import ice.event.ScanListListener;
import ice.primitive.IntRef;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;

public class ServerQueueTreeModel
extends DefaultTreeModel
implements IceFileListener,
ScanListListener {
    private static Logger logger = Logger.getLogger("ServerQueueTreeModelLogger");
    private IceFile rootFile;
    private IceFile commonFile = null;
    private ScanList scanList;
    private DefaultMutableTreeNode rootNode;
    private DefaultMutableTreeNode scanNode;
    private DefaultMutableTreeNode sequenceNode;
    private DefaultMutableTreeNode scriptNode;
    private DefaultMutableTreeNode commonNode = null;
    private DefaultMutableTreeNode xmlNode;

    public ServerQueueTreeModel(IceFile rootFile, IceFile commonFile, ScanList scanList) {
        super(new DefaultMutableTreeNode("Files"));
        this.rootFile = rootFile;
        this.commonFile = commonFile;
        try {
            rootFile.addIceFileListener(this);
            this.commonFile.addIceFileListener(this);
            this.scanList = scanList;
            scanList.addScanListListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("ServerQueueTreeMode " + e);
        }
        this.rootNode = (DefaultMutableTreeNode)this.getRoot();
        this.scanNode = new DefaultMutableTreeNode("Scans");
        this.sequenceNode = new DefaultMutableTreeNode("Sequences");
        this.scriptNode = new DefaultMutableTreeNode("Python Scripts");
        this.xmlNode = new DefaultMutableTreeNode("XML Files");
        this.commonNode = new DefaultMutableTreeNode("Common");
        this.rootNode.add(this.scanNode);
        this.rootNode.add(this.sequenceNode);
        this.rootNode.add(this.scriptNode);
        this.rootNode.add(this.xmlNode);
        this.rootNode.add(this.commonNode);
        this.populateScanNode();
        this.populateSequenceNode();
        this.populateScriptNode();
        this.populateXMLNode();
        this.populateCommonNode();
    }

    private void populateScanNode() {
        Iterator<BaseScan> iterator = this.scanList.getScanList().iterator();
        while (iterator.hasNext()) {
            this.scanNode.add(new DefaultMutableTreeNode(iterator.next()));
        }
    }

    private void populateSequenceNode() {
        for (IceFile file : this.rootFile.getChildren()) {
            if (file.getFileType() != IceFileType.sequence) continue;
            this.sequenceNode.add(new DefaultMutableTreeNode(file));
        }
    }

    private void populateScriptNode() {
        for (IceFile file : this.rootFile.getChildren()) {
            if (file.getFileType() != IceFileType.pythonScript) continue;
            this.scriptNode.add(new DefaultMutableTreeNode(file));
        }
    }

    private void populateXMLNode() {
        for (IceFile file : this.rootFile.getChildren()) {
            if (file.getFileType() != IceFileType.xml) continue;
            logger.debug("Adding XML file: " + file.getName());
            this.xmlNode.add(new DefaultMutableTreeNode(file));
        }
    }

    private void populateCommonNode() {
        for (IceFile file : this.commonFile.getChildren()) {
            if (file.getFileType() != IceFileType.sequence) continue;
            this.commonNode.add(new DefaultMutableTreeNode(file));
        }
    }

    protected void childrenAddToCommonDir(IceFileEvent iceFileEvent) {
        int[] indices = iceFileEvent.getIndices();
        ArrayList<Integer> commonInserts = new ArrayList<Integer>();
        int i = 0;
        while (i < indices.length) {
            IceFile file = this.commonFile.getChildAt(indices[i]);
            IceFileType type = file.getFileType();
            if (type == IceFileType.sequence || type == IceFileType.pythonScript || type == IceFileType.xml) {
                logger.debug("Adding " + file.getName() + " to common node.");
                commonInserts.add(this.insertFile(this.commonNode, file));
            } else {
                logger.error("Unknown file type (" + (Object)((Object)type) + ").  Ignoring.");
            }
            ++i;
        }
        Collections.sort(commonInserts);
        int[] actualCommonInserts = new int[commonInserts.size()];
        int size = actualCommonInserts.length;
        int i2 = 0;
        while (i2 < size) {
            actualCommonInserts[i2] = (Integer)commonInserts.get(i2);
            ++i2;
        }
        this.nodesWereInserted(this.commonNode, actualCommonInserts);
    }

    public void childrenAdded(IceFileEvent ife) {
        IceFile theDirectory = null;
        logger.debug("Children added.");
        theDirectory = ife.getParent();
        if (theDirectory == this.commonFile) {
            this.childrenAddToCommonDir(ife);
        }
        if (theDirectory != this.rootFile) {
            return;
        }
        int[] indices = ife.getIndices();
        ArrayList<Integer> sequenceInserts = new ArrayList<Integer>();
        ArrayList<Integer> scriptInserts = new ArrayList<Integer>();
        ArrayList<Integer> xmlInserts = new ArrayList<Integer>();
        int i = 0;
        while (i < indices.length) {
            IceFile file = this.rootFile.getChildAt(indices[i]);
            IceFileType type = file.getFileType();
            if (type == IceFileType.sequence) {
                logger.debug("Adding " + file.getName() + " to sequence node.");
                sequenceInserts.add(this.insertFile(this.sequenceNode, file));
            } else if (type == IceFileType.pythonScript) {
                logger.debug("Adding " + file.getName() + " to script node.");
                scriptInserts.add(this.insertFile(this.scriptNode, file));
            } else if (type == IceFileType.xml) {
                logger.debug("Adding " + file.getName() + " to xml node.");
                xmlInserts.add(this.insertFile(this.xmlNode, file));
            } else {
                logger.error("Unknown file type (" + (Object)((Object)type) + ").  Ignoring.");
            }
            ++i;
        }
        Collections.sort(sequenceInserts);
        Collections.sort(scriptInserts);
        Collections.sort(xmlInserts);
        int additive = sequenceInserts.size();
        int size = sequenceInserts.size() - 1;
        int i2 = 0;
        while (i2 < size) {
            sequenceInserts.add((Integer)sequenceInserts.remove(i2) + --additive, i2);
            ++i2;
        }
        int[] actualSequenceInserts = new int[sequenceInserts.size()];
        size = actualSequenceInserts.length;
        int i3 = 0;
        while (i3 < size) {
            actualSequenceInserts[i3] = (Integer)sequenceInserts.get(i3);
            ++i3;
        }
        this.nodesWereInserted(this.sequenceNode, actualSequenceInserts);
        additive = scriptInserts.size();
        size = scriptInserts.size() - 1;
        i3 = 0;
        while (i3 < size) {
            scriptInserts.add((Integer)scriptInserts.remove(i3) + --additive, i3);
            ++i3;
        }
        int[] actualScriptInserts = new int[scriptInserts.size()];
        size = actualScriptInserts.length;
        int i4 = 0;
        while (i4 < size) {
            actualScriptInserts[i4] = (Integer)scriptInserts.get(i4);
            ++i4;
        }
        this.nodesWereInserted(this.scriptNode, actualScriptInserts);
        additive = xmlInserts.size();
        size = xmlInserts.size() - 1;
        i4 = 0;
        while (i4 < size) {
            xmlInserts.add((Integer)xmlInserts.remove(i4) + --additive, i4);
            ++i4;
        }
        int[] actualXMLInserts = new int[xmlInserts.size()];
        size = actualXMLInserts.length;
        int i5 = 0;
        while (i5 < size) {
            actualXMLInserts[i5] = (Integer)xmlInserts.get(i5);
            ++i5;
        }
        this.nodesWereInserted(this.xmlNode, actualXMLInserts);
    }

    private int insertFile(DefaultMutableTreeNode parentNode, IceFile file) {
        int childCount = parentNode.getChildCount();
        if (childCount == 0) {
            parentNode.add(new DefaultMutableTreeNode(file));
            return 0;
        }
        IceFile currFile = null;
        int i = 0;
        while (i < childCount) {
            currFile = (IceFile)((DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject();
            if (file.getName().compareTo(currFile.getName()) < 0) {
                parentNode.insert(new DefaultMutableTreeNode(file), i);
                return i;
            }
            ++i;
        }
        parentNode.add(new DefaultMutableTreeNode(file));
        return childCount;
    }

    protected void childrenRemovedFromCommonDirectory(IceFileEvent ife) {
        ArrayList<Integer> removeIndices = new ArrayList<Integer>();
        ArrayList<DefaultMutableTreeNode> removeNodes = new ArrayList<DefaultMutableTreeNode>();
        IceFile[] removedChildren = ife.getRemovedChildren();
        DefaultMutableTreeNode node = null;
        IntRef index = new IntRef();
        int i = 0;
        while (i < removedChildren.length) {
            IceFile file = removedChildren[i];
            IceFileType type = file.getFileType();
            if ((type == IceFileType.sequence || type == IceFileType.pythonScript || type == IceFileType.xml) && (node = this.removeFile(this.commonNode, file, index)) != null) {
                removeIndices.add(index.value);
                removeNodes.add(node);
            }
            ++i;
        }
        int[] indexArray = new int[removeIndices.size()];
        Object[] nodeArray = new DefaultMutableTreeNode[removeNodes.size()];
        int i2 = 0;
        while (i2 < removeIndices.size()) {
            indexArray[i2] = (Integer)removeIndices.get(i2);
            nodeArray[i2] = (DefaultMutableTreeNode)removeNodes.get(i2);
            ++i2;
        }
        this.nodesWereRemoved(this.commonNode, indexArray, nodeArray);
    }

    public void childrenRemoved(IceFileEvent ife) {
        IceFile theDirectory = null;
        theDirectory = ife.getParent();
        if (theDirectory == this.commonFile) {
            this.childrenRemovedFromCommonDirectory(ife);
        }
        if (ife.getParent() != this.rootFile) {
            return;
        }
        ArrayList<Integer> scriptRemoveIndices = new ArrayList<Integer>();
        ArrayList<DefaultMutableTreeNode> scriptRemoveNodes = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<Integer> sequenceRemoveIndices = new ArrayList<Integer>();
        ArrayList<DefaultMutableTreeNode> sequenceRemoveNodes = new ArrayList<DefaultMutableTreeNode>();
        IceFile[] removedChildren = ife.getRemovedChildren();
        DefaultMutableTreeNode node = null;
        IntRef index = new IntRef();
        int i = 0;
        while (i < removedChildren.length) {
            IceFile file = removedChildren[i];
            if (file.getFileType() == IceFileType.sequence) {
                node = this.removeFile(this.sequenceNode, file, index);
                if (node != null) {
                    sequenceRemoveIndices.add(index.value);
                    sequenceRemoveNodes.add(node);
                }
            } else if (file.getFileType() == IceFileType.pythonScript && (node = this.removeFile(this.scriptNode, file, index)) != null) {
                scriptRemoveIndices.add(index.value);
                scriptRemoveNodes.add(node);
            }
            ++i;
        }
        int[] indexArray = new int[scriptRemoveIndices.size()];
        Object[] nodeArray = new DefaultMutableTreeNode[scriptRemoveNodes.size()];
        int i2 = 0;
        while (i2 < scriptRemoveIndices.size()) {
            indexArray[i2] = (Integer)scriptRemoveIndices.get(i2);
            nodeArray[i2] = (DefaultMutableTreeNode)scriptRemoveNodes.get(i2);
            ++i2;
        }
        this.nodesWereRemoved(this.scriptNode, indexArray, nodeArray);
        indexArray = new int[sequenceRemoveIndices.size()];
        nodeArray = new DefaultMutableTreeNode[sequenceRemoveNodes.size()];
        i2 = 0;
        while (i2 < sequenceRemoveIndices.size()) {
            indexArray[i2] = (Integer)sequenceRemoveIndices.get(i2);
            nodeArray[i2] = (DefaultMutableTreeNode)sequenceRemoveNodes.get(i2);
            ++i2;
        }
        this.nodesWereRemoved(this.sequenceNode, indexArray, nodeArray);
    }

    private DefaultMutableTreeNode removeFile(DefaultMutableTreeNode parentNode, IceFile file, IntRef index) {
        IceFile currFile = null;
        int childCount = parentNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            currFile = (IceFile)node.getUserObject();
            if (file.getName().equals(currFile.getName())) {
                parentNode.remove(node);
                index.value = i;
                return node;
            }
            ++i;
        }
        return null;
    }

    public void scansAdded(ScanListEvent sle) {
        if (sle.getSource() != this.scanList) {
            return;
        }
        int[] indices = sle.getIndices();
        ArrayList<BaseScan> scans = this.scanList.getScanList();
        int i = 0;
        while (i < indices.length) {
            this.scanNode.insert(new DefaultMutableTreeNode(scans.get(indices[i])), indices[i]);
            ++i;
        }
        this.nodesWereInserted(this.scanNode, indices);
    }

    public void scansRemoved(ScanListEvent sle) {
        if (sle.getSource() != this.scanList) {
            return;
        }
        logger.debug("Scans removed.");
        String tempString = "";
        int i = 0;
        while (i < sle.getIndices().length) {
            tempString = String.valueOf(tempString) + sle.getIndices()[i] + ", ";
            ++i;
        }
        logger.debug("Indices: " + tempString);
        int[] indices = sle.getIndices();
        int i2 = indices.length - 1;
        while (i2 >= 0) {
            this.scanNode.remove(indices[i2]);
            --i2;
        }
        this.nodesWereRemoved(this.scanNode, indices, sle.getRemovedChildren());
    }

    public void scansUpdated(ScanListEvent sle) {
    }

    @Override
    public void actionPerformed(IceFileEvent ife) {
        IceFileEvent.Type theType = ife.getType();
        switch (theType) {
            case ADDED: {
                this.childrenAdded(ife);
                break;
            }
            case REMOVED: {
                this.childrenRemoved(ife);
                break;
            }
            default: {
                logger.error("ServerQueueTreeModel.actionPerformed(ICEFileEvent) illegal event sent should be of type ADDED or REMOVED");
            }
        }
    }

    @Override
    public void actionPerformed(ScanListEvent event) {
        ScanListEvent.Type theType = event.getType();
        switch (theType) {
            case ADD: {
                this.scansAdded(event);
                break;
            }
            case REMOVE: {
                this.scansRemoved(event);
                break;
            }
            case UPDATE: {
                this.scansUpdated(event);
            }
        }
    }
}

