/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.data.BaseScan;
import ice.data.ScanList;
import ice.event.ScanListEvent;
import ice.event.ScanListListener;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class ScanTableModel
extends AbstractTableModel
implements ScanListListener {
    private static Logger logger = Logger.getLogger("BaseScanTableModelLogger");
    public static String nameColumn = "Name";
    public static String numPointsColumn = "Num Points";
    public static String countTypeColumn = "Count Against";
    public static String durationColumn = "Duration";
    public static String commentColumn = "Comment";
    public static String delayb4ScanColumn = "Delay Before Scan";
    public static String delaybtwnPtsColumn = "Delay Before Scan";
    public static String timeoutColumn = "Timeout";
    private ArrayList<BaseScan> scans = new ArrayList();
    private ArrayList<String> displayedColumns = new ArrayList();

    public ScanTableModel(ScanList scanList) {
        this.displayedColumns.add(nameColumn);
        this.displayedColumns.add(numPointsColumn);
        this.displayedColumns.add(countTypeColumn);
        this.displayedColumns.add(durationColumn);
        Iterator<BaseScan> iterator = scanList.getScanList().iterator();
        while (iterator.hasNext()) {
            this.scans.add(iterator.next());
        }
        try {
            scanList.addScanListListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("ScanTableModel can not add listener " + e);
        }
    }

    @Override
    public int getColumnCount() {
        return this.displayedColumns.size();
    }

    @Override
    public int getRowCount() {
        return this.scans.size();
    }

    @Override
    public String getColumnName(int c) {
        return this.displayedColumns.get(c);
    }

    public Class getColumnClass(int c) {
        if (this.displayedColumns.get(c) == nameColumn) {
            return BaseScan.class;
        }
        return this.displayedColumns.get(c).getClass();
    }

    @Override
    public int findColumn(String columnName) {
        return this.scans.indexOf(columnName);
    }

    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        BaseScan scan = this.scans.get(rowIndex);
        if (scan != null) {
            if (this.displayedColumns.get(colIndex).equals(nameColumn)) {
                return scan;
            }
            if (this.displayedColumns.get(colIndex).equals(numPointsColumn)) {
                return scan.getNumPoints();
            }
            if (this.displayedColumns.get(colIndex).equals(countTypeColumn)) {
                return scan.getCountType();
            }
            if (this.displayedColumns.get(colIndex).equals(durationColumn)) {
                return scan.getBaseCount() * scan.getPrefactor();
            }
            if (this.displayedColumns.get(colIndex).equals(commentColumn)) {
                return scan.getComments();
            }
            if (this.displayedColumns.get(colIndex).equals(delayb4ScanColumn)) {
                return "N/A";
            }
            if (this.displayedColumns.get(colIndex).equals(delaybtwnPtsColumn)) {
                return "N/A";
            }
            if (this.displayedColumns.get(colIndex).equals(timeoutColumn)) {
                return "N/A";
            }
        }
        return null;
    }

    public void scansAdded(ScanListEvent sle) {
        String message = "scans added,";
        ArrayList<BaseScan> scanList = sle.getScanList();
        int[] indices = sle.getIndices();
        int i = 0;
        while (i < indices.length) {
            message = String.valueOf(message) + ", " + scanList.get(indices[i]);
            this.scans.add(indices[i], scanList.get(indices[i]));
            ++i;
        }
        logger.debug(message);
        int[] sortedIndices = new int[indices.length];
        Arrays.sort(sortedIndices);
        if (sortedIndices.length > 1) {
            int firstNum = sortedIndices[0];
            int secondNum = -1;
            int i2 = 1;
            while (i2 < sortedIndices.length) {
                if (sortedIndices[i2] == firstNum + 1) {
                    secondNum = sortedIndices[i2];
                } else {
                    if (secondNum != -1) {
                        this.fireTableRowsInserted(firstNum, secondNum);
                    } else {
                        this.fireTableRowsInserted(firstNum, firstNum);
                    }
                    firstNum = sortedIndices[i2];
                    secondNum = -1;
                }
                ++i2;
            }
            if (secondNum != -1) {
                this.fireTableRowsInserted(firstNum, secondNum);
            } else {
                this.fireTableRowsInserted(firstNum, firstNum);
            }
        } else if (sortedIndices.length > 0) {
            this.fireTableRowsInserted(sortedIndices[0], sortedIndices[0]);
        }
    }

    public void scansRemoved(ScanListEvent sle) {
        int[] indices = sle.getIndices();
        BaseScan[] removedScans = sle.getRemovedChildren();
        String message = "scans removed:";
        int i = 0;
        while (i < removedScans.length) {
            message = String.valueOf(message) + ", " + removedScans[i];
            if (!this.scans.remove(removedScans[i])) {
                logger.debug("removing " + removedScans[i] + " failed");
                String allScans = "";
                Iterator<BaseScan> iterator = this.scans.iterator();
                while (iterator.hasNext()) {
                    allScans = String.valueOf(allScans) + ", " + iterator.next();
                }
            }
            ++i;
        }
        logger.debug(message);
        int[] sortedIndices = new int[indices.length];
        int indicesLength = indices.length;
        int i2 = 0;
        while (i2 < indicesLength) {
            sortedIndices[i2] = indices[i2];
            ++i2;
        }
        Arrays.sort(sortedIndices);
        if (sortedIndices.length > 1) {
            int firstNum = sortedIndices[0];
            int secondNum = sortedIndices[0];
            int i3 = 1;
            while (i3 < sortedIndices.length) {
                if (sortedIndices[i3] == secondNum + 1) {
                    secondNum = sortedIndices[i3];
                } else {
                    logger.debug("notifying of removed row(s): " + firstNum + "-" + secondNum);
                    this.fireTableRowsDeleted(firstNum, secondNum);
                    firstNum = sortedIndices[i3];
                    secondNum = -1;
                }
                ++i3;
            }
            logger.debug("notifying of removed row(s): " + firstNum + "-" + secondNum);
            this.fireTableRowsDeleted(firstNum, secondNum);
        } else if (sortedIndices.length > 0) {
            logger.debug("notifying of removed one row: " + sortedIndices[0]);
            this.fireTableRowsDeleted(sortedIndices[0], sortedIndices[0]);
        }
    }

    public void scansUpdated(ScanListEvent sle) {
    }

    @Override
    public void actionPerformed(ScanListEvent event) {
        ScanListEvent.Type theType = event.getType();
        switch (theType) {
            case ADD: {
                this.scansAdded(event);
                break;
            }
            case REMOVE: {
                this.scansRemoved(event);
                break;
            }
            case UPDATE: {
                this.scansUpdated(event);
            }
        }
    }
}

