/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.IconManager;
import ice.data.BaseScan;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.swing.TableClipboardOwner;
import ice.util.ImageUtil;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ResourceMgrTableCellRenderer
extends DefaultTableCellRenderer {
    public ResourceMgrTableCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        ImageIcon icon = IconManager.getIcon("file.unknown");
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        if (value instanceof IceFile) {
            IceFile file = (IceFile)value;
            icon = file.getFileType() == IceFileType.pythonScript ? IconManager.getIcon("file.pythonScript") : (file.getFileType() == IceFileType.directory ? IconManager.getIcon("file.directory") : IconManager.getIcon("file.unknown"));
        } else if (value instanceof BaseScan) {
            BaseScan scan = (BaseScan)value;
            icon = scan.getScanType() == BaseScan.ScanType.angleScan ? IconManager.getIcon("scan.angle") : (scan.getScanType() == BaseScan.ScanType.environmentScan ? IconManager.getIcon("scan.environment") : (scan.getScanType() == BaseScan.ScanType.motorScan ? IconManager.getIcon("scan.motor") : (scan.getScanType() == BaseScan.ScanType.vectorScan ? IconManager.getIcon("scan.vector") : IconManager.getIcon("scan.generic"))));
        }
        TableClipboardOwner owner = (TableClipboardOwner)table.getClientProperty("ClipBoardOwner");
        if (owner != null) {
            Object[] objects = owner.getObjects();
            int i = 0;
            while (i < objects.length) {
                if (objects[i] == value) {
                    icon = new ImageIcon(ImageUtil.createGhostImage(icon.getImage()));
                    break;
                }
                ++i;
            }
        }
        this.setIcon(icon);
        return this;
    }
}

