/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;

public abstract class CursorInsertJList
extends JList
implements DropTargetListener {
    DropTarget dropTarget;
    int newInsertionDrawHeight;
    int lastInsertionDrawHeight;
    int insertionIndex;

    public CursorInsertJList() {
        this.init();
    }

    public CursorInsertJList(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    CursorInsertJList(Object[] listData) {
        super(listData);
        this.init();
    }

    CursorInsertJList(Vector<?> listData) {
        super(listData);
        this.init();
    }

    private void init() {
        this.dropTarget = new DropTarget(this, this);
    }

    protected abstract boolean checkDrag(DropTargetDragEvent var1, int var2);

    protected abstract boolean dropAction(DropTargetDropEvent var1, int var2);

    public void setInsertionIndexAndDisplayPosition(int dragHeight) {
        Rectangle cellBounds;
        int numElements = this.getModel().getSize();
        if (numElements == 0) {
            this.newInsertionDrawHeight = -1;
            this.insertionIndex = 0;
            return;
        }
        int index = 0;
        int drawHeight = 0;
        while (index < numElements) {
            cellBounds = this.getCellBounds(index, index);
            if (dragHeight >= cellBounds.y && dragHeight <= cellBounds.y + cellBounds.height) {
                int cellMiddle = cellBounds.y + cellBounds.height / 2;
                if (dragHeight > cellMiddle) {
                    drawHeight = cellBounds.y + cellBounds.height;
                    ++index;
                } else {
                    drawHeight = cellBounds.y;
                }
                this.newInsertionDrawHeight = drawHeight;
                this.insertionIndex = index;
                return;
            }
            ++index;
        }
        cellBounds = this.getCellBounds(numElements - 1, numElements - 1);
        this.newInsertionDrawHeight = drawHeight = cellBounds.y + cellBounds.height;
        this.insertionIndex = index;
    }

    public void drawXorCursor() {
        if (this.newInsertionDrawHeight >= 0) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(this.getBackground());
            graphics.drawLine(0, this.newInsertionDrawHeight, this.getWidth(), this.newInsertionDrawHeight);
            graphics.setPaintMode();
        }
        this.lastInsertionDrawHeight = this.newInsertionDrawHeight;
    }

    public void eraseXorCursor() {
        if (this.lastInsertionDrawHeight >= 0) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(this.getBackground());
            graphics.drawLine(0, this.lastInsertionDrawHeight, this.getWidth(), this.lastInsertionDrawHeight);
            graphics.setPaintMode();
            this.lastInsertionDrawHeight = -1;
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.newInsertionDrawHeight = -1;
        this.lastInsertionDrawHeight = -1;
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.setInsertionIndexAndDisplayPosition(dtde.getLocation().y);
        if (this.checkDrag(dtde, this.insertionIndex)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
            this.insertionIndex = -1;
            this.newInsertionDrawHeight = -1;
        }
        if (this.newInsertionDrawHeight != this.lastInsertionDrawHeight) {
            this.eraseXorCursor();
            this.drawXorCursor();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.setInsertionIndexAndDisplayPosition(dtde.getLocation().y);
        if (this.dropAction(dtde, this.insertionIndex)) {
            dtde.acceptDrop(dtde.getDropAction());
        } else {
            dtde.rejectDrop();
        }
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void paint(Graphics g) {
        this.eraseXorCursor();
        super.paint(g);
    }
}

