/*
 * Decompiled with CFR 0.152.
 */
package ice.profiling;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class ProfileReader
extends PushbackReader {
    private char[] openTag = new char[]{'<', 'p', 'r', 'o', 'f', 'i', 'l', 'e', '>'};
    private char[] closeTag = new char[]{'<', '/', 'p', 'r', 'o', 'f', 'i', 'l', 'e', '>'};
    private static final int bufflen = 11;
    private boolean endTagInserted = false;

    public ProfileReader(Reader in) {
        super(in, 11);
        try {
            this.unread(this.openTag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ProfileReader(Reader in, int size) {
        super(in, size + 11);
        try {
            this.unread(this.openTag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int read() throws IOException {
        int readval = super.read();
        if (readval == -1 && !this.endTagInserted) {
            this.unread(this.closeTag);
            this.endTagInserted = true;
            readval = super.read();
        }
        return readval;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int readval = super.read(cbuf, off, len);
        if (readval < len && !this.endTagInserted) {
            this.unread(this.closeTag);
            this.endTagInserted = true;
            readval = readval == -1 ? super.read(cbuf, off, len) : (readval += super.read(cbuf, off + readval, len - readval));
        }
        return readval;
    }

    public final String getOpenTag() {
        return new String(this.openTag);
    }

    public final String getCloseTag() {
        return new String(this.closeTag);
    }
}

