/*
 * Decompiled with CFR 0.152.
 */
package ice.profiling;

import ice.profiling.IceProfilingEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EventList {
    List<IceProfilingEvent> evList = new ArrayList<IceProfilingEvent>(27000);
    private boolean mapCategory = true;
    private Map<String, List<IceProfilingEvent>> eventCategoryMap = null;
    private Map<String, Integer> categoryMap = null;
    private int nextCategory = 0;
    private boolean mapDevice = true;
    private Map<String, List<IceProfilingEvent>> eventDeviceMap = null;
    private Map<String, Integer> deviceMap = null;
    private int nextDevice = 0;
    private boolean mapCommand = true;
    private Map<String, List<IceProfilingEvent>> eventCommandMap = null;
    private Map<String, Integer> commandMap = null;
    private int nextCommand = 0;
    private boolean mapDevCommand = true;
    private Map<String, List<IceProfilingEvent>> eventDevCommandMap = null;
    private Map<String, Integer> devCommandMap = null;
    private int nextDevCommand = 0;
    double t0 = Double.MAX_VALUE;
    double tMax = 0.0;
    public static final Color[] colors = new Color[]{Color.RED, Color.BLUE, Color.GREEN, Color.ORANGE, Color.PINK, Color.YELLOW, Color.MAGENTA, Color.CYAN};
    private LinkedList<IceProfilingEvent> legacyEvList = new LinkedList();

    public EventList(boolean mapCategory, boolean mapCommand, boolean mapDevice, boolean mapDevCommand) {
        this.mapCategory = mapCategory;
        if (mapCategory) {
            this.eventCategoryMap = new Hashtable<String, List<IceProfilingEvent>>();
            this.categoryMap = new Hashtable<String, Integer>();
        }
        this.mapCommand = mapCommand;
        if (mapCommand) {
            this.eventCommandMap = new Hashtable<String, List<IceProfilingEvent>>();
            this.commandMap = new Hashtable<String, Integer>();
        }
        this.mapDevice = mapDevice;
        if (mapDevice) {
            this.eventDeviceMap = new Hashtable<String, List<IceProfilingEvent>>();
            this.deviceMap = new Hashtable<String, Integer>();
        }
        this.mapDevCommand = mapCommand;
        if (mapDevCommand) {
            this.eventDevCommandMap = new Hashtable<String, List<IceProfilingEvent>>();
            this.devCommandMap = new Hashtable<String, Integer>();
        }
    }

    public EventList() {
        this(true, true, true, true);
    }

    public void addEvent(IceProfilingEvent event) {
        LinkedList<IceProfilingEvent> newList;
        this.evList.add(event);
        if (event.getStartTimeDouble() < this.t0) {
            this.t0 = event.getStartTimeDouble();
        }
        if (event.getStopTimeDouble() > this.tMax) {
            this.tMax = event.getStopTimeDouble();
        }
        if (this.mapCategory) {
            if (this.eventCategoryMap.containsKey(event.getCategory())) {
                this.eventCategoryMap.get(event.getCategory()).add(event);
            } else {
                newList = new LinkedList<IceProfilingEvent>();
                newList.add(event);
                this.eventCategoryMap.put(event.getCategory(), newList);
                this.categoryMap.put(event.getCategory(), this.nextCategory++);
            }
        }
        if (this.mapDevice) {
            if (this.deviceMap.containsKey(event.getDevice())) {
                this.eventDeviceMap.get(event.getDevice()).add(event);
            } else {
                newList = new LinkedList();
                newList.add(event);
                this.eventDeviceMap.put(event.getDevice(), newList);
                this.deviceMap.put(event.getDevice(), this.nextDevice++);
            }
        }
        if (this.mapCommand) {
            if (this.commandMap.containsKey(event.getCommand())) {
                this.eventCommandMap.get(event.getCommand()).add(event);
            } else {
                newList = new LinkedList();
                newList.add(event);
                this.eventCommandMap.put(event.getCommand(), newList);
                this.commandMap.put(event.getCommand(), this.nextCommand++);
            }
        }
        if (this.mapDevCommand) {
            String devCmdString = String.valueOf(event.getCommand()) + ", " + event.getDevice();
            if (this.devCommandMap.containsKey(devCmdString)) {
                this.eventDevCommandMap.get(devCmdString).add(event);
            } else {
                LinkedList<IceProfilingEvent> newList2 = new LinkedList<IceProfilingEvent>();
                newList2.add(event);
                this.eventDevCommandMap.put(devCmdString, newList2);
                this.devCommandMap.put(devCmdString, this.nextDevCommand++);
            }
        }
    }

    public double getT0() {
        return this.t0;
    }

    public double getTmax() {
        return this.tMax;
    }

    public String toString() {
        String retString = "Event List containing " + String.valueOf(this.evList.size()) + " events.";
        if (this.legacyEvList.size() > 0) {
            retString = String.valueOf(retString) + "  There are " + String.valueOf(this.legacyEvList.size()) + " partial legacy events not included in the list.";
        }
        return retString;
    }

    public Map<String, Integer> getCategoryMap() {
        return this.categoryMap;
    }

    public void plotByCategory(Graphics g, double min, double max, int plotWidth) {
        int yscale = 25;
        int yoffset = 90;
        int ywidth = 10;
        int labeloffset = 20;
        int plotxoffset = 80;
        g.setColor(Color.RED);
        double xoffset = this.getT0() + min;
        double xscale = (double)(plotWidth - plotxoffset) / (max - min);
        for (IceProfilingEvent ev : this.evList) {
            g.setColor(colors[this.deviceMap.get(ev.getDevice()) % colors.length]);
            int x1 = (int)(xscale * (ev.getStartTimeDouble() - xoffset)) + plotxoffset;
            int y1 = yscale * this.categoryMap.get(ev.getCategory()) + yoffset;
            int x2 = (int)(xscale * (ev.getStopTimeDouble() - xoffset)) + plotxoffset;
            if (x1 < 0) {
                x1 = 0;
            }
            if (x2 > plotWidth) {
                x2 = plotWidth;
            }
            int y2 = y1 + ywidth;
            g.fillRect(x1, y1, x2 - x1, ywidth);
        }
        g.setColor(Color.BLACK);
        for (String category : this.categoryMap.keySet()) {
            g.drawString(category, labeloffset, yoffset + yscale * this.categoryMap.get(category) + ywidth);
        }
    }

    public String generateTimeStat() {
        String statReturn = "Description, deviceName, Average, Total\n";
        for (String cmd : this.eventDevCommandMap.keySet()) {
            statReturn = String.valueOf(statReturn) + cmd.trim();
            List<IceProfilingEvent> cmdEvList = this.eventDevCommandMap.get(cmd);
            double avg = 0.0;
            double total = 0.0;
            for (IceProfilingEvent ev : cmdEvList) {
                total += ev.getDuration();
            }
            avg = total / (double)cmdEvList.size();
            statReturn = String.valueOf(statReturn) + ", " + String.format("%9.9f", avg) + ", " + String.format("%9.9f", total) + "\n";
        }
        return statReturn;
    }

    public IceProfilingEvent legacyStartEvent(String category, String command, String device, String description, double startTime) {
        IceProfilingEvent ev = new IceProfilingEvent(startTime, Double.NaN, category, device, command, description);
        this.legacyEvList.addFirst(ev);
        return ev;
    }

    public IceProfilingEvent legacyStopEvent(String category, String command, String device, String description, double stopTime) {
        for (IceProfilingEvent ev : this.legacyEvList) {
            if (!ev.getCategory().equals(category) || !ev.getDevice().equals(device) || !ev.getCommand().equals(command)) continue;
            ev.setStopTimeDouble(stopTime);
            if (!ev.getDescription().trim().equals(description.trim())) {
                ev.setDescription(String.valueOf(ev.getDescription()) + " : " + description);
            }
            this.addEvent(ev);
            this.legacyEvList.remove(ev);
            return ev;
        }
        return null;
    }

    public static enum SortFields {
        CATEGORY,
        COMMAND,
        DEVICE;

    }
}

