/*
 * Decompiled with CFR 0.152.
 */
package ice.jython.management;

import ice.event.communication.PythonResetEvent;
import ice.event.communication.PythonResetListener;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceViewPanel;
import ice.jython.management.PythonContainer;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyType;

public class PythonPanelManager
implements PythonResetListener {
    private static PythonPanelManager reference = null;
    private HashMap<String, Class<?>> pythonPanelList = null;
    protected ICEListenerList<PythonResetListener, PythonResetEvent> pythonResetListeners;

    protected PythonPanelManager() {
        this.init();
    }

    protected void init() {
        PythonContainer pythonContainer = PythonContainer.getReference();
        try {
            pythonContainer.addPythonResetListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("Could not add listener" + e);
        }
        this.pythonResetListeners = new ICEListenerList();
        this.buildPythonPanelList();
    }

    public void addPythonResetListener(PythonResetListener l) throws ICEListenerListExceptionBase {
        this.pythonResetListeners.addListener(l);
    }

    public void removePythonResetListener(PythonResetListener l) {
        this.pythonResetListeners.removeListener(l);
    }

    private void buildPythonPanelList() {
        this.pythonPanelList = new HashMap();
        this.findPythonWindows();
    }

    @Override
    public void actionPerformed(PythonResetEvent ace) {
        this.buildPythonPanelList();
        this.pythonResetListeners.notifyListeners(ace);
    }

    public static PythonPanelManager getReference() {
        if (reference == null) {
            reference = new PythonPanelManager();
        }
        return reference;
    }

    public Set<String> getListOfPanels() {
        Set<String> windowList = null;
        windowList = this.pythonPanelList.keySet();
        return windowList;
    }

    public HashMap<String, Class<?>> getLoadedPythonPanelClasses() {
        return this.pythonPanelList;
    }

    public GenericIcePanel openPanel(String panelName) {
        boolean windowClassExists;
        GenericIcePanel theWindow = null;
        PythonContainer pythonContainer = null;
        pythonContainer = PythonContainer.getReference();
        if (pythonContainer != null && panelName != null && (windowClassExists = this.pythonPanelList.containsKey(panelName))) {
            PyObject pyObject = null;
            String lineOfCode = "";
            lineOfCode = String.valueOf(panelName) + "()";
            pyObject = pythonContainer.eval(lineOfCode);
            if (pyObject != null) {
                theWindow = (GenericIcePanel)pyObject.__tojava__(GenericIcePanel.class);
            }
        }
        return theWindow;
    }

    public String getParsedClassName(String className) {
        String tempName = className;
        Pattern pattern = Pattern.compile("([A-Z]+)");
        Matcher matcher = pattern.matcher(tempName);
        String newName = tempName;
        while (matcher.find()) {
            String upperCaseLetters = matcher.group(1);
            newName = newName.replace(upperCaseLetters, " " + upperCaseLetters);
        }
        newName = newName.trim();
        return newName;
    }

    protected void findPythonWindows() {
        try {
            PythonContainer pythonContainer = null;
            PyStringMap listOfLocals = null;
            pythonContainer = PythonContainer.getReference();
            listOfLocals = pythonContainer.getLocals();
            PyList lkeys = listOfLocals.keys();
            int i = 0;
            while (i < lkeys.size()) {
                String key = (String)lkeys.get(i);
                try {
                    PyString pyString = new PyString(key);
                    PyObject pyObject = listOfLocals.get(pyString);
                    try {
                        PyType pyType = (PyType)pyObject.__tojava__(PyType.class);
                        PyObject bases = pyType.getBase();
                        PyJavaType base = (PyJavaType)((PyType)bases).getBase();
                        Class<?> proxyType = base.getProxyType();
                        if (proxyType == IceViewPanel.class) {
                            this.pythonPanelList.put(pyString.toString(), PyObject.class);
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                ++i;
            }
        }
        catch (Exception ww) {
            System.out.println(ww);
        }
    }
}

