/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.sampleAlignment.ubMatrix;

import ice.communication.SendQueueManager;
import ice.event.communication.PeakListData;
import ice.event.communication.PeakSetData;
import ice.event.communication.UBMatrixAskCommandListener;
import ice.event.communication.UBMatrixChangeEvent;
import ice.event.communication.UBMatrixChangeListener;
import ice.event.communication.util.UBMatrixAskCommandEnums;
import ice.event.communication.util.UBMatrixChangeEventParser;
import ice.event.communication.util.UBMatrixParsedAskResponse;
import ice.event.communication.util.exception.UBMatrixParseChangeEventException;
import ice.util.I18N;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class UBReflectionSetPanel
extends JPanel
implements UBMatrixChangeListener,
UBMatrixAskCommandListener {
    private static final long serialVersionUID = 1L;
    protected static final String TITLE_KEY = "ice.gui.tas.bt7.UBReflectionSetPanel.title";
    private SendQueueManager sendManager = null;
    protected ArrayList<ArrayList> rows = null;

    public UBReflectionSetPanel(SendQueueManager sendManager) {
        this.init(sendManager);
    }

    protected void init(SendQueueManager sendManager) {
        this.rows = new ArrayList();
        this.buildGUI();
        this.sendManager = sendManager;
    }

    protected GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gridBagConstraints = null;
        Insets insets = null;
        insets = new Insets(5, 15, 5, 15);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        return gridBagConstraints;
    }

    protected void buildGUI() {
        GridBagLayout gridBagLayout = null;
        String title = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        title = I18N.getString(TITLE_KEY);
        this.setBorder(new TitledBorder(title));
        this.initDisplay();
    }

    protected void buildHeader() {
        String hLableString = null;
        String kLableString = null;
        String lLableString = null;
        String a3LableString = null;
        String a4LableString = null;
        String ltiltLableString = null;
        String utiltLableString = null;
        hLableString = Items.h.getLabel();
        kLableString = Items.k.getLabel();
        lLableString = Items.l.getLabel();
        a3LableString = Items.a3.getLabel();
        a4LableString = Items.a4.getLabel();
        ltiltLableString = Items.ltilt.getLabel();
        utiltLableString = Items.utitl.getLabel();
        this.addRow(0, hLableString, kLableString, lLableString, a3LableString, a4LableString, ltiltLableString, utiltLableString, false);
    }

    protected void initDisplay() {
        this.buildHeader();
        this.addRow(1, null, null, null, null, null, null, null, false);
        this.addRow(2, null, null, null, null, null, null, null, false);
    }

    protected void fillRowWithData(int row, String h, String k, String l, String a3, String a4, String lTilt, String uTilt, boolean isPrimary) {
        JLabel tempLabel = null;
        String tempString = null;
        ArrayList rowOfLabels = null;
        Font font = null;
        int newFontStyle = 0;
        if (isPrimary) {
            newFontStyle = 1;
        }
        if ((rowOfLabels = this.rows.get(row)) != null) {
            tempString = this.formatValue(h);
            tempLabel = (JLabel)rowOfLabels.get(Items.h.ordinal());
            tempLabel.setText("");
            tempLabel.repaint();
            font = tempLabel.getFont();
            font = font.deriveFont(newFontStyle);
            tempLabel.setFont(font);
            tempLabel.setText(tempString);
            tempString = this.formatValue(k);
            tempLabel = (JLabel)rowOfLabels.get(Items.k.ordinal());
            tempLabel.setFont(font);
            tempLabel.setText(tempString);
            tempString = this.formatValue(l);
            tempLabel = (JLabel)rowOfLabels.get(Items.l.ordinal());
            tempLabel.setFont(font);
            tempLabel.setText(tempString);
            tempString = this.formatValue(a3);
            tempLabel = (JLabel)rowOfLabels.get(Items.a3.ordinal());
            tempLabel.setFont(font);
            tempLabel.setText(tempString);
            tempString = this.formatValue(a4);
            tempLabel = (JLabel)rowOfLabels.get(Items.a4.ordinal());
            tempLabel.setFont(font);
            tempLabel.setText(tempString);
            tempString = this.formatValue(lTilt);
            tempLabel = (JLabel)rowOfLabels.get(Items.ltilt.ordinal());
            tempLabel.setFont(font);
            tempLabel.setText(tempString);
            tempString = this.formatValue(uTilt);
            tempLabel = (JLabel)rowOfLabels.get(Items.utitl.ordinal());
            tempLabel.setFont(font);
            tempLabel.setText(tempString);
        }
    }

    protected void addRow(int row, String h, String k, String l, String a3, String a4, String lTilt, String uTilt, boolean isPrimary) {
        GridBagConstraints gridBagConstraints = null;
        ArrayList<JLabel> rowOfLabels = null;
        JLabel tempLabel = null;
        Object tempString = null;
        rowOfLabels = new ArrayList<JLabel>();
        int i = 0;
        while (i < 7) {
            tempLabel = new JLabel("");
            rowOfLabels.add(tempLabel);
            ++i;
        }
        this.rows.add(rowOfLabels);
        gridBagConstraints = this.getGridBagConstraints();
        gridBagConstraints.gridy = row;
        gridBagConstraints.gridx = Items.h.ordinal();
        tempLabel = (JLabel)rowOfLabels.get(Items.h.ordinal());
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints.gridx = Items.k.ordinal();
        tempLabel = (JLabel)rowOfLabels.get(Items.k.ordinal());
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints.gridx = Items.l.ordinal();
        tempLabel = (JLabel)rowOfLabels.get(Items.l.ordinal());
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints.gridx = Items.a3.ordinal();
        tempLabel = (JLabel)rowOfLabels.get(Items.a3.ordinal());
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints.gridx = Items.a4.ordinal();
        tempLabel = (JLabel)rowOfLabels.get(Items.a4.ordinal());
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints.gridx = Items.ltilt.ordinal();
        tempLabel = (JLabel)rowOfLabels.get(Items.ltilt.ordinal());
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints.gridx = Items.utitl.ordinal();
        tempLabel = (JLabel)rowOfLabels.get(Items.utitl.ordinal());
        this.add((Component)tempLabel, gridBagConstraints);
        this.fillRowWithData(row, h, k, l, a3, a4, lTilt, uTilt, isPrimary);
    }

    protected String formatValue(String value) {
        String returnValue = null;
        returnValue = value == null ? "N/C" : value;
        return returnValue;
    }

    protected void adjustDisplay(PeakListData peakListData) {
        block5: {
            int i;
            int difference;
            block6: {
                int rowCount = 0;
                difference = 0;
                int numberOfPeaksets = 0;
                ArrayList<PeakSetData> peakSets = null;
                if (peakListData == null || (peakSets = peakListData.getPeakSetDataList()) == null) break block5;
                rowCount = this.rows.size();
                difference = rowCount - 1 - (numberOfPeaksets = peakSets.size());
                if (difference >= 0) break block6;
                difference *= -1;
                int i2 = rowCount;
                while (i2 < rowCount + difference) {
                    this.addRow(i2, null, null, null, null, null, null, null, false);
                    ++i2;
                }
                break block5;
            }
            if (difference <= 0) break block5;
            int rowSize = this.rows.size();
            int last = rowSize - 1;
            int numberOfRowsAfterRemove = rowSize - difference;
            if (numberOfRowsAfterRemove >= 2) {
                i = 0;
                while (i < difference) {
                    int listSize = this.rows.get(last).size();
                    i = 0;
                    while (i < listSize) {
                        JLabel aLabel = (JLabel)this.rows.get(last).get(i);
                        this.remove(aLabel);
                        ++i;
                    }
                    this.rows.remove(last);
                    ++i;
                    --last;
                }
            }
            i = 1;
            while (i <= rowSize) {
                this.fillRowWithData(i, null, null, null, null, null, null, null, false);
                ++i;
            }
        }
    }

    protected void updateDisplayFromPeakListData(PeakListData peakListData) {
        ArrayList<PeakSetData> peakSets = null;
        String h = null;
        String k = null;
        String l = null;
        String a3 = null;
        String a4 = null;
        String ltilt = null;
        String utilt = null;
        int primaryPeakSetId = -1;
        if (peakListData != null) {
            primaryPeakSetId = peakListData.getPrimaryPeakSetID();
            peakSets = peakListData.getPeakSetDataList();
            if (peakSets != null) {
                int row = 1;
                Boolean included = false;
                Double tempDouble = null;
                int currentPeakSet = -1;
                boolean isPrimaryPeakSet = false;
                for (PeakSetData peakSetDataItem : peakSets) {
                    included = true;
                    if (!included.booleanValue()) continue;
                    tempDouble = peakSetDataItem.getH();
                    if (tempDouble != null) {
                        h = tempDouble.toString();
                    }
                    if ((tempDouble = peakSetDataItem.getK()) != null) {
                        k = tempDouble.toString();
                    }
                    if ((tempDouble = peakSetDataItem.getL()) != null) {
                        l = tempDouble.toString();
                    }
                    if ((tempDouble = peakSetDataItem.getA3()) != null) {
                        a3 = tempDouble.toString();
                    }
                    if ((tempDouble = peakSetDataItem.getA4()) != null) {
                        a4 = tempDouble.toString();
                    }
                    if ((tempDouble = peakSetDataItem.getLTilt()) != null) {
                        ltilt = tempDouble.toString();
                    }
                    if ((tempDouble = peakSetDataItem.getUTilt()) != null) {
                        utilt = tempDouble.toString();
                    }
                    isPrimaryPeakSet = (currentPeakSet = peakSetDataItem.getID().intValue()) == primaryPeakSetId;
                    this.fillRowWithData(row, h, k, l, a3, a4, ltilt, utilt, isPrimaryPeakSet);
                    ++row;
                }
            }
        }
    }

    @Override
    public void actionPerformed(UBMatrixChangeEvent ubmce) {
        UBMatrixChangeEvent.EventType eventType = null;
        eventType = ubmce.getEventType();
        if (eventType == UBMatrixChangeEvent.EventType.MODIFY) {
            PeakListData peakListData = null;
            peakListData = ubmce.getPeakSetsUsedForCalculation();
            if (peakListData != null) {
                this.adjustDisplay(peakListData);
                this.updateDisplayFromPeakListData(peakListData);
            }
        }
    }

    @Override
    public void actionPerformed(UBMatrixParsedAskResponse ubMatrixParsedAskResponse) {
        UBMatrixAskCommandEnums theCommand = null;
        boolean errorOccuredInTheCommand = false;
        theCommand = ubMatrixParsedAskResponse.getTheCommand();
        errorOccuredInTheCommand = ubMatrixParsedAskResponse.isErrorCondition();
        if (theCommand == UBMatrixAskCommandEnums.PRINT_UB && !errorOccuredInTheCommand) {
            try {
                String theUBXml = null;
                PeakListData peakListData = null;
                theUBXml = ubMatrixParsedAskResponse.getTheResponse();
                UBMatrixChangeEvent ubMatrixChangeEvent = null;
                ubMatrixChangeEvent = UBMatrixChangeEventParser.ubMatrixChangeEventParser(this, theUBXml);
                peakListData = ubMatrixChangeEvent.getPeakSetsUsedForCalculation();
                if (peakListData != null) {
                    this.adjustDisplay(peakListData);
                    this.updateDisplayFromPeakListData(peakListData);
                }
            }
            catch (UBMatrixParseChangeEventException e) {
                e.printStackTrace();
            }
        }
    }

    protected static enum Items {
        h("ice.gui.tas.bt7.UBReflectionSetPanel.hLabel"),
        k("ice.gui.tas.bt7.UBReflectionSetPanel.kLabel"),
        l("ice.gui.tas.bt7.UBReflectionSetPanel.lLabel"),
        a3("ice.gui.tas.bt7.UBReflectionSetPanel.a3Label"),
        a4("ice.gui.tas.bt7.UBReflectionSetPanel.a4Label"),
        ltilt("ice.gui.tas.bt7.UBReflectionSetPanel.ltiltLabel"),
        utitl("ice.gui.tas.bt7.UBReflectionSetPanel.utiltLabel");

        protected String labelKey = null;

        private Items(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getLabel() {
            String theLabel = null;
            theLabel = I18N.getString(this.labelKey);
            return theLabel;
        }
    }
}

