/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.config;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.data.InstalledDevice;
import ice.data.tas.bt7.Analyzer;
import ice.data.tas.bt7.Instrument;
import ice.data.tas.bt7.Monochromator;
import ice.event.AnalyzerPropertyChangedEvent;
import ice.event.AnalyzerPropertyChangedListener;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.MonochromatorPropertyChangedEvent;
import ice.event.MonochromatorPropertyChangedListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.gui.core.config.BaseConfigPanel;
import ice.gui.tas.bt7.config.ExpConfigWindow;
import ice.swing.Bag;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class DeviceDetailsPanel
extends BaseConfigPanel
implements DeviceListListener,
MonochromatorPropertyChangedListener,
AnalyzerPropertyChangedListener,
ActionListener,
DocumentListener,
DeviceValueChangedListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.ConfigLogger");
    static Pattern DSpacingPattern = Pattern.compile("([^=]*)=(.*)");
    private Collection<InstalledDevice> allDevices;
    HashMap<String, String> deviceNames = new HashMap(50);
    HashMap<String, InstalledDevice> configDevices = new HashMap(50);
    InstalledDevice[] collimators = new InstalledDevice[4];
    InstalledDevice[] slits = new InstalledDevice[4];
    private JTextField deviceNameField;
    private JTextField deviceAliasField;
    private JButton addDeviceBtn;
    private JTextField deviceToRemoveField;
    private DefaultListModel availableEnvironmentsModel;
    private JList availableEnvironmentsList;
    private JButton removeDeviceBtn;
    private DefaultComboBoxModel allDevicesModel;
    private JComboBox allDevicesCB;
    private JTextField lowerLimitField;
    private JTextField upperLimitField;
    private JButton resetBtn;
    private JButton applyBtn;
    private JComboBox monochromatorCB;
    private JComboBox analyzerCB;
    private JComboBox filterModeCB;
    JComboBox[] collimatorCBs = new JComboBox[4];
    JTextField[] slitFields = new JTextField[4];
    private HashMap<Object, Boolean> fieldModified;
    private SendQueueManager sendManager;
    private Instrument instrument;
    private Controller controller = Controller.getReference();

    public DeviceDetailsPanel(ExpConfigWindow realParent) {
        super(realParent);
        String formattedMaterial;
        String material;
        this.allDevices = new ArrayList<InstalledDevice>(100);
        this.controller.addDeviceListListener(this);
        this.fieldModified = new HashMap(20);
        this.deviceNames.put("coll1", "premonocoll");
        this.deviceNames.put("coll2", "postmonocoll");
        this.deviceNames.put("coll3", "preanacoll");
        this.deviceNames.put("coll4", "postanacoll");
        this.deviceNames.put("filter", "filtran");
        this.deviceNames.put("slit1", "frontslitwidth");
        this.deviceNames.put("slit2", "frontslitheight");
        this.deviceNames.put("slit3", "backslitwidth");
        this.deviceNames.put("slit4", "backslitheight");
        this.instrument = this.controller.getInstrument();
        try {
            this.instrument.getMonochromator().addPropertyChangeListener(this);
            this.instrument.getAnalyzer().addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("DeviceDetailsPanel can not add listener " + e);
        }
        this.sendManager = this.controller.getSendManager();
        this.deviceNameField = new JTextField();
        this.deviceAliasField = new JTextField();
        this.addDeviceBtn = new JButton(new AddAction());
        this.deviceToRemoveField = new JTextField();
        this.availableEnvironmentsModel = new DefaultListModel();
        this.availableEnvironmentsList = new JList(this.availableEnvironmentsModel);
        this.availableEnvironmentsList.setVisibleRowCount(5);
        this.availableEnvironmentsList.setCellRenderer(new EnvListBoxRenderer());
        this.removeDeviceBtn = new JButton(new RemoveAction());
        this.allDevicesModel = new DefaultComboBoxModel<Object>(this.allDevices.toArray());
        this.allDevicesCB = new JComboBox(this.allDevicesModel);
        this.allDevicesCB.addActionListener(new ChangeDeviceSelectionAction());
        this.lowerLimitField = new JTextField();
        this.upperLimitField = new JTextField();
        this.resetBtn = new JButton(new ResetAction());
        this.applyBtn = new JButton(new ApplyAction(this));
        this.monochromatorCB = new JComboBox();
        String[] stringArray = Monochromator.materials;
        int n = Monochromator.materials.length;
        int n2 = 0;
        while (n2 < n) {
            material = stringArray[n2];
            formattedMaterial = this.formatDSpacingString(material);
            if (formattedMaterial != null) {
                this.monochromatorCB.addItem(formattedMaterial);
            }
            ++n2;
        }
        this.analyzerCB = new JComboBox();
        stringArray = Analyzer.materials;
        n = Analyzer.materials.length;
        n2 = 0;
        while (n2 < n) {
            material = stringArray[n2];
            formattedMaterial = this.formatDSpacingString(material);
            if (formattedMaterial != null) {
                this.analyzerCB.addItem(formattedMaterial);
            }
            ++n2;
        }
        this.filterModeCB = new JComboBox<String>(this.instrument.getFilterModes());
        this.collimatorCBs[0] = new JComboBox<String>(this.instrument.getPreMonoCollimator().getModes());
        this.collimatorCBs[1] = new JComboBox<String>(this.instrument.getPostMonoCollimator().getModes());
        this.collimatorCBs[2] = new JComboBox<String>(this.instrument.getPreAnalCollimator().getModes());
        this.collimatorCBs[3] = new JComboBox<String>(this.instrument.getPostAnalCollimator().getModes());
        this.slitFields[0] = new JTextField();
        this.slitFields[1] = new JTextField();
        this.slitFields[2] = new JTextField();
        this.slitFields[3] = new JTextField();
        this.monochromatorCB.setEditable(true);
        this.analyzerCB.setEditable(true);
        this.collimatorCBs[1].setEditable(true);
        this.collimatorCBs[2].setEditable(true);
        this.collimatorCBs[3].setEditable(true);
        this.buildGUI();
        ArrayList<InstalledDevice> deviceList = this.controller.getDeviceList();
        this.updateDeviceList(deviceList);
        this.reload();
        this.monochromatorCB.addActionListener(this);
        this.analyzerCB.addActionListener(this);
        this.filterModeCB.addActionListener(this);
        JComponent[] jComponentArray = this.collimatorCBs;
        int n3 = this.collimatorCBs.length;
        n = 0;
        while (n < n3) {
            JComboBox collimatorCB = jComponentArray[n];
            collimatorCB.addActionListener(this);
            this.fieldModified.put(collimatorCB, false);
            ++n;
        }
        jComponentArray = this.slitFields;
        n3 = this.slitFields.length;
        n = 0;
        while (n < n3) {
            JComponent slitField = jComponentArray[n];
            ((JTextComponent)slitField).getDocument().addDocumentListener(this);
            this.fieldModified.put(((JTextComponent)slitField).getDocument(), false);
            ++n;
        }
        this.fieldModified.put(this.monochromatorCB, false);
        this.fieldModified.put(this.analyzerCB, false);
        this.fieldModified.put(this.filterModeCB, false);
    }

    public void buildGUI() {
        this.setName("Device Details");
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        this.add((Component)this.createDevicePanel(), constraints);
        ++constraints.gridy;
        this.add((Component)this.createLimitsPanel(), constraints);
        ++constraints.gridy;
        if (this.instrument.getName().compareToIgnoreCase("BT7") == 0) {
            this.add((Component)this.createSpecificsPanel(), constraints);
        } else {
            logger.debug("Skipping Instrument Specifics panel for " + this.instrument.getName());
        }
    }

    private String getThreeDecimalDeviceString(InstalledDevice device) {
        if (device == null) {
            return "N/A";
        }
        switch (device.getType()) {
            case counter: 
            case environment: 
            case motor: 
            case virtual: {
                try {
                    double result = Double.valueOf(device.getCurrValue());
                    return String.format("%1.3f", result);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return device.getCurrValue();
    }

    private InstalledDevice getDeviceByRealName(String name) {
        for (InstalledDevice device : this.allDevices) {
            if (!device.getRealName().equalsIgnoreCase(name)) continue;
            return device;
        }
        return null;
    }

    private void mapConfigDevicesByName() {
        for (String keyDeviceName : this.deviceNames.keySet()) {
            InstalledDevice device = this.getDeviceByRealName(this.deviceNames.get(keyDeviceName));
            this.configDevices.put(keyDeviceName, device);
        }
        this.collimators[0] = this.configDevices.get("coll1");
        this.collimators[1] = this.configDevices.get("coll2");
        this.collimators[2] = this.configDevices.get("coll3");
        this.collimators[3] = this.configDevices.get("coll4");
        this.slits[0] = this.configDevices.get("slit1");
        this.slits[1] = this.configDevices.get("slit2");
        this.slits[2] = this.configDevices.get("slit3");
        this.slits[3] = this.configDevices.get("slit4");
        int counter = 0;
        while (counter < 4) {
            if (this.collimators[counter] == null) {
                this.collimatorCBs[counter].setEnabled(false);
            } else {
                this.collimatorCBs[counter].setEnabled(true);
            }
            if (this.slits[counter] == null) {
                this.slitFields[counter].setEnabled(false);
            } else {
                this.slitFields[counter].setEnabled(true);
            }
            ++counter;
        }
        if (this.configDevices.get("filter") == null) {
            this.filterModeCB.setEnabled(false);
        } else {
            this.filterModeCB.setEnabled(true);
        }
    }

    void updateDeviceList(Collection<InstalledDevice> newDeviceList) {
        for (InstalledDevice device : newDeviceList) {
            if (this.allDevices.contains(device)) continue;
            try {
                device.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("DeviceDetailsPanel.updateDeviceList " + e);
            }
        }
        Object selectedObject = this.allDevicesCB.getSelectedItem();
        this.availableEnvironmentsModel.removeAllElements();
        this.allDevicesModel.removeAllElements();
        this.allDevices.clear();
        for (InstalledDevice device : newDeviceList) {
            InstalledDevice.Type theType = device.getType();
            if (theType == InstalledDevice.Type.environment) {
                this.availableEnvironmentsModel.addElement(device);
            }
            this.allDevicesModel.addElement(device);
            this.allDevices.add(device);
        }
        this.allDevicesCB.setSelectedItem(selectedObject);
        this.mapConfigDevicesByName();
    }

    @Override
    protected void reload() {
        this.resetSelectedValues();
        int counter = 0;
        while (counter < 4) {
            this.slitFields[counter].setText(this.getThreeDecimalDeviceString(this.slits[counter]));
            ++counter;
        }
        for (Object key : this.fieldModified.keySet()) {
            this.fieldModified.put(key, false);
        }
        this.setModified(false);
    }

    void setCBSelectedString(JComboBox cb, String value) {
        value = value.trim();
        int index = 0;
        while (index < cb.getItemCount()) {
            String item = (String)cb.getItemAt(index);
            if ((item = item.trim()).equalsIgnoreCase(value)) {
                cb.setSelectedIndex(index);
                return;
            }
            ++index;
        }
        if (cb.isEditable()) {
            cb.addItem(value);
            cb.setSelectedItem(value);
        }
    }

    void setCBSelectedDSpacing(JComboBox cb, double DSpacing) {
        int index = 0;
        while (index < cb.getItemCount()) {
            Double materialDSpacing = this.getDSpacingFromString((String)cb.getItemAt(index));
            if (materialDSpacing == DSpacing) {
                cb.setSelectedIndex(index);
                return;
            }
            ++index;
        }
        String newMaterial = String.format("Custom=%1.5f", DSpacing);
        cb.addItem(newMaterial);
        cb.setSelectedItem(newMaterial);
    }

    Double getCBSelectedDSpacing(JComboBox cb) {
        return this.getDSpacingFromString((String)cb.getSelectedItem());
    }

    private void resetSelectedValues() {
        this.setCBSelectedDSpacing(this.monochromatorCB, this.instrument.getMonochromator().getDSpacing());
        this.setCBSelectedDSpacing(this.analyzerCB, this.instrument.getAnalyzer().getDSpacing());
        if (this.configDevices.get("filter") != null) {
            this.setCBSelectedString(this.filterModeCB, this.configDevices.get("filter").getCurrValue());
        }
        int counter = 0;
        while (counter < 4) {
            if (this.collimators[counter] != null) {
                this.setCBSelectedString(this.collimatorCBs[counter], this.collimators[counter].getCurrValue());
            }
            ++counter;
        }
    }

    private Double getDSpacingFromString(String string) {
        Double DSpacingValue;
        Matcher m = DSpacingPattern.matcher(string);
        if (!m.matches()) {
            return null;
        }
        String DSpacingString = m.group(2);
        try {
            DSpacingValue = Double.valueOf(DSpacingString);
        }
        catch (NumberFormatException n) {
            return null;
        }
        return DSpacingValue;
    }

    private String formatDSpacingString(String string) {
        Double DSpacingValue;
        String materialName = null;
        Matcher m = DSpacingPattern.matcher(string);
        if (!m.matches()) {
            return null;
        }
        materialName = m.group(1);
        String DSpacingString = m.group(2);
        try {
            DSpacingValue = Double.valueOf(DSpacingString);
        }
        catch (NumberFormatException n) {
            return null;
        }
        return String.format("%s=%1.5f", materialName, DSpacingValue);
    }

    private JPanel createDevicePanel() {
        JPanel devicePanel = new JPanel(new GridBagLayout());
        devicePanel.setBorder(BorderFactory.createTitledBorder("Add/Remove Devices"));
        GridBagConstraints deviceConstraints = new GridBagConstraints();
        deviceConstraints.gridx = 0;
        deviceConstraints.gridy = 0;
        deviceConstraints.insets = new Insets(5, 5, 5, 5);
        deviceConstraints.fill = 1;
        JLabel addDeviceLabel = this.createLabel("Add Device");
        JLabel aliasDeviceLabel = this.createLabel("Alias (optional)");
        JLabel installedDevicesLabel = this.createLabel("Installed Devices");
        JPanel addPanel = new JPanel(new GridBagLayout());
        GridBagConstraints addConstraints = new GridBagConstraints();
        addConstraints.fill = 2;
        addConstraints.weightx = 1.0;
        addConstraints.gridx = 0;
        addConstraints.gridy = 0;
        addPanel.add((Component)this.deviceNameField, addConstraints);
        ++addConstraints.gridy;
        addPanel.add((Component)aliasDeviceLabel, addConstraints);
        ++addConstraints.gridy;
        addPanel.add((Component)this.deviceAliasField, addConstraints);
        JPanel removePanel = new JPanel(new GridBagLayout());
        GridBagConstraints removeConstraints = new GridBagConstraints();
        removeConstraints.fill = 1;
        removeConstraints.anchor = 21;
        removeConstraints.weightx = 1.0;
        removeConstraints.gridx = 0;
        removeConstraints.gridy = 0;
        removeConstraints.weighty = 0.0;
        removePanel.add((Component)this.deviceToRemoveField, removeConstraints);
        ++removeConstraints.gridy;
        removeConstraints.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.availableEnvironmentsList, 20, 31);
        removePanel.add((Component)scrollPane, removeConstraints);
        deviceConstraints.weightx = 1.0;
        deviceConstraints.weighty = 1.0;
        devicePanel.add((Component)addDeviceLabel, deviceConstraints);
        ++deviceConstraints.gridy;
        devicePanel.add((Component)addPanel, deviceConstraints);
        ++deviceConstraints.gridy;
        deviceConstraints.fill = 0;
        devicePanel.add((Component)this.addDeviceBtn, deviceConstraints);
        ++deviceConstraints.gridx;
        deviceConstraints.gridy -= 2;
        deviceConstraints.fill = 1;
        devicePanel.add((Component)installedDevicesLabel, deviceConstraints);
        ++deviceConstraints.gridy;
        devicePanel.add((Component)removePanel, deviceConstraints);
        ++deviceConstraints.gridy;
        deviceConstraints.fill = 0;
        devicePanel.add((Component)this.removeDeviceBtn, deviceConstraints);
        return devicePanel;
    }

    private JPanel createLimitsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Software Limits"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        JLabel deviceLabel = this.createLabel("Device");
        JLabel lowerLimitLabel = this.createLabel("Lower Limit");
        JLabel upperLimitLabel = this.createLabel("Upper Limit");
        panel.add((Component)deviceLabel, constraints);
        ++constraints.gridx;
        panel.add((Component)lowerLimitLabel, constraints);
        ++constraints.gridx;
        panel.add((Component)upperLimitLabel, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        panel.add((Component)this.allDevicesCB, constraints);
        ++constraints.gridx;
        panel.add((Component)this.lowerLimitField, constraints);
        ++constraints.gridx;
        panel.add((Component)this.upperLimitField, constraints);
        ++constraints.gridx;
        panel.add((Component)this.resetBtn, constraints);
        ++constraints.gridx;
        panel.add((Component)this.applyBtn, constraints);
        return panel;
    }

    private JPanel createSpecificsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Instrument Specifics"));
        Bag constraints = new Bag();
        int maxCols = 3;
        JLabel instructionsLabel = this.createLabel("<html>Parameters with an asterisk (*) are cannot be set through <br>the instrument control software and must be manually set.  All<br> values set here will be saved for use during data analysis.</html>");
        JLabel monochromatorLabel = this.createLabel("Monochromator:", true);
        JLabel analyzerLabel = this.createLabel("Analyzer:", true);
        JLabel filterModeLabel = this.createLabel("Filter Mode:");
        JLabel collimator1Label = this.createLabel("Premono Collim:");
        JLabel collimator2Label = this.createLabel("*Postmono Collim:", true);
        JLabel collimator3Label = this.createLabel("*Preana Collim:", true);
        JLabel collimator4Label = this.createLabel("*Postana Collim:", true);
        JLabel bsWidthLabel = this.createLabel("Width:", true);
        JLabel bsHeightLabel = this.createLabel("Height:", true);
        JLabel ssWidthLabel = this.createLabel("Width:", true);
        JLabel ssHeightLabel = this.createLabel("Height:", true);
        JPanel collimatorPanel = new JPanel(new GridBagLayout());
        collimatorPanel.setBorder(BorderFactory.createTitledBorder("Collimators"));
        GridBagConstraints collimatorConstraints = new GridBagConstraints();
        collimatorConstraints.gridx = 0;
        collimatorConstraints.gridy = 0;
        collimatorConstraints.insets = new Insets(5, 5, 5, 5);
        collimatorConstraints.fill = 2;
        collimatorPanel.add((Component)collimator1Label, collimatorConstraints);
        ++collimatorConstraints.gridx;
        collimatorPanel.add((Component)this.collimatorCBs[0], collimatorConstraints);
        ++collimatorConstraints.gridx;
        collimatorPanel.add((Component)collimator2Label, collimatorConstraints);
        ++collimatorConstraints.gridx;
        collimatorPanel.add((Component)this.collimatorCBs[1], collimatorConstraints);
        ++collimatorConstraints.gridy;
        collimatorConstraints.gridx = 0;
        collimatorPanel.add((Component)collimator3Label, collimatorConstraints);
        ++collimatorConstraints.gridx;
        collimatorPanel.add((Component)this.collimatorCBs[2], collimatorConstraints);
        ++collimatorConstraints.gridx;
        collimatorPanel.add((Component)collimator4Label, collimatorConstraints);
        ++collimatorConstraints.gridx;
        collimatorPanel.add((Component)this.collimatorCBs[3], collimatorConstraints);
        JPanel bssPanel = new JPanel(new GridBagLayout());
        bssPanel.setBorder(BorderFactory.createTitledBorder("Back Slit Settings"));
        GridBagConstraints bssConstraints = new GridBagConstraints();
        bssConstraints.gridx = 0;
        bssConstraints.gridy = 0;
        bssConstraints.insets = new Insets(5, 5, 5, 5);
        bssConstraints.fill = 2;
        bssConstraints.weightx = 0.0;
        bssPanel.add((Component)bsWidthLabel, bssConstraints);
        ++bssConstraints.gridx;
        bssConstraints.weightx = 1.0;
        bssPanel.add((Component)this.slitFields[2], bssConstraints);
        ++bssConstraints.gridx;
        bssConstraints.weightx = 0.0;
        bssPanel.add((Component)bsHeightLabel, bssConstraints);
        ++bssConstraints.gridx;
        bssConstraints.weightx = 1.0;
        bssPanel.add((Component)this.slitFields[3], bssConstraints);
        JPanel sssPanel = new JPanel(new GridBagLayout());
        sssPanel.setBorder(BorderFactory.createTitledBorder("Sample Slit Settings"));
        GridBagConstraints sssConstraints = new GridBagConstraints();
        sssConstraints.gridx = 0;
        sssConstraints.gridy = 0;
        sssConstraints.insets = new Insets(5, 5, 5, 5);
        sssConstraints.fill = 2;
        sssConstraints.weightx = 0.0;
        sssPanel.add((Component)ssWidthLabel, sssConstraints);
        ++sssConstraints.gridx;
        sssConstraints.weightx = 1.0;
        sssPanel.add((Component)this.slitFields[0], sssConstraints);
        ++sssConstraints.gridx;
        sssConstraints.weightx = 0.0;
        sssPanel.add((Component)ssHeightLabel, sssConstraints);
        ++sssConstraints.gridx;
        sssConstraints.weightx = 1.0;
        sssPanel.add((Component)this.slitFields[1], sssConstraints);
        int x = 0;
        int y = 0;
        panel.add((Component)instructionsLabel, constraints.cell(x, y).colspan(maxCols));
        panel.add((Component)new JLabel(""), constraints.cell(x + 2, ++y).fillx(1.0));
        x = 0;
        panel.add((Component)monochromatorLabel, constraints.cell(x, ++y));
        panel.add((Component)this.monochromatorCB, constraints.cell(++x, y));
        panel.add((Component)analyzerLabel, constraints.cell(--x, ++y));
        panel.add((Component)this.analyzerCB, constraints.cell(++x, y));
        panel.add((Component)filterModeLabel, constraints.cell(--x, ++y));
        panel.add((Component)this.filterModeCB, constraints.cell(++x, y));
        panel.add((Component)collimatorPanel, constraints.cell(--x, ++y).colspan(maxCols));
        panel.add((Component)bssPanel, constraints.cell(x, ++y).colspan(maxCols));
        panel.add((Component)sssPanel, constraints.cell(x, ++y).colspan(maxCols));
        return panel;
    }

    private synchronized void setLimitFields() {
        System.out.println("set limits fields");
        try {
            InstalledDevice device = (InstalledDevice)this.allDevicesCB.getSelectedItem();
            if (device == null) {
                this.lowerLimitField.setText("Undefined");
                this.upperLimitField.setText("Undefined");
            } else {
                if (device.getLowerLimit() == null) {
                    this.lowerLimitField.setText("Undefined");
                } else {
                    this.lowerLimitField.setText(device.getLowerLimit().toString());
                }
                if (device.getUpperLimit() == null) {
                    this.upperLimitField.setText("Undefined");
                } else {
                    this.upperLimitField.setText(device.getUpperLimit().toString());
                }
            }
        }
        catch (ClassCastException cce) {
            logger.error("Non-device stored in combo box.  Cancelling operation and clearing limit fields.", cce);
            this.lowerLimitField.setText("");
            this.upperLimitField.setText("");
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        this.updateDeviceList(dle.getNewList());
        this.reload();
    }

    private void addDevice(String deviceName, String deviceAlias) {
        this.sendManager.addMessage("device add env \"" + deviceName + "\"");
        String aliasName = this.deviceAliasField.getText();
        if (!aliasName.equals("")) {
            this.sendManager.addMessage("device add alias \"" + aliasName + "\" \"" + deviceName + "\"");
        }
    }

    private void removeDevice(InstalledDevice device) {
        this.sendManager.addMessage("device destroy \"" + device.getRealName() + "\"");
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        if (changedDevice == (InstalledDevice)this.allDevicesCB.getSelectedItem()) {
            Double upperLimit;
            if (evt.getPropertyName() == "lowerLimit") {
                Double lowerLimit = changedDevice.getLowerLimit();
                System.out.println("current lowerlimit " + this.lowerLimitField.getText());
                System.out.println("device lowerlimit " + lowerLimit);
                if (lowerLimit != null) {
                    this.lowerLimitField.setText(Double.toString(changedDevice.getLowerLimit()));
                }
            } else if (evt.getPropertyName() == "upperLimit" && (upperLimit = changedDevice.getUpperLimit()) != null) {
                this.upperLimitField.setText(Double.toString(changedDevice.getUpperLimit()));
            }
        }
        if (evt.getPropertyName().equalsIgnoreCase("currValue") || evt.getPropertyName().equalsIgnoreCase("alias")) {
            this.processIncomingChanges();
        }
    }

    @Override
    public void actionPerformed(AnalyzerPropertyChangedEvent event) {
        if (event.getPropertyName().equalsIgnoreCase("DSpacing")) {
            this.processIncomingChanges();
        }
    }

    @Override
    public void actionPerformed(MonochromatorPropertyChangedEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("DSpacing")) {
            this.processIncomingChanges();
        }
    }

    @Override
    protected boolean isCompleted() {
        if (this.instrument.getName().compareToIgnoreCase("BT7") == 0) {
            int counter = 1;
            while (counter < 4) {
                String value;
                if (this.collimators[counter] != null && (value = (String)this.collimatorCBs[counter].getSelectedItem()).equalsIgnoreCase("Undefined")) {
                    return false;
                }
                ++counter;
            }
            Double DSpacing = this.getCBSelectedDSpacing(this.monochromatorCB);
            if (DSpacing == null) {
                return false;
            }
            DSpacing = this.getCBSelectedDSpacing(this.analyzerCB);
            if (DSpacing == null) {
                return false;
            }
            try {
                counter = 0;
                while (counter < 4) {
                    if (this.slits[counter] != null) {
                        Double.valueOf(this.slitFields[counter].getText());
                    }
                    ++counter;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else {
            logger.debug("Skipping Instrument Specifics panel for " + this.instrument.getName());
        }
        return true;
    }

    @Override
    protected String getCompletionErrorString() {
        int counter = 1;
        while (counter < 4) {
            String value;
            if (this.collimators[counter] != null && (value = (String)this.collimatorCBs[counter].getSelectedItem()).equalsIgnoreCase("Undefined")) {
                return String.valueOf(this.collimators[counter].getName()) + " cannot be undefined";
            }
            ++counter;
        }
        Double DSpacing = this.getCBSelectedDSpacing(this.monochromatorCB);
        if (DSpacing == null) {
            return "Monochromator DSpacing must be of form Name=<DSpacing>";
        }
        DSpacing = this.getCBSelectedDSpacing(this.analyzerCB);
        if (DSpacing == null) {
            return "Analyzer DSpacing must be of form Name=<DSpacing>";
        }
        try {
            counter = 0;
            while (counter < 4) {
                if (this.slits[counter] != null) {
                    Double.valueOf(this.slitFields[counter].getText());
                }
                ++counter;
            }
        }
        catch (NumberFormatException e) {
            return "Slit devices must be set to numbers";
        }
        return "";
    }

    @Override
    protected boolean commitChanges(SendQueueManager sendManager) {
        Double DSpacing;
        int response = JOptionPane.showConfirmDialog(this, "Devices may move as a result of this operation.\nIs this OK?", "Confirm Possible Device Movement", 0);
        if (response != 0) {
            return false;
        }
        if (this.fieldModified.get(this.monochromatorCB).booleanValue()) {
            DSpacing = this.getCBSelectedDSpacing(this.monochromatorCB);
            sendManager.addMessage("Instrument SetMonoSpacing " + DSpacing.toString());
        }
        if (this.fieldModified.get(this.analyzerCB).booleanValue()) {
            DSpacing = this.getCBSelectedDSpacing(this.analyzerCB);
            sendManager.addMessage("Instrument SetAnaSpacing " + DSpacing.toString());
        }
        int counter = 0;
        while (counter < 4) {
            if (this.collimators[counter] != null && this.fieldModified.get(this.collimatorCBs[counter]).booleanValue()) {
                sendManager.addMessage("move " + this.collimators[counter].getName() + " " + this.collimatorCBs[counter].getSelectedItem());
            }
            if (this.slits[counter] != null && this.fieldModified.get(this.slitFields[counter].getDocument()).booleanValue()) {
                sendManager.addMessage("move " + this.slits[counter].getName() + " " + this.slitFields[counter].getText());
            }
            ++counter;
        }
        if (this.configDevices.get("filter") != null && this.fieldModified.get(this.filterModeCB).booleanValue()) {
            sendManager.addMessage("move " + this.configDevices.get("filter").getName() + " " + this.filterModeCB.getSelectedItem());
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.fieldModified.containsKey(ae.getSource())) {
            this.fieldModified.put(ae.getSource(), true);
        }
        this.setModified(true);
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        if (this.fieldModified.containsKey(de.getDocument())) {
            this.fieldModified.put(de.getDocument(), true);
        }
        this.setModified(true);
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        if (this.fieldModified.containsKey(de.getDocument())) {
            this.fieldModified.put(de.getDocument(), true);
        }
        this.setModified(true);
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        if (this.fieldModified.containsKey(de.getDocument())) {
            this.fieldModified.put(de.getDocument(), true);
        }
        this.setModified(true);
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("Name", "Add");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DeviceDetailsPanel.this.addDevice(DeviceDetailsPanel.this.deviceNameField.getText(), DeviceDetailsPanel.this.deviceAliasField.getText());
        }
    }

    private class ApplyAction
    extends AbstractAction {
        BaseConfigPanel mainPanel;

        public ApplyAction(BaseConfigPanel mainPanel) {
            this.putValue("Name", "Apply");
            this.mainPanel = mainPanel;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            InstalledDevice selectedDevice = (InstalledDevice)DeviceDetailsPanel.this.allDevicesCB.getSelectedItem();
            if (selectedDevice == null) {
                JOptionPane.showMessageDialog(this.mainPanel, "Cannot set limits if no device is selected");
            }
            try {
                Double.valueOf(DeviceDetailsPanel.this.lowerLimitField.getText());
                Double.valueOf(DeviceDetailsPanel.this.upperLimitField.getText());
            }
            catch (NumberFormatException n) {
                JOptionPane.showMessageDialog(this.mainPanel, "The device limits must be numbers.", "Invalid value for limits", 0);
                return;
            }
            DeviceDetailsPanel.this.sendManager.addMessage("device setlowerlimit " + selectedDevice.getName() + " " + DeviceDetailsPanel.this.lowerLimitField.getText());
            DeviceDetailsPanel.this.sendManager.addMessage("device setupperlimit " + selectedDevice.getName() + " " + DeviceDetailsPanel.this.upperLimitField.getText());
        }
    }

    private class ChangeDeviceSelectionAction
    extends AbstractAction {
        public ChangeDeviceSelectionAction() {
            this.putValue("Name", "ChangeDeviceSelectionAction");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DeviceDetailsPanel.this.setLimitFields();
        }
    }

    private class EnvListBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public EnvListBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            if (value != null) {
                InstalledDevice device = (InstalledDevice)value;
                text = device.getRealName();
                if (device.getAlias() != null) {
                    text = String.valueOf(text) + " (" + device.getAlias() + ")";
                }
            } else {
                text = "";
            }
            this.setText(text);
            this.setFont(list.getFont());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", "Remove");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Object[] selectedDeviceNames;
            Object[] objectArray = selectedDeviceNames = DeviceDetailsPanel.this.availableEnvironmentsList.getSelectedValues();
            int n = selectedDeviceNames.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedDevice = objectArray[n2];
                DeviceDetailsPanel.this.removeDevice((InstalledDevice)selectedDevice);
                ++n2;
            }
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            this.putValue("Name", "Reset");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DeviceDetailsPanel.this.setLimitFields();
        }
    }
}

