/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas;

import ice.Controller;
import ice.exceptions.IcePanelException;
import ice.gui.tas.TASBaseSampleAlignmentPanel;
import ice.swing.Bag;
import ice.util.I18N;
import ice.util.PreferencesManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SampleAlignmentNonWizardPanel
extends TASBaseSampleAlignmentPanel {
    protected JLabel modeLink;
    private JLabel instructionsLabel;
    private Controller controller;

    @Override
    protected void init() {
        super.initBT7BaseSampleAlignmentPanel();
        this.controller = Controller.getReference();
        this.modeLink = new JLabel(I18N.getString("ubSampleAlignment.enableUBMode.label"));
        this.modeLink.setForeground(Color.BLUE);
        this.modeLink.setCursor(new Cursor(12));
        this.modeLink.addMouseListener(new ModeSwitchListener());
        String instructionsText = "<html>To define the scattering plane, a minimum of two reflections must be found. <br>Drive to the lattice reflection desired and fine tune the location using the steps below. <br>Repeat this for any number of reflections until you are confident the desired <br>plane is defined.<br><br>Elastic scattering assumed: Ef = Ei</html>";
        this.instructionsLabel = new JLabel(instructionsText);
    }

    @Override
    protected void buildGUI() {
        super.buildBT7BaseSampleAlignmentPanel();
        String allowUBMode = PreferencesManager.getPreferenceString("allowUBMode");
        this.setLayout(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        JLabel spacer1 = new JLabel("");
        JLabel spacer2 = new JLabel("");
        this.add((Component)spacer1, constraints.cell(x, y));
        this.add((Component)spacer2, constraints.cell(++x, y).fillx());
        if (allowUBMode.equalsIgnoreCase("true")) {
            this.add((Component)this.modeLink, constraints.cell(++x, y));
        }
        x = 0;
        this.add((Component)this.createSetupPanel(), constraints.cell(x, ++y).colspan(3));
        this.add((Component)this.createMovePanel(), constraints.cell(x, ++y).colspan(3));
        this.add((Component)this.createAlignPanel(this.instructionsLabel, "Align Sample at Lattice Reflection(s)"), constraints.cell(x, ++y).colspan(3));
        SwingUtilities.invokeLater(this.usf);
    }

    protected JPanel createAlignPanel(JLabel instructionsLabel, String title) {
        JLabel hLabel = new JLabel("h:");
        JLabel kLabel = new JLabel("k:");
        JLabel lLabel = new JLabel("l:");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(title));
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxCols = 11;
        int maxRows = 11;
        Insets insets = constraints.insets;
        Insets labelInsets = new Insets(insets.top, insets.left, insets.bottom, 0);
        Insets fieldInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right * 2);
        if (this.initialEnergy == null) {
            this.targetHField.setEditable(false);
            this.targetKField.setEditable(false);
            this.targetLField.setEditable(false);
            this.driveA4Btn.setEnabled(false);
            this.driveQBtn.setEnabled(false);
        }
        panel.add((Component)instructionsLabel, constraints.cell(x, y).colspan(maxCols));
        panel.add((Component)new JLabel("   "), constraints.cell(x, ++y));
        panel.add((Component)hLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.targetHField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)kLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.targetKField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)lLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.targetLField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx(1.0));
        panel.add((Component)this.driveA4Btn, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)this.driveQBtn, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx(0.5));
        x = 0;
        panel.add((Component)this.createCalcPanelRow(), constraints.cell(x, ++y).colspan(maxCols));
        panel.add((Component)this.createLinkPanel(), constraints.cell(x, ++y).colspan(maxCols));
        y = maxRows - 1;
        panel.add((Component)new JLabel(""), constraints.cell(x, y).filly());
        this.tabOrder.add(this.targetKField);
        this.tabOrder.add(this.targetLField);
        this.tabOrder.add(this.driveA4Btn);
        this.tabOrder.add(this.driveQBtn);
        TASBaseSampleAlignmentPanel.MyFocusTraversalPolicy focusPolicy = new TASBaseSampleAlignmentPanel.MyFocusTraversalPolicy(this, this.tabOrder);
        panel.setFocusTraversalPolicy(focusPolicy);
        panel.setFocusCycleRoot(true);
        return panel;
    }

    protected class ModeSwitchListener
    extends MouseAdapter {
        protected ModeSwitchListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SampleAlignmentNonWizardPanel.this.sendManager.addMessage("enableubmode");
        }
    }
}

