/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.buttons.ManualOpButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.subpanels.SansPanelController;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.KeyStroke;

public class ManualOperationsPanel
extends SansIcePanel {
    public static final String manualOperations = "Manual Operations";
    private JList manualList;
    private ManualOpButtonControlPanel buttonPanel;

    public ManualOperationsPanel() throws IcePanelException {
        super(manualOperations, manualOperations);
    }

    @Override
    protected void buildGUI() {
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "show");
        ManualOpAction showAction = new ManualOpAction();
        this.getActionMap().put("show", showAction);
        this.setLayout(new GridBagLayout());
        this.manualList.setModel(new AbstractListModel(){
            String[] strings = new String[]{DeviceOptions.SAMPLE.getValue(), DeviceOptions.BEAMSTOP.getValue(), DeviceOptions.DETECTOR.getValue(), DeviceOptions.WAVELENGTH.getValue(), DeviceOptions.ATTENUATION.getValue(), DeviceOptions.COLLIMATION.getValue(), DeviceOptions.FLIPPER.getValue(), DeviceOptions.TEMPERATURE.getValue(), DeviceOptions.MAGNETIC_FIELD.getValue(), DeviceOptions.COUNT_RATE.getValue(), DeviceOptions.RHEOSANS.getValue(), DeviceOptions.TIMESLICE.getValue()};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.manualList.setSelectionMode(0);
        this.manualList.setSelectedIndex(0);
        this.manualList.setPreferredSize(new Dimension(300, 300));
        this.manualList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ManualOperationsPanel.this.manualListMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.titleLbl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(20, 0, 20, 0);
        this.add((Component)this.manualList, gridBagConstraints);
        gridBagConstraints.fill = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.helpPanel, gridBagConstraints);
        this.writeKeysToHelpPreferenceFile();
        this.buttonPanel.writeKeysToHelpPreferenceFile(this);
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        this.manualList = new JList();
        this.buttonPanel = new ManualOpButtonControlPanel(this);
        this.initSansIcePanel();
        this.writeKeysToHelpPreferenceFile();
    }

    private void manualListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.performAction();
        }
    }

    @Override
    public void updateDeviceControls() {
    }

    @Override
    public boolean requestFocusInIceWindow() {
        return this.manualList.requestFocusInWindow();
    }

    private void performAction() {
        SansPanelController swapPanel = SansPanelController.getReference();
        String selection = (String)this.manualList.getSelectedValue();
        DeviceOptions option = DeviceOptions.getValue(selection);
        switch (option) {
            case SAMPLE: {
                swapPanel.showSampleChangerOrHuberTablePanel();
                break;
            }
            case BEAMSTOP: {
                swapPanel.showBeamstopPanel();
                break;
            }
            case RHEOSANS: {
                swapPanel.showRheoSANSPanel();
                break;
            }
            case DETECTOR: {
                swapPanel.showDetectorPanel();
                break;
            }
            case WAVELENGTH: {
                swapPanel.showWavelenthPanel();
                break;
            }
            case COLLIMATION: {
                swapPanel.showCollimationPanel();
                break;
            }
            case ATTENUATION: {
                swapPanel.showAttenuationPanel();
                break;
            }
            case TEMPERATURE: {
                swapPanel.showSampleTemperature();
                break;
            }
            case MAGNETIC_FIELD: {
                swapPanel.showSampleMagneticField();
                break;
            }
            case FLIPPER: {
                swapPanel.showFlipperPanel();
            }
        }
    }

    @Override
    protected void updateLockState() {
        super.updateLockState();
        this.manualList.setEnabled(!this.isLocked());
    }

    public static enum DeviceOptions {
        SAMPLE("Change/Initialize Sample POSITION/ANGLE"),
        BEAMSTOP("Select/Move BEAMSTOP"),
        DETECTOR("Change/Initialize DETECTOR DISTANCE/OFFSET"),
        RHEOSANS("Activate/Deactivate RHEOSANS"),
        WAVELENGTH("Chanage/Initialize WAVELENGTH"),
        ATTENUATION("Change/Initialize ATTENUATION"),
        COLLIMATION("Change/Initialize COLLIMATION"),
        FLIPPER("Activate/Change FLIPPER Power Supply"),
        TEMPERATURE("Change/Initialize Sample TEMPERATURE"),
        MAGNETIC_FIELD("Change/Initialize Sample Magnetic FIELD"),
        COUNT_RATE("Monitor Count Rate/Transmission MEASUREMENT"),
        TIMESLICE("Change/Initialize Timeslice INTERVAL");

        private String option;
        private static final Map<String, DeviceOptions> optionMap;

        static {
            optionMap = new HashMap<String, DeviceOptions>();
            for (DeviceOptions op : EnumSet.allOf(DeviceOptions.class)) {
                optionMap.put(op.getValue(), op);
            }
        }

        private DeviceOptions(String value) {
            this.option = value;
        }

        public String getValue() {
            return this.option;
        }

        public static DeviceOptions getValue(String option) {
            return optionMap.get(option);
        }
    }

    private class ManualOpAction
    extends AbstractAction {
        private ManualOpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ManualOperationsPanel.this.performAction();
        }
    }
}

