/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.NumberOutOfRangeListener;
import ice.event.communication.EmptyDocumentListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.SansDeviceControlDoubleNoScalePanel;
import ice.gui.panel.sans.controls.SansDeviceControlNoScalePanel;
import ice.gui.panel.sans.controls.buttons.DetectorButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class DetectorPanel
extends SansIcePanel
implements DeviceListListener {
    public static final String detectorDistance = "DetectorPos";
    public static final String detectorOffset = "DetectorOffset";
    private static final String title = "Detector Distance/Offset";
    private SansDeviceControlDoubleNoScalePanel detDistance;
    private SansDeviceControlDoubleNoScalePanel detOffset;
    private DetectorButtonControlPanel buttonPanel;
    private ArrayList<InstalledDevice> allDevices;
    private Controller controller;
    protected static final String DETECTOR_DISTANCE_NAME = "Detector Distance";
    protected static final String DETECTOR_OFFSET_NAME = "Detector Offset";

    public DetectorPanel() throws IcePanelException {
        super(detectorDistance, title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.detDistance, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.detOffset, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.writeKeysToHelpPreferenceFile();
        this.buttonPanel.writeKeysToHelpPreferenceFile(this);
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.detDistance = new SansDeviceControlDoubleNoScalePanel(DETECTOR_DISTANCE_NAME, detectorDistance, "cm");
        this.detDistance.listenToTargetEmptyDocumentEvent(this);
        this.detOffset = new SansDeviceControlDoubleNoScalePanel(DETECTOR_OFFSET_NAME, detectorOffset, "cm");
        this.detOffset.listenToTargetEmptyDocumentEvent(this);
        this.buttonPanel = new DetectorButtonControlPanel(this);
        this.helpPanel = new HelpPanel();
        this.controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.controller.getDeviceListeners().add(this);
    }

    @Override
    public void documentChanged(EmptyDocumentListener.EmptyDocumentEvent e) {
        boolean buttonOn;
        super.documentChanged(e);
        SANSDecimalFormattedTextField textField = (SANSDecimalFormattedTextField)e.getSource();
        SansDeviceControlDoubleNoScalePanel parent = (SansDeviceControlDoubleNoScalePanel)textField.getParent();
        String name = parent.getControlName();
        EmptyDocumentListener.EmptyDocumentState state = e.getState();
        NumberOutOfRangeListener.NumberRange inRange = textField.inRange();
        if (state == EmptyDocumentListener.EmptyDocumentState.FORMATTING) {
            return;
        }
        boolean bl = buttonOn = state == EmptyDocumentListener.EmptyDocumentState.HAS_TEXT && inRange == NumberOutOfRangeListener.NumberRange.IN_RANGE;
        if (name != null && name.equals(DETECTOR_DISTANCE_NAME)) {
            this.buttonPanel.enableMoveDetDistanceBtn(buttonOn);
        } else if (name != null && name.equals(DETECTOR_OFFSET_NAME)) {
            this.buttonPanel.enableMoveDetOffsetBtn(buttonOn);
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null) continue;
            Double min = Double.MIN_VALUE;
            Double max = Double.MAX_VALUE;
            if (device.getName().equalsIgnoreCase(detectorDistance)) {
                device.removeValueChangeListener(this.detDistance);
                continue;
            }
            if (!device.getName().equalsIgnoreCase(detectorOffset)) continue;
            device.removeValueChangeListener(this.detOffset);
        }
        this.allDevices = dle.getNewList();
        this.updateDeviceControls();
    }

    @Override
    public void updateDeviceControls() {
        for (InstalledDevice device : this.allDevices) {
            try {
                String currentValue;
                if (device.getName() == null) continue;
                Double min = Double.MIN_VALUE;
                Double max = Double.MAX_VALUE;
                if (device.getName().equalsIgnoreCase(detectorDistance)) {
                    device.addValueChangeListener(this.detDistance);
                    currentValue = device.getCurrValue().toString();
                    this.detDistance.setCurrentValue(currentValue);
                    min = device.getLowerLimit();
                    max = device.getUpperLimit();
                    this.detDistance.setTargetMinMax(min, max);
                    this.detDistance.setFixed(device.isFixed());
                    continue;
                }
                if (!device.getName().equalsIgnoreCase(detectorOffset)) continue;
                device.addValueChangeListener(this.detOffset);
                currentValue = device.getCurrValue().toString();
                this.detOffset.setCurrentValue(currentValue);
                min = device.getLowerLimit();
                max = device.getUpperLimit();
                this.detOffset.setTargetMinMax(min, max);
                this.detOffset.setFixed(device.isFixed());
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("DetectorPanel.updateDeviceControls " + e);
            }
        }
    }

    public SansDeviceControlNoScalePanel getDetDistanceControl() {
        return this.detDistance;
    }

    public SansDeviceControlNoScalePanel getDetOffsetControl() {
        return this.detOffset;
    }
}

