/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.ClientAPI;
import ice.Controller;
import ice.Global;
import ice.commands.DevicePositionsCommand;
import ice.commands.ImmediateCommand;
import ice.commands.QueuedCommand;
import ice.communication.SendQueueManager;
import ice.data.InstalledDevice;
import ice.data.Sample;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.CollimationControl;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.SansButtonPanelControl;
import ice.gui.panel.sans.controls.SansDeviceComboBoxControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.SansDeviceTextFieldDoubleControlPanel;
import ice.gui.panel.sans.controls.SansSampleTextFieldDoubleControlPanel;
import ice.gui.panel.sans.controls.buttons.F20PreviousMenuButton;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.swing.buttons.KeyResponseButton;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.InputMap;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class CollimationPanel
extends SansIcePanel
implements DeviceListListener {
    private static final long serialVersionUID = 4084337818592798349L;
    private static final String title = "Collimation";
    public static final String collimation = "GuideTable";
    public static final String guide01apert = "Guide01";
    public static final String lenses = "Guide10";
    public static final String guide08apert = "Guide08";
    private static final String back = "F20: Previous Menu";
    private static final String newGuideConfigString = "F17: New Guide Config";
    private static final String currentSourceString = "Current Source pinhole diameter (mm): ";
    public static final String currentSource = "APERT";
    private static final String currentSampleString = "Current Sample pinhole diameter (mm): ";
    public static final String currentSample = "apert";
    public static final String polarizedBeam = "POLBEAM";
    private static final String previousMenuToolTipString = "<html>F20: Go to previous panel.</html>";
    private static final String newGuideConfigToolTipString = "<html>F17: Start Scan.</html>";
    private static Logger logger = Logger.getLogger("ErrorLogger.CollimationPanel");
    private SansDeviceComboBoxControlPanel collimationControl;
    private SansDeviceComboBoxControlPanel apertureControl;
    private SansDeviceComboBoxControlPanel lensesControl;
    private CollimationControl swapControl;
    private SansDeviceTextFieldDoubleControlPanel currentSourceControl;
    private SansSampleTextFieldDoubleControlPanel currentSampleControl;
    private SansButtonPanelControl buttonsPanel;
    private F20PreviousMenuButton previousMenuButton;
    private KeyResponseButton newGuideConfigButton;
    private ArrayList<InstalledDevice> allDevices;
    private Controller controller;
    private SendQueueManager sendManager;
    private String[] guide01ApertValues;
    private String[] guide08ApertValues;

    public CollimationPanel() throws IcePanelException {
        super(title, title);
    }

    @Override
    protected void buildGUI() {
        this.buildButtonsPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.collimationControl, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.apertureControl, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.lensesControl, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.currentSourceControl, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.currentSampleControl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonsPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.writeKeysToHelpPreferenceFile();
        this.buttonsPanel.writeKeysToHelpPreferenceFile(this);
        this.buttonsPanel.readButtonHintsFromPreferenceFile();
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        String[] values;
        DevicePositionsCommand iCommand;
        ClientAPI messageSender;
        this.initSansIcePanel();
        this.controller = Controller.getReference();
        this.collimationControl = new SansDeviceComboBoxControlPanel(title, collimation, true);
        this.apertureControl = new SansDeviceComboBoxControlPanel("Apertures", guide01apert, "mm", false);
        this.lensesControl = new SansDeviceComboBoxControlPanel("Lenses", lenses, false);
        this.swapControl = new CollimationControl(this.apertureControl);
        InstalledDevice guideTable = this.controller.getFirstDevice(collimation);
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand(collimation, messageSender);
            iCommand.runSynchronous();
            values = iCommand.getParsedResponse();
            this.collimationControl.addItems(values);
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand("Guide08 apert", messageSender);
            iCommand.runSynchronous();
            this.guide08ApertValues = iCommand.getParsedResponse();
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand("Guide01 apert", messageSender);
            iCommand.runSynchronous();
            this.guide01ApertValues = iCommand.getParsedResponse();
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand(lenses, messageSender);
            iCommand.runSynchronous();
            values = iCommand.getParsedResponse();
            this.lensesControl.addItems(values);
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        this.currentSourceControl = new SansDeviceTextFieldDoubleControlPanel(currentSourceString, collimation, currentSource, "");
        this.currentSourceControl.setDisabled(true);
        this.currentSampleControl = new SansSampleTextFieldDoubleControlPanel(currentSampleString, "Sample", currentSample, "");
        this.buttonsPanel = new SansButtonPanelControl(this);
        this.previousMenuButton = new F20PreviousMenuButton();
        this.newGuideConfigButton = new KeyResponseButton(newGuideConfigString, newGuideConfigString, 120);
        this.helpPanel = new HelpPanel();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.controller.getDeviceListeners().add(this);
        this.sendManager = this.controller.getSendManager();
        this.collimationControl.addActionListener(new CollimationComboBoxActionListener());
        Sample sample = this.controller.getSample();
        double apert = sample.getApert();
        this.currentSampleControl.setCurrentValue(String.valueOf(apert));
    }

    private void buildButtonsPanel() {
        InputMap inputMap = this.getInputMap(2);
        this.previousMenuButton.setToolTipText(previousMenuToolTipString);
        this.newGuideConfigButton.setToolTipText(newGuideConfigToolTipString);
        this.buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 13);
        this.buttonsPanel.add((Component)this.previousMenuButton, gridBagConstraints);
        NewGuideConfigAction configAction = new NewGuideConfigAction();
        this.newGuideConfigButton.addActionListener(configAction);
        this.buttonsPanel.addToClearsErrors(this.newGuideConfigButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 13);
        this.buttonsPanel.add((Component)this.newGuideConfigButton, gridBagConstraints);
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null) continue;
            if (device.getName().equalsIgnoreCase(collimation)) {
                device.removeValueChangeListener(this.collimationControl);
                device.removeValueChangeListener(this.currentSourceControl);
                continue;
            }
            if (device.getName().equalsIgnoreCase(guide01apert)) {
                device.removeValueChangeListener(this.apertureControl);
                continue;
            }
            if (!device.getName().equalsIgnoreCase(lenses)) continue;
            device.removeValueChangeListener(this.lensesControl);
        }
        this.allDevices = dle.getNewList();
        this.updateDeviceControls();
    }

    @Override
    public void updateDeviceControls() {
        for (InstalledDevice device : this.allDevices) {
            try {
                String currentValue;
                if (device.getName() == null) continue;
                if (device.getName().equalsIgnoreCase(collimation)) {
                    device.addValueChangeListener(this.collimationControl);
                    device.addValueChangeListener(this.currentSourceControl);
                    currentValue = device.getCurrValue().toString();
                    this.collimationControl.setCurrentValue(currentValue);
                    String sourceApert = device.getAdditionalPropertyValue(currentSource);
                    this.currentSourceControl.setCurrentValue(sourceApert);
                    this.collimationControl.setFixed(device.isFixed());
                    this.configureCollimationControls(this.collimationControl.getTargetValue());
                    continue;
                }
                if (!device.getName().equalsIgnoreCase(lenses)) continue;
                device.addValueChangeListener(this.lensesControl);
                currentValue = device.getCurrValue().toString();
                this.lensesControl.setCurrentValue(currentValue);
                this.lensesControl.setFixed(device.isFixed());
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("CollimationPanel.updateDeviceControls " + e);
            }
        }
    }

    public SansDeviceControlPanel getCollimationControl() {
        return this.collimationControl;
    }

    public SansDeviceControlPanel getApertureControl() {
        return this.apertureControl;
    }

    public SansDeviceControlPanel getLensesControl() {
        return this.lensesControl;
    }

    private void configureCollimationControls(String guideState) {
        boolean futureNg3guide7 = CollimationPanel.determineGuideState("ng3", "7", guideState);
        if (guideState.equals("0")) {
            this.apertureControl.removeAllItems();
            if (this.guide01ApertValues != null) {
                this.apertureControl.addItems(this.guide01ApertValues);
            }
            this.apertureControl.setEnabled(true);
            this.lensesControl.setEnabled(true);
        } else if (guideState.equals(polarizedBeam) || futureNg3guide7) {
            this.apertureControl.removeAllItems();
            if (this.guide08ApertValues != null) {
                this.apertureControl.addItems(this.guide08ApertValues);
            }
            this.apertureControl.setEnabled(true);
            this.lensesControl.setEnabled(false);
        } else {
            this.apertureControl.setEnabled(false);
            this.lensesControl.setEnabled(false);
        }
    }

    public static boolean determineGuideState(String instrumentName, String compareToState, String currentState) {
        boolean state = false;
        String instName = Global.getInstrumentName();
        if (instName.equalsIgnoreCase(instrumentName) && currentState.equals(compareToState)) {
            state = true;
        }
        return state;
    }

    public class CollimationComboBoxActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            CollimationPanel.this.configureCollimationControls(CollimationPanel.this.collimationControl.getTargetValue());
        }
    }

    private class NewGuideConfigAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = "";
            String targetValue = CollimationPanel.this.collimationControl.getTargetValue();
            boolean ng3guide7state = CollimationPanel.determineGuideState("ng3", "7", targetValue);
            command = targetValue.equals("0") ? "move guidetable 0 guide01 " + CollimationPanel.this.apertureControl.getTargetValue() + " guide10 " + CollimationPanel.this.lensesControl.getTargetValue() : (targetValue.equals(CollimationPanel.polarizedBeam) || ng3guide7state ? "move guidetable " + targetValue + " guide08 " + CollimationPanel.this.apertureControl.getTargetValue() : "move guidetable " + targetValue);
            try {
                ClientAPI messageSender = ClientAPI.getInstance();
                QueuedCommand qCommand = new QueuedCommand(command, messageSender);
                qCommand.runAsynchronous();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String value = CollimationPanel.this.currentSampleControl.getCurrentValue();
            String trimmedValue = value.trim();
            if (trimmedValue.equals("")) {
                return;
            }
            try {
                ClientAPI messageSender = ClientAPI.getInstance();
                ImmediateCommand iCommand = new ImmediateCommand("sample setApert " + value, messageSender);
                iCommand.runAsynchronous();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

