/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.data;

import ice.data.BaseScan;
import java.util.HashMap;
import java.util.Set;

public class SansScan
extends BaseScan {
    private HashMap<String, String> angleMap;
    private HashMap<String, String> sampleMap;
    private HashMap<String, String> scanMap;

    public SansScan(BaseScan.ScanType type, String submissionID) {
        super(type, submissionID);
        this.init();
    }

    private void init() {
        this.angleMap = new HashMap();
        this.sampleMap = new HashMap();
        this.scanMap = new HashMap();
    }

    public HashMap<String, String> getSampleValues() {
        return this.sampleMap;
    }

    public HashMap<String, String> getScanValues() {
        return this.scanMap;
    }

    public HashMap<String, String> getAngleValues() {
        return this.angleMap;
    }

    public String getScanValue(String name) {
        return this.scanMap.get(name.toUpperCase());
    }

    public String getSampleValue(String name) {
        return this.sampleMap.get(name.toUpperCase());
    }

    public String getAngleValue(String name) {
        return this.angleMap.get(name.toUpperCase());
    }

    public boolean containsAngle(String name) {
        return this.angleMap.containsKey(name.toUpperCase());
    }

    public boolean containsScan(String name) {
        return this.scanMap.containsKey(name.toUpperCase());
    }

    public void addSampleValue(String name, String value) {
        this.sampleMap.put(name.toUpperCase(), value);
    }

    public void addAngleValue(String name, String value) {
        this.angleMap.put(name.toUpperCase(), value);
    }

    public void addScanValue(String name, String value) {
        this.scanMap.put(name.toUpperCase(), value);
    }

    public void updateScanValues(HashMap<String, String> newScanMap) {
        this.scanMap.clear();
        Set<String> scanSet = newScanMap.keySet();
        for (String scanProperty : scanSet) {
            String scanValue = newScanMap.get(scanProperty);
            this.scanMap.put(scanProperty, scanValue);
        }
    }

    public void updateSampleValues(HashMap<String, String> newSampleMap) {
        this.sampleMap.clear();
        Set<String> scanSet = newSampleMap.keySet();
        for (String scanProperty : scanSet) {
            String scanValue = newSampleMap.get(scanProperty);
            this.sampleMap.put(scanProperty, scanValue);
        }
    }

    public void updateAngleValues(HashMap<String, String> newAngleMap) {
        this.angleMap.clear();
        Set<String> scanSet = newAngleMap.keySet();
        for (String scanProperty : scanSet) {
            String scanValue = newAngleMap.get(scanProperty);
            this.angleMap.put(scanProperty, scanValue);
        }
    }

    public static enum AngleFields {
        Wavelength("Wavelength"),
        WavelengthSpread("WavelengthSpread"),
        Beamstop("BeamStop"),
        BeamstopY("BeamStopY"),
        BeamstopX("BeamStopX"),
        DetectorOffset("DetectorOffset"),
        DetectorDistance("DetectorPos"),
        HuberRotation("HuberRotation"),
        HuberTranslation("HuberTranslation"),
        SampleRotation("SampleRotation"),
        SamplePosition("SamplePosition"),
        GuideTable("GuideTable"),
        Guide01("Guide01"),
        Guide02("Guide02"),
        Guide03("Guide03"),
        Guide04("Guide04"),
        Guide05("Guide05"),
        Guide06("Guide06"),
        Guide07("Guide07"),
        Guide08("Guide08"),
        Guide09("Guide09"),
        Guide10("Guide10"),
        Attenuator("Attenuator"),
        Temp("Temp"),
        MagField("MagField"),
        SansMagnetCurr("SANSMagnetVoltage"),
        BeamCenterX("BeamCenterX"),
        BeamCenterY("BeamCenterY"),
        Flipper("Flipper"),
        FlipperHorizCurrent("FlipperHorizCurrent"),
        FlipperVertCurrent("FlipperVertCurrent");

        private String name;

        private AngleFields(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum DeviceType {
        angle,
        sample,
        property,
        range,
        preset_temp_tol,
        preset_temp_timeout,
        other,
        preset_sans_magnet_voltage;

    }

    public static enum SampleFields {
        Thk("Thk".toUpperCase()),
        Trans("Trans".toUpperCase());

        private String name;

        private SampleFields(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ScanFields {
        Sansstop("SANSSTOP"),
        Status("STATUS"),
        Pulses("SANSRHEOPULSES".toUpperCase());

        private String name;

        private ScanFields(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

