/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.buttons;

import ice.Controller;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.gui.core.GenericIcePanel;
import ice.gui.panel.sans.actions.DryRunListAction;
import ice.gui.panel.sans.actions.ShowRangePanelAction;
import ice.gui.panel.sans.actions.ShowSansPanelAction;
import ice.gui.panel.sans.actions.StartAutoCollectionAction;
import ice.gui.panel.sans.actions.StopInstrumentAction;
import ice.gui.panel.sans.controls.SansButtonPanelControl;
import ice.gui.panel.sans.controls.buttons.PauseButton;
import ice.gui.panel.sans.subpanels.AutoDataCollectionPanel;
import ice.gui.panel.sans.subpanels.autodata.RunListTable;
import ice.swing.buttons.KeyResponseButton;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class StartAutoCollectionButtonControlPanel
extends SansButtonPanelControl
implements InstrumentValueChangedListener {
    private PauseButton pauseBtn;
    private KeyResponseButton startBtn;
    private KeyResponseButton stopBtn;
    private KeyResponseButton backBtn;
    private JButton dryRunBtn;
    private AutoDataCollectionPanel autoPanel;
    protected boolean autoCollectionStarted;
    protected ShowRangePanelAction startPanelAction;
    protected StopInstrumentAction stopAction;
    private static final String start = "F12: Start Auto Collection";
    private static final String stop = "F10: Stop Auto Collection";
    private static final String back = "F20: Previous Menu";
    private static final String show_range = "Show Range";
    private static final String dry_run = "Dry Run";

    public StartAutoCollectionButtonControlPanel(GenericIcePanel parentPanel) {
        super(parentPanel);
    }

    @Override
    protected void init(GenericIcePanel panel) {
        super.init(panel);
        this.autoCollectionStarted = false;
        this.autoPanel = (AutoDataCollectionPanel)panel;
        RunListTable runTableList = this.autoPanel.getTableManager();
        this.startBtn = new KeyResponseButton(start, start, 115);
        this.addToClearsErrors(this.startBtn);
        this.stopBtn = new KeyResponseButton(stop, stop, 113);
        this.addToClearsErrors(this.stopBtn);
        this.pauseBtn = new PauseButton("F11: Pause Auto Collection", "F11: Pause Auto Collection", 114);
        this.pauseBtn.setEnabled(false);
        this.backBtn = new KeyResponseButton(back, back, 123);
        this.dryRunBtn = new JButton(dry_run);
        this.addToDoNotEnableDisableOnIdleOrBusy(this.dryRunBtn);
        Controller controller = Controller.getReference();
        Instrument instrument = controller.getInstrument();
        try {
            instrument.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("StartAutCollectionButtonControlPanel.init " + e);
        }
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        InputMap inputMap = this.getInputMap(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTable table = this.autoPanel.getRunListTableControl();
        RunListTable tableManager = this.autoPanel.getTableManager();
        this.stopAction = new StopInstrumentAction();
        this.stopBtn.addActionListener(this.stopAction);
        StartAutoCollectionAction startAction = new StartAutoCollectionAction(start, 115);
        this.startPanelAction = new ShowRangePanelAction(startAction, table);
        this.startBtn.addActionListener(this.startPanelAction);
        DryRunListAction dryRunAction = new DryRunListAction(dry_run, tableManager);
        ShowRangePanelAction showDryRunRangeAction = new ShowRangePanelAction(dryRunAction, table);
        this.dryRunBtn.addActionListener(showDryRunRangeAction);
        this.dryRunBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.dryRunBtn, gridBagConstraints);
        this.startBtn.setHorizontalAlignment(2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.stopBtn.setEnabled(false);
        this.stopBtn.setVisible(false);
        this.add((Component)this.stopBtn, gridBagConstraints);
        this.add((Component)this.startBtn, gridBagConstraints);
        this.pauseBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pauseBtn, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        ShowSansPanelAction backAction = new ShowSansPanelAction("MainMenu");
        this.backBtn.addActionListener(backAction);
        this.backBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.backBtn, gridBagConstraints);
        this.readButtonHintsFromPreferenceFile();
    }

    @Override
    public synchronized void actionPerformed(InstrumentValueChangedEvent event) {
        Instrument instrument = (Instrument)event.getSource();
        String propertyName = event.getPropertyName();
        if ("state".equals(propertyName)) {
            if (instrument.getState() == Instrument.State.idle) {
                if (this.autoCollectionStarted) {
                    this.autoCollectionStarted = false;
                    String hint = "Start";
                    this.stopBtn.setEnabled(false);
                    this.stopBtn.setVisible(false);
                    this.startBtn.setEnabled(true);
                    this.startBtn.setVisible(true);
                    this.pauseBtn.setEnabled(false);
                    this.backBtn.setEnabled(true);
                    this.invalidate();
                    this.updateUI();
                }
            } else if (!(instrument.getState() != Instrument.State.busy && instrument.getState() != Instrument.State.scan || this.autoCollectionStarted)) {
                this.autoCollectionStarted = true;
                this.startBtn.setEnabled(false);
                this.startBtn.setVisible(false);
                this.stopBtn.setEnabled(true);
                this.stopBtn.setVisible(true);
                this.pauseBtn.setEnabled(true);
                this.backBtn.setEnabled(false);
                this.invalidate();
                this.updateUI();
            }
        }
    }
}

