/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.data.InstalledDevice;
import ice.event.NumberOutOfRangeListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.gui.panel.sans.controls.SansDeviceWithScaleControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.gui.panel.sans.swing.SANSIntegerFormattedTextField;
import ice.swing.textFields.ICEDecimalFormattedTextField;
import ice.swing.textFields.ICEFormattedTextFieldBase;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;

public class SansDeviceWithScaleDoubleControlPanel
extends SansDeviceWithScaleControlPanel
implements NumberOutOfRangeListener {
    protected static final int DEFAULT_NUMBER_OF_FRACTIION_DIGITS = 3;
    protected NumberOutOfRangeListener.NumberRange tranState;
    protected NumberOutOfRangeListener.NumberRange targetState;

    public SansDeviceWithScaleDoubleControlPanel(String name, String deviceName, String scaleDeviceName, String units) {
        super(name, deviceName, scaleDeviceName, units);
    }

    public SansDeviceWithScaleDoubleControlPanel(String name, String deviceName, String scaleDeviceName, String units, boolean showFixed) {
        super(name, deviceName, scaleDeviceName, units, showFixed);
    }

    public void listenToTargetEmptyDocumentEvent(SansIcePanel sansIcePanel) {
        ((ICEFormattedTextFieldBase)this.targetValueTextField).addEmptyDocumentListener(sansIcePanel);
    }

    public void listenToTargetTranEmptyDocumentEvent(SansIcePanel sansIcePanel) {
        ((ICEFormattedTextFieldBase)this.targetTranValueField).addEmptyDocumentListener(sansIcePanel);
    }

    public void listenToTargetsEmptyDocumentEvents(SansIcePanel sansIcePanel) {
        this.listenToTargetEmptyDocumentEvent(sansIcePanel);
        this.listenToTargetTranEmptyDocumentEvent(sansIcePanel);
    }

    @Override
    protected JTextField instantiateTargetTranField() {
        SANSDecimalFormattedTextField textField = null;
        textField = new SANSDecimalFormattedTextField(3);
        textField.addNumberOutOfRangeListener(this);
        return textField;
    }

    @Override
    protected JTextField instantiateCurrentTranField() {
        SANSDecimalFormattedTextField textField = null;
        textField = new SANSDecimalFormattedTextField(3);
        return textField;
    }

    @Override
    protected JTextField instantiateTargetField() {
        SANSDecimalFormattedTextField textField = null;
        textField = new SANSDecimalFormattedTextField(3);
        textField.addNumberOutOfRangeListener(this);
        return textField;
    }

    @Override
    protected JTextField instantiateCurrentField() {
        SANSDecimalFormattedTextField textField = null;
        textField = new SANSDecimalFormattedTextField(3);
        return textField;
    }

    @Override
    protected void init() {
        super.init();
        this.tranState = NumberOutOfRangeListener.NumberRange.NOT_A_NUMBER;
        this.targetState = NumberOutOfRangeListener.NumberRange.NOT_A_NUMBER;
    }

    public void setTargetMinMax(double min, double max) {
        ((ICEDecimalFormattedTextField)this.targetValueTextField).setMinValue(min);
        ((ICEDecimalFormattedTextField)this.targetValueTextField).setMaxValue(max);
    }

    public void setTargetTranMinMax(double min, double max) {
        ((ICEDecimalFormattedTextField)this.targetTranValueField).setMinValue(min);
        ((ICEDecimalFormattedTextField)this.targetTranValueField).setMaxValue(max);
    }

    @Override
    protected void doDeviceLowerLimitPropertyChanged(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        Double min = changedDevice.getLowerLimit();
        if (changedDevice.getName().equalsIgnoreCase(this.deviceName)) {
            ((ICEDecimalFormattedTextField)this.targetValueTextField).setMinValue(min);
        } else if (changedDevice.getName().equalsIgnoreCase(this.scaleDeviceName)) {
            if (this.targetTranValueField instanceof ICEDecimalFormattedTextField) {
                ((ICEDecimalFormattedTextField)this.targetTranValueField).setMinValue(min);
            } else if (this.targetTranValueField instanceof SANSIntegerFormattedTextField) {
                ((SANSIntegerFormattedTextField)this.targetTranValueField).setMinValue(min.longValue());
            }
        }
    }

    @Override
    protected void doDeviceUpperLimitPropertyChanged(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        Double max = changedDevice.getUpperLimit();
        if (changedDevice.getName().equalsIgnoreCase(this.deviceName)) {
            ((ICEDecimalFormattedTextField)this.targetValueTextField).setMaxValue(max);
        } else if (changedDevice.getName().equalsIgnoreCase(this.scaleDeviceName)) {
            if (this.targetTranValueField instanceof ICEDecimalFormattedTextField) {
                ((ICEDecimalFormattedTextField)this.targetTranValueField).setMaxValue(max);
            } else if (this.targetTranValueField instanceof SANSIntegerFormattedTextField) {
                ((SANSIntegerFormattedTextField)this.targetTranValueField).setMaxValue(max.longValue());
            }
        }
    }

    @Override
    public void handleOutOfRangeNumber(NumberOutOfRangeListener.NumberOutOfRangeEvent numberOutOfRangeEvent) {
        ComponentEvent detectedOn = numberOutOfRangeEvent.getDetectedOn();
        NumberOutOfRangeListener.NumberRange state = numberOutOfRangeEvent.getState();
        Object source = numberOutOfRangeEvent.getTheSource();
        if (detectedOn instanceof FocusEvent) {
            int id = ((FocusEvent)detectedOn).getID();
            if (id == 1005 && state == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE && (source == this.targetValueTextField || source == this.targetTranValueField)) {
                SansIcePanel parent = this.getSansIcePanelParent();
                String message = source == this.targetValueTextField ? "Target" : "Translation";
                message = String.valueOf(message) + " for " + this.getDeviceName() + " out of range. The value must be between " + numberOutOfRangeEvent.getMin() + " and " + numberOutOfRangeEvent.getMax() + ".";
                parent.setErrorText(message);
            } else if (id == 1005 && state == NumberOutOfRangeListener.NumberRange.IN_RANGE && (source == this.targetValueTextField || source == this.targetTranValueField)) {
                SansIcePanel parent = this.getSansIcePanelParent();
                String message = source == this.targetValueTextField ? "Target" : "Translation";
                message = String.valueOf(message) + " for " + this.getDeviceName() + " out of range. The value must be between " + numberOutOfRangeEvent.getMin() + " and " + numberOutOfRangeEvent.getMax() + ".";
                parent.clearErrors(message);
            }
        }
    }

    public void setNumberOfFractionDigits(int numberOfFractionDigits) {
        ((ICEDecimalFormattedTextField)this.targetValueTextField).setNumberOfFractionDigits(numberOfFractionDigits);
        ((ICEDecimalFormattedTextField)this.currentValueField).setNumberOfFractionDigits(numberOfFractionDigits);
        ((ICEDecimalFormattedTextField)this.currTranValueField).setNumberOfFractionDigits(numberOfFractionDigits);
        ((ICEDecimalFormattedTextField)this.targetTranValueField).setNumberOfFractionDigits(numberOfFractionDigits);
    }
}

