/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.util.HelpPropertiesManager;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public abstract class SansDeviceControlPanel
extends JPanel
implements InstrumentValueChangedListener,
DeviceValueChangedListener {
    protected String controlName;
    protected String deviceName;
    protected String propertyName;
    protected String propertyType;
    protected String units;
    protected String hint;
    protected Container controlParent;
    protected boolean fixed;
    protected boolean disabled;
    SansScan.DeviceType type;
    protected boolean showFixed;
    protected String scanValue;
    protected Hashtable<Component, Boolean> controllStates;
    protected Vector<Component> ignoreUs;
    protected boolean hasBeenTurnedOff;

    public SansDeviceControlPanel(String name, String deviceName) {
        this.controlName = name;
        this.deviceName = deviceName;
        this.showFixed = true;
        this.units = " ";
        this.type = SansScan.DeviceType.other;
        this.scanValue = "";
        this.fixed = false;
        this.disabled = false;
        this.propertyType = "currValue";
        this.init();
        this.buildGUI();
    }

    public SansDeviceControlPanel(String name, String deviceName, String propertyName, String units) {
        this.controlName = name;
        this.deviceName = deviceName;
        this.showFixed = true;
        this.units = units;
        this.type = SansScan.DeviceType.other;
        this.scanValue = "";
        this.propertyName = propertyName;
        this.fixed = false;
        this.disabled = false;
        this.propertyType = "currValue";
        this.init();
        this.buildGUI();
    }

    public SansDeviceControlPanel(String name, String deviceName, String propertyName, String propertyType, String units) {
        this.controlName = name;
        this.deviceName = deviceName;
        this.showFixed = true;
        this.units = units;
        this.type = SansScan.DeviceType.other;
        this.scanValue = "";
        this.propertyName = propertyName;
        this.fixed = false;
        this.disabled = false;
        this.propertyType = propertyType;
        this.init();
        this.buildGUI();
    }

    public SansDeviceControlPanel(String name, String deviceName, boolean showFixed) {
        this.showFixed = showFixed;
        this.controlName = name;
        this.deviceName = deviceName;
        this.units = " ";
        this.type = SansScan.DeviceType.other;
        this.scanValue = "";
        this.fixed = false;
        this.disabled = false;
        this.propertyType = "currValue";
        this.init();
        this.buildGUI();
    }

    public SansDeviceControlPanel(String name, String deviceName, String units) {
        this.showFixed = true;
        this.controlName = name;
        this.deviceName = deviceName;
        this.units = units;
        this.type = SansScan.DeviceType.other;
        this.scanValue = "";
        this.fixed = false;
        this.disabled = false;
        this.propertyType = "currValue";
        this.init();
        this.buildGUI();
    }

    public SansDeviceControlPanel(String name, String deviceName, SansScan.DeviceType type) {
        this.showFixed = true;
        this.controlName = name;
        this.deviceName = deviceName;
        this.units = " ";
        this.type = type;
        this.scanValue = "";
        this.fixed = false;
        this.disabled = false;
        this.propertyType = "currValue";
        this.init();
        this.buildGUI();
    }

    public SansDeviceControlPanel(String name, String deviceName, String units, boolean showFixed) {
        this.showFixed = showFixed;
        this.controlName = name;
        this.deviceName = deviceName;
        this.units = units;
        this.type = SansScan.DeviceType.other;
        this.scanValue = "";
        this.fixed = false;
        this.disabled = false;
        this.propertyType = "currValue";
        this.init();
        this.buildGUI();
    }

    protected void init() {
        Controller controller = null;
        Instrument instrument = null;
        controller = Controller.getReference();
        instrument = controller.getInstrument();
        try {
            instrument.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("SansDeviceControlPanel.init " + e);
        }
        this.controllStates = new Hashtable();
        this.ignoreUs = new Vector();
        this.hasBeenTurnedOff = false;
        this.hint = "";
        this.controlParent = null;
    }

    protected abstract void buildGUI();

    public abstract void setCurrentValue(String var1);

    public abstract String getCurrentValue();

    public abstract void setTargetValue(String var1);

    public abstract String getTargetValue();

    protected boolean inAutoDimComponents(Component comp) {
        return comp instanceof JButton || comp instanceof JComboBox || comp instanceof JCheckBox || comp instanceof JTextField;
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        boolean autoDim = this.inAutoDimComponents(comp);
        if (autoDim) {
            boolean theState = false;
            theState = ((JComponent)comp).isEnabled();
            this.controllStates.put(comp, theState);
        }
    }

    public void addToDoNotEnableDisableOnIdleOrBusy(JComponent ignoreMe) {
        this.ignoreUs.add(ignoreMe);
    }

    public void addToDoNotEnableDisableOnIdleOrBusy(Component[] ignoreMeList) {
        Component[] componentArray = ignoreMeList;
        int n = ignoreMeList.length;
        int n2 = 0;
        while (n2 < n) {
            Component ignoreMe = componentArray[n2];
            this.ignoreUs.add(ignoreMe);
            ++n2;
        }
    }

    public void removeFromDoNotEnableDisableOnIdleOrBusy(JComponent ignoreMe) {
        this.ignoreUs.remove(ignoreMe);
    }

    public void removeFromDoNotEnableDisableOnIdleOrBusy(Component[] ignoreMeList) {
        Component[] componentArray = ignoreMeList;
        int n = ignoreMeList.length;
        int n2 = 0;
        while (n2 < n) {
            Component ignoreMe = componentArray[n2];
            this.ignoreUs.remove(ignoreMe);
            ++n2;
        }
    }

    protected void handleInstrumentStateChange(Instrument.State newState) {
        Component[] components = this.getComponents();
        switch (newState) {
            case busy: {
                if (this.hasBeenTurnedOff) break;
                this.hasBeenTurnedOff = true;
                boolean state = false;
                Component[] componentArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean ignoreMe;
                    Component component = componentArray[n2];
                    boolean autoDim = this.inAutoDimComponents(component);
                    if (autoDim && !(ignoreMe = this.ignoreUs.contains(component))) {
                        state = ((JComponent)component).isEnabled();
                        this.controllStates.put(component, state);
                        ((JComponent)component).setEnabled(false);
                    }
                    ++n2;
                }
                break;
            }
            case idle: {
                this.hasBeenTurnedOff = false;
                Component[] componentArray = components;
                int n = components.length;
                int n3 = 0;
                while (n3 < n) {
                    boolean ignoreMe;
                    Component component = componentArray[n3];
                    boolean autoDim = this.inAutoDimComponents(component);
                    if (autoDim && !(ignoreMe = this.ignoreUs.contains(component))) {
                        Boolean savedState = false;
                        savedState = this.controllStates.get((JComponent)component);
                        ((JComponent)component).setEnabled(savedState);
                    }
                    ++n3;
                }
                break;
            }
        }
    }

    public void doInstrumentStatePropertyChange(PropertyChangeEvent evt) {
        Instrument.State oldState;
        Instrument.State newState = (Instrument.State)((Object)evt.getNewValue());
        if (newState != (oldState = (Instrument.State)((Object)evt.getOldValue()))) {
            this.handleInstrumentStateChange(newState);
        }
    }

    public void doDeviceAdditionalPropertiesFieldNameChanged(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        String propValue = changedDevice.getAdditionalPropertyValue(this.propertyName);
        this.setCurrentValue(propValue);
    }

    public void doDeviceCurrentValuePropertyChanged(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        String currentValue = changedDevice.getCurrValue();
        this.setCurrentValue(currentValue);
    }

    public void doSomeOtherPropertyChanged(PropertyChangeEvent evt) {
    }

    protected void doDeviceLowerLimitPropertyChanged(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        Double currentValue = changedDevice.getLowerLimit();
        this.setLowerLimit(currentValue);
    }

    protected void setLowerLimit(Double currentValue) {
    }

    protected void doDeviceUpperLimitPropertyChanged(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        Double currentValue = changedDevice.getUpperLimit();
        this.setUpperLimit(currentValue);
    }

    protected void setUpperLimit(Double currentValue) {
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        Object source = evt.getSource();
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        if (changedDevice.getName().equalsIgnoreCase(this.deviceName)) {
            if (this.propertyName != null) {
                if (evt.getPropertyName().equalsIgnoreCase("extras")) {
                    this.doDeviceAdditionalPropertiesFieldNameChanged(evt);
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("currValue")) {
                this.doDeviceCurrentValuePropertyChanged(evt);
            } else if (evt.getPropertyName().equalsIgnoreCase("fixed")) {
                this.doDeviceFixedPropertyChanged(evt);
            } else if (evt.getPropertyName().equalsIgnoreCase("upperLimit")) {
                this.doDeviceUpperLimitPropertyChanged(evt);
            } else if (evt.getPropertyName().equalsIgnoreCase("lowerLimit")) {
                this.doDeviceLowerLimitPropertyChanged(evt);
            }
        }
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent evt) {
        String propertyName;
        Object source = evt.getSource();
        if (source instanceof Instrument && (propertyName = evt.getPropertyName()).equals("state")) {
            this.doInstrumentStatePropertyChange(evt);
        }
        this.doSomeOtherPropertyChanged(evt);
    }

    public void doDeviceFixedPropertyChanged(PropertyChangeEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        Boolean isFixed = changedDevice.isFixed();
        this.setFixed(isFixed);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = null;
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.setEnabled(enabled);
            ++n2;
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public SansScan.DeviceType getDeviceType() {
        return this.type;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public String getScanValue() {
        if (this.scanValue == null) {
            this.scanValue = "";
        }
        return this.scanValue;
    }

    public void setScanValue(String scanValue) {
        this.scanValue = scanValue;
    }

    public String getControlName() {
        return this.controlName;
    }

    public void setControlName(String controlName) {
        this.controlName = controlName;
    }

    public SansIcePanel getSansIcePanelParent() {
        SansIcePanel returnValue = null;
        Container parent = null;
        parent = this;
        while (!((parent = parent.getParent()) instanceof SansIcePanel) && parent != null) {
        }
        returnValue = (SansIcePanel)parent;
        return returnValue;
    }

    public void clearTargetValue() {
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void readHintsFromPreferenceFile() {
        String name = this.controlName.replace(" ", "");
        name = name.replace(":", "");
        String key = String.valueOf(this.getParent().getClass().getName()) + "." + this.getClass().getSimpleName() + "." + name + ".hint";
        String controlHint = HelpPropertiesManager.getPreferenceString(key);
        if (!controlHint.equals("undefined")) {
            this.setHint(controlHint);
        }
    }

    public Container getControlParent() {
        return this.controlParent;
    }

    public void setControlParent(Container controlParent) {
        this.controlParent = controlParent;
    }

    public void setControlParent() {
        this.controlParent = this.findParent(this.getParent());
    }

    private Container findParent(Container component) {
        if (component == null) {
            return null;
        }
        if (component instanceof SansIcePanel) {
            return component;
        }
        return this.findParent(component.getParent());
    }

    public void removeFromDeviceValueChangeListenerList() {
        Controller controller = Controller.getReference();
        InstalledDevice device = controller.getFirstDevice(this.deviceName);
        if (device != null) {
            device.removeValueChangeListener(this);
        }
    }

    public void addToDeviceValueChangeListenerList(String deviceName) {
        Controller controller = Controller.getReference();
        InstalledDevice device = controller.getFirstDevice(deviceName);
        if (device != null) {
            this.deviceName = deviceName;
            this.setFixed(device.isFixed());
            String currentValue = device.getCurrValue().toString();
            this.setCurrentValue(currentValue);
            try {
                device.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                e.printStackTrace();
            }
        }
    }
}

