/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.gui.panel.sans.communication.FixDeviceActionListener;
import ice.gui.panel.sans.controls.JSansCheckBox;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.events.SansInputControlFocusListener;
import ice.util.HelpPropertiesManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SansDeviceControlNoScalePanel
extends SansDeviceControlPanel {
    private JLabel currentLabel;
    protected JTextField currentValueLabel;
    private JCheckBox fixedBox;
    private JLabel samplePosLabel;
    protected JLabel targetLabel;
    protected JTextField targetValueTextField;
    private JLabel unitCLabel;
    private JLabel unitTLabel;

    public SansDeviceControlNoScalePanel(String name, String deviceName) {
        super(name, deviceName);
    }

    public SansDeviceControlNoScalePanel(String name, String deviceName, boolean showFixed) {
        super(name, deviceName, showFixed);
    }

    public SansDeviceControlNoScalePanel(String name, String deviceName, String units) {
        super(name, deviceName, units);
    }

    public void addKeyListenerToTarget(KeyListener l) {
        this.targetValueTextField.addKeyListener(l);
    }

    public void removeKeyListenerFromTarget(KeyListener l) {
        this.targetValueTextField.removeKeyListener(l);
    }

    public KeyListener[] getTargetsKeyListeners() {
        KeyListener[] keyListeners = null;
        keyListeners = this.targetValueTextField.getKeyListeners();
        return keyListeners;
    }

    public void addTargetsKeyListeners(KeyListener[] keyListeners) {
        KeyListener[] keyListenerArray = keyListeners;
        int n = keyListeners.length;
        int n2 = 0;
        while (n2 < n) {
            KeyListener l = keyListenerArray[n2];
            this.targetValueTextField.addKeyListener(l);
            ++n2;
        }
    }

    public void removeTargetKeyListeners() {
        KeyListener[] kl = this.targetValueTextField.getKeyListeners();
        if (kl != null) {
            KeyListener[] keyListenerArray = kl;
            int n = kl.length;
            int n2 = 0;
            while (n2 < n) {
                KeyListener l = keyListenerArray[n2];
                this.targetValueTextField.removeKeyListener(l);
                ++n2;
            }
        }
    }

    protected JTextField instantiateTargetField() {
        return new JTextField();
    }

    protected JTextField instantiateCurrentField() {
        return new JTextField();
    }

    @Override
    protected void init() {
        super.init();
        this.samplePosLabel = new JLabel();
        this.currentLabel = new JLabel();
        this.targetLabel = new JLabel();
        this.targetValueTextField = this.instantiateTargetField();
        this.currentValueLabel = this.instantiateCurrentField();
        this.fixedBox = new JSansCheckBox();
        this.unitCLabel = new JLabel();
        this.unitTLabel = new JLabel();
        this.targetValueTextField.addFocusListener(new SansInputControlFocusListener());
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.samplePosLabel.setText(this.controlName);
        this.samplePosLabel.setPreferredSize(new Dimension(140, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.samplePosLabel, gridBagConstraints);
        this.currentLabel.setText("Current");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.currentLabel, gridBagConstraints);
        this.currentValueLabel.setEditable(false);
        this.currentValueLabel.setText("");
        this.currentValueLabel.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.currentValueLabel, gridBagConstraints);
        if (this.showFixed) {
            this.fixedBox.setText("Fixed");
            this.fixedBox.addActionListener(new FixDeviceActionListener(this));
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            this.add((Component)this.fixedBox, gridBagConstraints);
        }
        gridBagConstraints.anchor = 17;
        this.targetLabel.setText("Target");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.targetLabel, gridBagConstraints);
        this.targetValueTextField.setText("");
        this.targetValueTextField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.targetValueTextField, gridBagConstraints);
        this.unitCLabel.setText(this.units);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.unitCLabel, gridBagConstraints);
        this.unitTLabel.setText(this.units);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.unitTLabel, gridBagConstraints);
    }

    @Override
    public void setCurrentValue(String value) {
        this.currentValueLabel.setText(value);
    }

    public void setCurrentUnits(String units) {
        this.unitCLabel.setText(units);
    }

    public void setTargetUnits(String units) {
        this.unitTLabel.setText(units);
    }

    @Override
    public void setTargetValue(String value) {
        this.targetValueTextField.setText(value);
    }

    @Override
    public String getTargetValue() {
        String targetValue = this.targetValueTextField.getText();
        return targetValue;
    }

    @Override
    public String getCurrentValue() {
        String currentValue = this.currentValueLabel.getText();
        return currentValue;
    }

    public void clickFixed() {
        this.fixedBox.doClick();
    }

    @Override
    public void setFixed(boolean isFixed) {
        super.setFixed(isFixed);
        this.fixedBox.setSelected(isFixed);
    }

    @Override
    public void clearTargetValue() {
        this.targetValueTextField.setText("");
    }

    @Override
    public void readHintsFromPreferenceFile() {
        super.readHintsFromPreferenceFile();
        String name1 = this.fixedBox.getClass().getSimpleName();
        name1 = name1.replace(" ", "");
        String key1 = String.valueOf(this.getParent().getClass().getName()) + "." + this.getClass().getSimpleName() + "." + this.controlName + "." + name1 + ".hint";
        String controlHint1 = HelpPropertiesManager.getPreferenceString(key1);
        if (!controlHint1.equals("undefined")) {
            ((JSansCheckBox)this.fixedBox).setHint(controlHint1);
        }
    }
}

