/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.ClientAPI;
import ice.Controller;
import ice.commands.ImmediateCommand;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.events.SansInputControlFocusListener;
import ice.gui.panel.sans.subpanels.SansCommandManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class SampleChangerControlPanel
extends SansDeviceControlPanel {
    private static final long serialVersionUID = 6346610707459100154L;
    public static final String SET_ACTION = "Set";
    private static Logger logger = Logger.getLogger("ErrorLogger");
    private static final String defaultSampleChanger = "defaultSampleChanger";
    private JComboBox sampleHolderCBox;
    private JLabel sampleHolderLabel;
    private DefaultComboBoxModel boxModel;
    protected JButton setButton;

    public SampleChangerControlPanel(String name, String deviceName) {
        super(name, deviceName);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.sampleHolderLabel.setText(this.controlName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.sampleHolderLabel, gridBagConstraints);
        this.boxModel = new DefaultComboBoxModel();
        this.sampleHolderCBox.setModel(this.boxModel);
        this.add((Component)this.sampleHolderCBox, gridBagConstraints);
        this.setButton.addActionListener(new SetActionListener());
        this.add((Component)this.setButton, gridBagConstraints);
        Controller controller = Controller.getReference();
        Instrument instrument = controller.getInstrument();
        String sampleHolder = instrument.getDefaultSampleChanger();
        String[] holderPositions = instrument.getSampleHolderPositions();
        if (holderPositions != null) {
            int i = 0;
            while (i < holderPositions.length) {
                this.boxModel.addElement(holderPositions[i]);
                ++i;
            }
        }
        this.boxModel.setSelectedItem(sampleHolder);
        this.sampleHolderCBox.addFocusListener(new SansInputControlFocusListener());
    }

    @Override
    protected void init() {
        super.init();
        this.sampleHolderLabel = new JLabel();
        this.sampleHolderCBox = new JComboBox();
        this.setButton = new JButton(SET_ACTION);
    }

    @Override
    public String getCurrentValue() {
        return (String)this.boxModel.getSelectedItem();
    }

    @Override
    public String getTargetValue() {
        return null;
    }

    @Override
    public void setCurrentValue(String value) {
        this.boxModel.setSelectedItem(value);
    }

    @Override
    public void setTargetValue(String value) {
    }

    private void sampleHolderCBoxItemChanged(ActionEvent evt) {
        String selectedBlock = (String)this.sampleHolderCBox.getSelectedItem();
        if (selectedBlock.equals("N/A")) {
            return;
        }
        String sampleBlock = selectedBlock.replace(' ', '-');
        String command = "instrument setparam defaultSampleChanger " + sampleBlock;
        SansCommandManager.takeQueuedAction(command);
    }

    private String getCurrentSampleHolder() {
        String command = "instrument getparam defaultSampleChanger ";
        String sampleHolder = "";
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            ImmediateCommand iCommand = new ImmediateCommand(command, messageSender);
            iCommand.getLabel();
            iCommand.runSynchronous();
            String response = iCommand.getResponse();
            String[] value = response.split("=");
            sampleHolder = value[1];
        }
        catch (Exception e) {
            logger.error("Error while executing a command...", e.getCause());
            e.printStackTrace();
        }
        return sampleHolder;
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent event) {
        super.actionPerformed(event);
        Object source = event.getSource();
        String propertyName = event.getPropertyName();
        if (propertyName.equals(defaultSampleChanger)) {
            String newHolder = (String)event.getNewValue();
            this.boxModel.setSelectedItem(newHolder);
        }
    }

    public void setCurrentSampleHolder() {
        Controller controller = Controller.getReference();
        Instrument instrument = controller.getInstrument();
        String sampleHolder = instrument.getDefaultSampleChanger();
        this.boxModel.setSelectedItem(sampleHolder);
    }

    private class SetActionListener
    implements ActionListener {
        private SetActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String selectedBlock = (String)SampleChangerControlPanel.this.sampleHolderCBox.getSelectedItem();
            if (selectedBlock.equals("N/A")) {
                return;
            }
            String sampleBlock = selectedBlock.replace(' ', '-');
            String command = "instrument setparam defaultSampleChanger " + sampleBlock;
            SansCommandManager.takeQueuedAction(command);
        }
    }
}

